/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import it.tnx.commons.FormatUtils;
import it.tnx.commons.MathUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class DebugFastUtils {
    public static void dump(Object obj) {
        System.out.println(DebugFastUtils.dumpAsString(obj));
    }

    public static String dumpAsString(Object obj) {
        return DebugFastUtils.dumpAsString(obj, 0);
    }

    public static String dumpAsString(Object obj, int level) {
        StringBuilder out;
        block40: {
            if (obj == null) {
                return "";
            }
            out = new StringBuilder();
            if (obj instanceof Object[]) {
                for (Object o : (Object[])obj) {
                    out.append(DebugFastUtils.dumpAsString(o, level));
                }
            } else if (obj instanceof Collection) {
                for (Object o : (Collection)obj) {
                    out.append(DebugFastUtils.dumpAsString(o, level));
                }
            } else if (obj instanceof Vector) {
                for (Object o : (Vector)obj) {
                    out.append(DebugFastUtils.dumpAsString(o, level));
                }
            } else if (obj instanceof Map) {
                out.append(DebugFastUtils.dumpAsString(obj.toString(), level));
            } else if (obj instanceof Enumeration) {
                Enumeration e = (Enumeration)obj;
                while (e.hasMoreElements()) {
                    out.append(DebugFastUtils.dumpAsString(e.nextElement(), level));
                }
            } else if (obj instanceof ResultSet) {
                try {
                    int c;
                    ResultSet r = (ResultSet)obj;
                    ResultSetMetaData m = r.getMetaData();
                    for (c = 1; c <= m.getColumnCount(); ++c) {
                        out.append(FormatUtils.fill(m.getColumnName(c), MathUtils.inRange(m.getColumnDisplaySize(c), 6, 30)));
                        out.append("|");
                    }
                    out.append("\n");
                    if (r.getRow() == 0) {
                        while (r.next()) {
                            for (c = 1; c <= m.getColumnCount(); ++c) {
                                out.append(FormatUtils.fill(r.getString(c), MathUtils.inRange(m.getColumnDisplaySize(c), 6, 30)));
                                out.append("|");
                            }
                            out.append("\n");
                        }
                        r.beforeFirst();
                        break block40;
                    }
                    for (c = 1; c <= m.getColumnCount(); ++c) {
                        out.append(FormatUtils.fill(r.getString(c), MathUtils.inRange(m.getColumnDisplaySize(c), 6, 30)));
                        out.append("|");
                    }
                    out.append("\n");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (obj instanceof String) {
                out.append((String)obj);
                out.append("\n");
            } else {
                Method[] methods;
                for (int i = 0; i < level; ++i) {
                    out.append("\t");
                }
                out.append(obj);
                out.append("\n");
                for (Method m : methods = obj.getClass().getMethods()) {
                    if (!m.getName().startsWith("get") && !m.getName().startsWith("is") || m.getParameterTypes().length != 0 || m.getName().equalsIgnoreCase("getClass")) continue;
                    try {
                        Object ret = m.invoke(obj, new Object[0]);
                        if (ret instanceof Object[]) {
                            for (int i = 0; i < level; ++i) {
                                out.append("\t");
                            }
                            out.append("\t");
                            out.append(m.getName());
                            for (Object o : (Object[])ret) {
                                out.append(DebugFastUtils.dumpAsString(o, level + 1));
                            }
                            continue;
                        }
                        if (ret instanceof Collection) {
                            for (int i = 0; i < level; ++i) {
                                out.append("\t");
                            }
                            out.append("\t");
                            out.append(m.getName());
                            for (Object o : (Collection)ret) {
                                out.append(DebugFastUtils.dumpAsString(o, level + 1));
                            }
                            continue;
                        }
                        for (int i = 0; i < level; ++i) {
                            out.append("\t");
                        }
                        out.append("\t");
                        out.append(m.getName());
                        out.append(":\t");
                        out.append(String.valueOf(ret));
                        out.append("\n");
                    }
                    catch (IllegalAccessException ex) {
                    }
                    catch (IllegalArgumentException ex) {
                    }
                    catch (InvocationTargetException ex) {
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
        return out.toString();
    }

    public static void trace(String startsWith, String message) {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        System.out.println("TRACE: " + message);
        for (StackTraceElement e : stacks) {
            if (!e.getClassName().startsWith(startsWith)) continue;
            System.out.println("TRACE: \t\t" + e.toString());
        }
    }

    public static void dumpMem() {
        System.out.println(DebugFastUtils.getMem());
    }

    public static String getMem() {
        double f = (double)Runtime.getRuntime().freeMemory() / 1024.0 / 1024.0;
        double t = (double)Runtime.getRuntime().totalMemory() / 1024.0 / 1024.0;
        double m = (double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0;
        double u = t - f;
        String out = "dumpMem: max: " + FormatUtils.formatPerc(m) + " tot:" + FormatUtils.formatPerc(t) + " free:" + FormatUtils.formatPerc(f) + " in use:" + FormatUtils.formatPerc(u);
        return out;
    }

    public static long getSize(Object obj) {
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        Object xenc = null;
        try {
            File f = File.createTempFile("java_debug_utils_", ".ser");
            System.err.println("getSize f = " + f);
            fos = new FileOutputStream(f);
            out = new ObjectOutputStream(fos);
            out.writeObject(obj);
            out.close();
            return f.length();
        }
        catch (Exception ex) {
            System.err.println("ex = " + ex);
            return 0L;
        }
    }

    public static void hexDump(String todump) {
        System.out.println("todump:" + todump + " stringToHex:" + DebugFastUtils.stringToHex(todump));
    }

    public static void hexDump(byte[] todump) {
        System.out.println("todump:" + todump + " stringToHex:" + DebugFastUtils.bytesToHex(todump));
    }

    public static String stringToHex(String todump) {
        int BYTES_PER_LINE = 16;
        String out = "";
        for (int i = 0; i < todump.length(); ++i) {
            if (BYTES_PER_LINE == 0) continue;
            if (i == 0) {
                out = out + "";
            }
            out = i % BYTES_PER_LINE == 0 ? out + "\n" + StringUtils.replace((String)todump.substring(i, todump.length() < i + BYTES_PER_LINE ? todump.length() : i + BYTES_PER_LINE), (String)"\n", (String)"*") + " > " : out + " ";
            char c = todump.charAt(i);
            out = out + String.format("%02x", c & 0xFF).toUpperCase();
        }
        return out;
    }

    public static String bytesToHex(byte[] todump) {
        int BYTES_PER_LINE = 16;
        String out = "";
        for (int i = 0; i < todump.length; ++i) {
            if (BYTES_PER_LINE == 0) continue;
            out = i == 0 ? out + "" : out + " ";
            char c = (char)todump[i];
            out = out + String.format("%02x", c & 0xFF).toUpperCase();
        }
        return out;
    }

    public static void main(String[] args) {
        HashMap<String, Object> test = new HashMap<String, Object>();
        test.put("voce1", "asasasa");
        test.put("voce2", 323232);
        test.put("voce3", 32332);
        DebugFastUtils.dump(test);
    }
}

