/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import com.sdicons.json.model.JSONObject;
import it.tnx.commons.CastUtils;
import it.tnx.commons.DateUtils;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.JUtil;
import it.tnx.commons.MathUtils;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JTable;
import org.apache.commons.lang.StringUtils;

public class DebugUtils {
    public static void dump(Object obj) {
        System.out.println(DebugUtils.dumpAsString(obj));
    }

    public static void dump(Object obj, boolean deep) {
        System.out.println(DebugUtils.dumpAsString(obj, deep));
    }

    public static String dumpAsString(Object obj) {
        return DebugUtils.dumpAsString(obj, true, 0);
    }

    public static String dumpAsString(Object obj, boolean deep) {
        return DebugUtils.dumpAsString(obj, deep, 0);
    }

    public static String dumpAsString(Object obj, boolean deep, int level) {
        StringBuffer out;
        block52: {
            if (obj == null) {
                return "";
            }
            if (!deep && level > 1) {
                return "";
            }
            out = new StringBuffer();
            if (obj instanceof Object[]) {
                if (level == 0) {
                    out.append("[Array:");
                    out.append(((Object[])obj).length);
                    out.append("]\n");
                }
                for (Object o : (Object[])obj) {
                    out.append(DebugUtils.dumpAsString(o, deep, level + 1));
                }
            } else if (obj instanceof Collection) {
                if (level == 0) {
                    out.append("[Collection:");
                    out.append(((Collection)obj).size());
                    out.append("]\n");
                }
                for (Object o : (Collection)obj) {
                    out.append(DebugUtils.dumpAsString(o, deep, level + 1));
                    out.append(DebugUtils.dumpAsString("-----------------------", deep, level + 1));
                }
            } else if (obj instanceof Map || obj instanceof JSONObject) {
                if (level == 0) {
                    out.append("[Map:");
                    out.append(((Map)obj).size());
                    out.append("]\n");
                }
                for (Map.Entry o : ((Map)obj).entrySet()) {
                    String tmp = CastUtils.toString(o.getKey()) + " = ";
                    if (o.getValue() instanceof Object[]) {
                        for (Object o2 : (Object[])o.getValue()) {
                            tmp = tmp + CastUtils.toString(o2) + ",";
                        }
                        tmp = StringUtils.chop((String)tmp);
                    } else {
                        tmp = tmp + CastUtils.toString(o.getValue()) + ",";
                    }
                    out.append(DebugUtils.dumpAsString(tmp, deep, level + 1));
                }
            } else if (obj instanceof Map.Entry) {
                out.append(DebugUtils.dumpAsString(CastUtils.toString(((Map.Entry)obj).getKey()) + " = " + CastUtils.toString(((Map.Entry)obj).getValue()), deep, level + 1));
            } else if (obj instanceof Enumeration) {
                if (level == 0) {
                    out.append("[Enumeration:");
                    out.append("]\n");
                }
                Enumeration e = (Enumeration)obj;
                while (e.hasMoreElements()) {
                    out.append(DebugUtils.dumpAsString(e.nextElement(), deep, level));
                }
            } else if (obj instanceof ResultSet) {
                try {
                    int c;
                    ResultSet r = (ResultSet)obj;
                    out.append("[ResultSet " + r.toString() + ":");
                    out.append("]\n");
                    ResultSetMetaData m = r.getMetaData();
                    for (c = 1; c <= m.getColumnCount(); ++c) {
                        out.append(FormatUtils.fill(m.getColumnName(c), MathUtils.inRange(m.getColumnDisplaySize(c), 6, 30)));
                        out.append("|");
                    }
                    out.append("\n");
                    if (r.getRow() == 0) {
                        while (r.next()) {
                            for (c = 1; c <= m.getColumnCount(); ++c) {
                                out.append(FormatUtils.fill(r.getString(c), MathUtils.inRange(m.getColumnDisplaySize(c), 6, 30)));
                                out.append("|");
                            }
                            out.append("\n");
                        }
                        r.beforeFirst();
                        break block52;
                    }
                    for (c = 1; c <= m.getColumnCount(); ++c) {
                        out.append(FormatUtils.fill(r.getString(c), MathUtils.inRange(m.getColumnDisplaySize(c), 6, 30)));
                        out.append("|");
                    }
                    out.append("\n");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (obj instanceof String) {
                for (int i = 0; i < level; ++i) {
                    out.append("\t");
                }
                out.append((String)obj);
                out.append("\n");
            } else if (obj instanceof Date) {
                for (int i = 0; i < level; ++i) {
                    out.append("\t");
                }
                out.append(DateUtils.formatDate((Date)obj));
                out.append("\n");
            } else {
                Method[] methods;
                for (int i = 0; i < level; ++i) {
                    out.append("\t");
                }
                out.append(obj);
                out.append("\n");
                for (Method m : methods = obj.getClass().getMethods()) {
                    if (!m.getName().startsWith("get") && !m.getName().startsWith("is") || m.getParameterTypes().length != 0) continue;
                    try {
                        Object ret = m.invoke(obj, new Object[0]);
                        if (ret instanceof Object[]) {
                            for (int i = 0; i < level; ++i) {
                                out.append("\t");
                            }
                            out.append("\t");
                            out.append(m.getName());
                            out.append(" [Array:");
                            out.append(((Object[])ret).length);
                            out.append("]\n");
                            for (Object o : (Object[])ret) {
                                out.append(DebugUtils.dumpAsString(o, deep, level + 1));
                            }
                            continue;
                        }
                        if (ret instanceof Collection) {
                            for (int i = 0; i < level; ++i) {
                                out.append("\t");
                            }
                            out.append("\t");
                            out.append(m.getName());
                            out.append(" [Collection:");
                            out.append(((Collection)ret).size());
                            out.append("]\n");
                            for (Object o : (Collection)ret) {
                                out.append(DebugUtils.dumpAsString(o, deep, level + 1));
                            }
                            continue;
                        }
                        for (int i = 0; i < level; ++i) {
                            out.append("\t");
                        }
                        out.append("\t");
                        out.append(m.getName());
                        out.append(":\t");
                        out.append(String.valueOf(ret));
                        out.append("\n");
                    }
                    catch (IllegalAccessException ex) {
                    }
                    catch (IllegalArgumentException ex) {
                    }
                    catch (InvocationTargetException ex) {
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
        return out.toString();
    }

    public static void dumpJTable(JTable table, Integer row) {
        System.out.println(DebugUtils.dumpJTableAsString(table, row));
    }

    public static String dumpJTableAsString(JTable table, Integer row) {
        StringBuffer out = new StringBuffer();
        int col = 0;
        for (col = 0; col < table.getColumnCount(); ++col) {
            out.append(FormatUtils.fill(table.getColumnName(col), 20));
            out.append("|");
        }
        out.append("\n");
        for (col = 0; col < table.getColumnCount(); ++col) {
            out.append(FormatUtils.fill(CastUtils.toString(table.getValueAt(row, col)), 20));
            out.append("|");
        }
        out.append("\n");
        return out.toString();
    }

    public static void trace(String startsWith, String message) {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        System.out.println("TRACE: " + message);
        for (StackTraceElement e : stacks) {
            if (!e.getClassName().startsWith(startsWith)) continue;
            System.out.println("TRACE: \t\t" + e.toString());
        }
    }

    public static void dumpMem() {
        System.out.println(DebugUtils.getMem());
    }

    public static String getMem() {
        double f = (double)Runtime.getRuntime().freeMemory() / 1024.0 / 1024.0;
        double t = (double)Runtime.getRuntime().totalMemory() / 1024.0 / 1024.0;
        double m = (double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0;
        double u = t - f;
        String out = "dumpMem: max: " + FormatUtils.formatPerc(m) + " tot:" + FormatUtils.formatPerc(t) + " free:" + FormatUtils.formatPerc(f) + " in use:" + FormatUtils.formatPerc(u);
        return out;
    }

    public static long getSize(Object obj) {
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        Object xenc = null;
        try {
            File f = File.createTempFile("java_debug_utils_", ".ser");
            System.err.println("getSize f = " + f);
            fos = new FileOutputStream(f);
            out = new ObjectOutputStream(fos);
            out.writeObject(obj);
            out.close();
            return f.length();
        }
        catch (Exception ex) {
            System.err.println("ex = " + ex);
            return 0L;
        }
    }

    public static void hexDump(String todump) {
        System.out.println("todump:" + todump + " stringToHex:" + DebugUtils.stringToHex(todump));
    }

    public static String stringToHex(String todump) {
        int BYTES_PER_LINE = 16;
        String out = "";
        for (int i = 0; i < todump.length(); ++i) {
            if (BYTES_PER_LINE == 0) continue;
            if (i == 0) {
                out = out + "";
            }
            out = i % BYTES_PER_LINE == 0 ? out + "\n" + StringUtils.replace((String)todump.substring(i, todump.length() < i + BYTES_PER_LINE ? todump.length() : i + BYTES_PER_LINE), (String)"\n", (String)"*") + " > " : out + " ";
            char c = todump.charAt(i);
            out = out + String.format("%02x", c & 0xFF).toUpperCase();
        }
        return out;
    }

    public static Map mapDiff(Map m1, Map m2) {
        TreeMap<String, String> mdiff = new TreeMap<String, String>();
        int conta = 1;
        Iterator iter1 = new TreeSet(m1.keySet()).iterator();
        while (iter1.hasNext()) {
            try {
                Object k1 = iter1.next();
                if (!m2.containsKey(k1)) {
                    mdiff.put(FormatUtils.zeroFill(conta, 3) + " - in m2 non c'\u00e8", k1.toString() + ":" + m1.get(k1));
                    ++conta;
                    continue;
                }
                if (JUtil.equalsToString(m1.get(k1), m2.get(k1))) continue;
                mdiff.put(FormatUtils.zeroFill(conta, 3) + " - in m2 diverso", k1.toString() + ":" + m1.get(k1) + " -> " + m2.get(k1));
                ++conta;
            }
            catch (Exception e) {}
        }
        for (Object k2 : m2.keySet()) {
            if (m1.containsKey(k2)) continue;
            mdiff.put(FormatUtils.zeroFill(conta, 3) + " - in m1 non c'\u00e8", k2.toString() + ":" + m2.get(k2));
            ++conta;
        }
        return mdiff;
    }

    public static void main(String[] args) {
        HashMap<String, Object> test = new HashMap<String, Object>();
        test.put("voce1", "asasasa");
        test.put("voce2", 323232);
        test.put("voce3", 32332);
        HashMap<String, Object> test2 = new HashMap<String, Object>();
        test2.put("voce2", 323232);
        test2.put("voce3", 323333333);
        test2.put("voce4", "aaa");
        DebugUtils.dump(test);
        System.out.println(DebugUtils.mapDiff(test, test2));
    }

    public static void dumpaclip(Object var) {
        System.out.println("*** inizio dumpaclip ***");
        DebugUtils.dump(var);
        StringSelection stringSelection = new StringSelection(String.valueOf(var));
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
        System.out.println("*** fine dumpaclip ***");
    }

    public static String stackTraceToStringFull(Throwable t) {
        return DebugUtils.stackTraceToStringFull(t, 0);
    }

    public static String stackTraceToStringFull(Throwable t, Integer livello) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] traces = t.getStackTrace();
        sb.append(StringUtils.repeat((String)"\t", (int)livello));
        sb.append(t.toString());
        sb.append("\n\n");
        for (StackTraceElement trace : traces) {
            sb.append(StringUtils.repeat((String)"\t", (int)livello));
            sb.append(trace);
            sb.append("\n");
        }
        if (t.getCause() != null) {
            sb.append(StringUtils.repeat((String)"\t", (int)livello));
            sb.append(" *** causato da " + t.getCause() + " ***");
            sb.append(DebugUtils.stackTraceToStringFull(t.getCause(), livello + 1));
        }
        return sb.toString();
    }
}

