/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class FileUtils {
    public static String normalizeFileName(String fileName) {
        String file = StringUtils.substringBeforeLast((String)fileName, (String)".");
        String ext = StringUtils.substringAfterLast((String)fileName, (String)".");
        file = file.replaceAll("[^a-zA-Z0-9-]", "_");
        if (ext.length() == 3) {
            return file + "." + ext;
        }
        return fileName.replaceAll("[^a-zA-Z0-9-]", "_");
    }

    public static String normalizeFileNameDir(String fileName) {
        String file = StringUtils.substringBeforeLast((String)fileName, (String)".");
        String ext = StringUtils.substringAfterLast((String)fileName, (String)".");
        file = file.replaceAll("[^a-zA-Z0-9-\\\\/]", "_");
        if (ext.length() == 3) {
            return file + "." + ext;
        }
        return fileName.replaceAll("[^a-zA-Z0-9-\\\\/]", "_");
    }

    public static void copyFile(File source, File dest) throws FileNotFoundException, IOException {
        FileInputStream fin = new FileInputStream(source);
        FileOutputStream fout = new FileOutputStream(dest);
        byte[] buff = new byte[1024];
        int read = 0;
        while ((read = fin.read(buff)) > 0) {
            fout.write(buff, 0, read);
        }
        fin.close();
        fout.flush();
        fout.close();
    }

    public static String readContent(InputStream source) throws FileNotFoundException, IOException {
        byte[] buff = new byte[1024];
        int read = 0;
        String out = "";
        while ((read = source.read(buff)) > 0) {
            out = out + new String(buff, 0, read);
        }
        source.close();
        return out;
    }

    public static String readContent(File source) throws FileNotFoundException, IOException {
        return FileUtils.readContent(new FileInputStream(source));
    }

    public static String readContentCp1252(File source) throws FileNotFoundException, IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), "Cp1252"));
        String str = "";
        String line = "";
        while ((line = in.readLine()) != null) {
            str = str + line + "\n";
        }
        return str;
    }

    public static String readContentUtf8(File source) throws FileNotFoundException, IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), "UTF8"));
        String str = "";
        String line = "";
        while ((line = in.readLine()) != null) {
            str = str + line + "\n";
        }
        return str;
    }

    public static String getExt(File file) {
        if (file == null) {
            return "";
        }
        return file.getName().substring(file.getName().lastIndexOf(".") + 1);
    }

    public static String getExt(String filename) {
        if (filename == null) {
            return "";
        }
        File file = new File(filename);
        return FileUtils.getExt(file);
    }

    public static String getName(File file) {
        if (file == null) {
            return "";
        }
        return file.getName().substring(0, file.getName().length() - FileUtils.getExt(file).length() - 1);
    }

    public static String getName(String filename) {
        if (filename == null) {
            return "";
        }
        File file = new File(filename);
        return FileUtils.getName(file);
    }

    public static String addSuffix(File file, String suffix) {
        if (file == null) {
            return "";
        }
        String pre = "";
        if (file.getParent() != null) {
            pre = file.getParent() + File.separator;
        }
        return pre + FileUtils.getName(file) + suffix + "." + FileUtils.getExt(file);
    }

    public static String addSuffix(String filename, String suffix) {
        if (filename == null) {
            return "";
        }
        File file = new File(filename);
        return FileUtils.addSuffix(file, suffix);
    }

    public static void main(String[] args) {
        String file = "aAbc\\d123%$..\u00c2\u00a3&/()ds*.%dsds.pdf";
        System.out.println(file);
        System.out.println(FileUtils.normalizeFileName(file));
        System.out.println(FileUtils.normalizeFileNameDir(file));
        String test = null;
        try {
            test = FileUtils.readContentUtf8(new File("c:\\test2"));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.err.println("test: " + test);
        File f = new File("c:\\windows\\system.ini");
        System.out.println(f);
        System.out.println("name:" + FileUtils.getName(f));
        System.out.println("ext: " + FileUtils.getExt(f));
        System.out.println("suffix:" + FileUtils.addSuffix(f, "_suffisso"));
        f = new File("build.xml");
        System.out.println(f);
        System.out.println("name:" + FileUtils.getName(f));
        System.out.println("ext: " + FileUtils.getExt(f));
        System.out.println("suffix:" + FileUtils.addSuffix(f, "_suffisso"));
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            FileUtils.deleteDirContent(path);
        }
        return path.delete();
    }

    public static boolean deleteDirContent(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileUtils.deleteDirContent(files[i]);
                    continue;
                }
                files[i].delete();
            }
            return true;
        }
        return false;
    }
}

