/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import com.sun.image.codec.jpeg.JPEGCodec;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ImgUtils {
    static int conta_getImage = 0;

    public static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        Graphics2D g2 = null;
        if (img.getWidth() > targetWidth && img.getHeight() > targetHeight) {
            int h;
            int w;
            if (higherQuality) {
                w = img.getWidth();
                h = img.getHeight();
            } else {
                w = targetWidth;
                h = targetHeight;
            }
            do {
                if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                    w = targetWidth;
                }
                if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                    h = targetHeight;
                }
                BufferedImage tmp = new BufferedImage(w, h, type);
                g2 = tmp.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
                g2.drawImage(ret, 0, 0, w, h, null);
                ret = tmp;
            } while (w != targetWidth || h != targetHeight);
        } else {
            int w = targetWidth;
            int h = targetHeight;
            BufferedImage tmp = new BufferedImage(w, h, type);
            g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            ret = tmp;
        }
        return ret;
    }

    public static BufferedImage applyFrame1(BufferedImage i, Color sfondo) {
        int w = i.getWidth();
        int h = i.getHeight();
        BufferedImage out = new BufferedImage(w, h, 2);
        BufferedImage outj = new BufferedImage(w, h, 1);
        Graphics2D g2 = out.createGraphics();
        Graphics2D g2j = outj.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(sfondo);
        g2.setStroke(new BasicStroke(9.0f));
        g2.drawRect(4, 4, w - 9, h - 9);
        g2.setStroke(new BasicStroke(3.0f));
        g2.setColor(new Color(100, 100, 100, 70));
        g2.draw(new RoundRectangle2D.Float(6.0f, 6.0f, w - 12, h - 12, 8.0f, 8.0f));
        g2.setColor(new Color(100, 100, 100, 50));
        g2.draw(new RoundRectangle2D.Float(5.0f, 5.0f, w - 10, h - 10, 8.0f, 8.0f));
        g2.setColor(new Color(100, 100, 100, 35));
        g2.draw(new RoundRectangle2D.Float(4.0f, 4.0f, w - 8, h - 8, 8.0f, 8.0f));
        g2.setColor(new Color(100, 100, 100, 25));
        g2.draw(new RoundRectangle2D.Float(3.0f, 3.0f, w - 6, h - 6, 8.0f, 8.0f));
        g2.setColor(new Color(100, 100, 100, 10));
        g2.draw(new RoundRectangle2D.Float(2.0f, 2.0f, w - 3, h - 3, 8.0f, 8.0f));
        g2.setColor(new Color(100, 100, 100, 10));
        g2.draw(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, 8.0f, 8.0f));
        g2.setClip(new Rectangle(8, 8, w - 16, h - 16));
        g2.drawImage((Image)i, 0, 0, null);
        g2.setClip(null);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(new Color(100, 100, 100));
        g2.draw(new Rectangle(10, 10, w - 20, h - 20));
        g2.setStroke(new BasicStroke(4.0f));
        g2.setColor(new Color(250, 250, 250));
        g2.draw(new Rectangle(8, 8, w - 16, h - 16));
        if (w > 160) {
            String copy = "\u00a9 " + Calendar.getInstance().get(1) + " - VillaTuscanyItaly.com";
            g2.setColor(new Color(0, 0, 0, 100));
            g2.setFont(new Font("Trebuchet MS", 1, 9));
            g2.drawString(copy, w - 157, h - 15);
            g2.setColor(new Color(250, 250, 250, 100));
            g2.setFont(new Font("Trebuchet MS", 1, 9));
            g2.drawString(copy, w - 158, h - 16);
        }
        g2j.drawImage((Image)out, 0, 0, null);
        return outj;
    }

    public static BufferedImage applyFrame2(BufferedImage i, Color sfondo) {
        int w = i.getWidth();
        int h = i.getHeight();
        BufferedImage out = new BufferedImage(w, h, 2);
        BufferedImage outj = new BufferedImage(w, h, 1);
        Graphics2D g2 = out.createGraphics();
        Graphics2D g2j = outj.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(sfondo);
        g2.setStroke(new BasicStroke(6.0f));
        g2.drawRect(0, 0, w - 1, h - 1);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(new Color(100, 100, 100, 70));
        g2.draw(new RoundRectangle2D.Float(2.0f, 2.0f, w - 5, h - 5, 8.0f, 8.0f));
        g2.setColor(new Color(100, 100, 100, 35));
        g2.draw(new RoundRectangle2D.Float(1.0f, 1.0f, w - 3, h - 3, 8.0f, 8.0f));
        g2.setColor(new Color(100, 100, 100, 10));
        g2.draw(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, 8.0f, 8.0f));
        g2.setColor(new Color(100, 100, 100, 10));
        g2.draw(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, 8.0f, 8.0f));
        g2.setClip(new Rectangle(3, 3, w - 7, h - 7));
        g2.drawImage((Image)i, 0, 0, null);
        g2.setClip(null);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(new Color(100, 100, 100));
        g2.draw(new Rectangle(4, 4, w - 9, h - 9));
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(new Color(250, 250, 250));
        g2.draw(new Rectangle(3, 3, w - 7, h - 7));
        g2j.drawImage((Image)out, 0, 0, null);
        return outj;
    }

    public static BufferedImage applyFrame3(BufferedImage i, Color sfondo) {
        int w = i.getWidth();
        int h = i.getHeight();
        BufferedImage out = new BufferedImage(w, h, 2);
        BufferedImage outj = new BufferedImage(w, h, 2);
        Graphics2D g2 = out.createGraphics();
        Graphics2D g2j = outj.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(new Color(100, 100, 100, 70));
        g2.draw(new RoundRectangle2D.Float(3.0f, 3.0f, w - 6, h - 6, 5.0f, 5.0f));
        g2.setColor(new Color(100, 100, 100, 35));
        g2.draw(new RoundRectangle2D.Float(2.0f, 2.0f, w - 4, h - 4, 10.0f, 10.0f));
        g2.setColor(new Color(100, 100, 100, 10));
        g2.draw(new RoundRectangle2D.Float(1.0f, 1.0f, w - 2, h - 2, 15.0f, 15.0f));
        g2.setColor(new Color(100, 100, 100, 10));
        g2.draw(new RoundRectangle2D.Float(0.0f, 0.0f, w - 1, h - 1, 20.0f, 20.0f));
        g2.setClip(new Rectangle(4, 4, w - 7, h - 7));
        g2.drawImage((Image)i, 0, 0, null);
        g2.setClip(null);
        g2j.drawImage((Image)out, 0, 0, null);
        return outj;
    }

    public static Color getMixedColor(Color c1, float pct1, Color c2, float pct2) {
        float[] clr1 = c1.getComponents(null);
        float[] clr2 = c2.getComponents(null);
        for (int i = 0; i < clr1.length; ++i) {
            clr1[i] = clr1[i] * pct1 + clr2[i] * pct2;
        }
        return new Color(clr1[0], clr1[1], clr1[2], clr1[3]);
    }

    public static BufferedImage resizeSpeed(BufferedImage img, Dimension dim) {
        return ImgUtils.resizeSpeed(img, dim.width, dim.height);
    }

    public static BufferedImage resizeSpeed(BufferedImage img, int w, int h) {
        return ImgUtils.getScaledInstance(img, w, h, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, false);
    }

    public static BufferedImage resizeMedium(BufferedImage img, Dimension dim) {
        return ImgUtils.resizeMedium(img, dim.width, dim.height);
    }

    public static BufferedImage resizeMedium(BufferedImage img, int w, int h) {
        return ImgUtils.getScaledInstance(img, w, h, RenderingHints.VALUE_INTERPOLATION_BILINEAR, false);
    }

    public static BufferedImage resizeQuality(BufferedImage img, Dimension dim) {
        return ImgUtils.resizeQuality(img, dim.width, dim.height);
    }

    public static BufferedImage resizeQuality(BufferedImage img, int w, int h) {
        return ImgUtils.getScaledInstance(img, w, h, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
    }

    public static Dimension getDimension(int xorig, int yorig, int xdest, int ydest) {
        float cx = (float)xdest / (float)xorig;
        float cy = (float)ydest / (float)yorig;
        Dimension dret = new Dimension();
        if (cx > cy) {
            float crx = (float)yorig / (float)ydest;
            int w = (int)((float)xorig / crx);
            dret.setSize(w, ydest);
        } else {
            float cry = (float)xorig / (float)xdest;
            int h = (int)((float)yorig / cry);
            dret.setSize(xdest, h);
        }
        if (dret.getHeight() < 1.0) {
            dret.setSize(dret.getWidth(), 1.0);
        }
        if (dret.getWidth() < 1.0) {
            dret.setSize(1.0, dret.getHeight());
        }
        return dret;
    }

    public static void writeJpeg(BufferedImage bufi, String file, float quality) throws IOException {
        JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault());
        iwparam.setCompressionMode(2);
        iwparam.setCompressionQuality(quality);
        ImageWriter iw = ImageIO.getImageWritersByFormatName("jpg").next();
        File filef = new File(file);
        filef.getParentFile().mkdirs();
        ImageOutputStream ios = ImageIO.createImageOutputStream(new FileOutputStream(filef));
        iw.setOutput(ios);
        iw.write(null, new IIOImage(bufi, null, null), iwparam);
        ios.close();
    }

    public static byte[] writeJpegByteArray(BufferedImage bufi, float quality) throws IOException {
        JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault());
        iwparam.setCompressionMode(2);
        iwparam.setCompressionQuality(quality);
        ImageWriter iw = ImageIO.getImageWritersByFormatName("jpg").next();
        ByteArrayOutputStream bytea = new ByteArrayOutputStream();
        ImageOutputStream ios = ImageIO.createImageOutputStream(bytea);
        iw.setOutput(ios);
        iw.write(null, new IIOImage(bufi, null, null), iwparam);
        ios.close();
        return bytea.toByteArray();
    }

    public static synchronized BufferedImage getImage(String path, int w, int h, String tipo_resize, boolean crop, double z, String path_cache) throws Throwable {
        System.out.println("ImgUtils.getImage start " + ++conta_getImage);
        Logger log = Logger.getLogger(ImgUtils.class);
        long t1 = System.currentTimeMillis();
        try {
            double cr;
            File fileSorgente;
            if (tipo_resize == null || tipo_resize.trim().length() == 0) {
                tipo_resize = "Q";
            }
            if (z == 0.0) {
                z = 0.8;
            }
            if (!(fileSorgente = new File(path)).exists()) {
                log.info((Object)("il file " + fileSorgente + " non esiste"));
                BufferedImage bufferedImage = null;
                return bufferedImage;
            }
            String nomeFileNormalizzato = StringUtils.replace((String)fileSorgente.getParentFile().getAbsolutePath(), (String)":", (String)"") + "/" + fileSorgente.getName();
            String sfileCache = path_cache + "/" + nomeFileNormalizzato;
            File fileCache = new File(sfileCache);
            String fparams = "_w" + w + "_h" + h + "_tr" + tipo_resize + "_c" + crop + "_z" + StringUtils.replace((String)String.valueOf(z), (String)".", (String)"_");
            String snewFileCache = fileCache.getParent() + "/" + FilenameUtils.getBaseName((String)fileCache.getPath()) + fparams + "." + FilenameUtils.getExtension((String)fileCache.getName());
            fileCache = new File(snewFileCache);
            log.debug((Object)("fileCache:" + fileCache));
            BufferedImage bufi = null;
            if (fileCache.exists() && fileCache.lastModified() >= fileSorgente.lastModified()) {
                log.debug((Object)"USATA CACHE");
                bufi = ImageIO.read(fileCache);
                if (bufi != null) {
                    BufferedImage bufferedImage = bufi;
                    return bufferedImage;
                }
            }
            if (fileSorgente.getName().toLowerCase().endsWith(".jpg") || fileSorgente.getName().toLowerCase().endsWith(".jpeg")) {
                try {
                    bufi = JPEGCodec.createJPEGDecoder((InputStream)new FileInputStream(fileSorgente)).decodeAsBufferedImage();
                }
                catch (Throwable t) {
                    bufi = ImageIO.read(fileSorgente);
                }
            } else {
                bufi = ImageIO.read(fileSorgente);
            }
            if (bufi == null) {
                BufferedImage t = null;
                return t;
            }
            int offx = 0;
            int offy = 0;
            int neww = 0;
            int newh = 0;
            int origw = bufi.getWidth();
            int origh = bufi.getHeight();
            if (w == 0 && h == 0) {
                w = bufi.getWidth();
                h = bufi.getHeight();
                neww = w;
                newh = h;
            } else if (w > 0 && h == 0) {
                cr = (double)bufi.getWidth() / (double)w;
                h = (int)((double)bufi.getHeight() / cr);
                neww = w;
                newh = h;
            } else if (h > 0 && w == 0) {
                cr = (double)bufi.getHeight() / (double)h;
                neww = w = (int)((double)bufi.getWidth() / cr);
                newh = h;
            } else if (crop) {
                cr = (double)bufi.getWidth() / (double)bufi.getHeight();
                double cd = (double)w / (double)h;
                if ((double)bufi.getWidth() / (double)w < (double)bufi.getHeight() / (double)h) {
                    log.debug((Object)"crop verticale");
                    neww = w;
                    newh = (int)((double)w / cr);
                    offy = (newh - h) / 2;
                } else {
                    log.debug((Object)"crop oriz");
                    neww = (int)((double)h * cr);
                    newh = h;
                    offx = (neww - w) / 2;
                }
            } else {
                neww = w;
                newh = h;
            }
            log.debug((Object)("resize dim. orig.:" + origw + "x" + origh + " nuova:" + neww + "x" + newh));
            if (tipo_resize.equalsIgnoreCase("S")) {
                bufi = ImgUtils.resizeSpeed(bufi, neww, newh);
            } else if (tipo_resize.equalsIgnoreCase("M")) {
                bufi = ImgUtils.resizeMedium(bufi, neww, newh);
            } else if (tipo_resize.equalsIgnoreCase("Q")) {
                bufi = ImgUtils.resizeQuality(bufi, neww, newh);
            }
            if (crop) {
                BufferedImage bufic;
                log.debug((Object)("crop dim. orig.:" + origw + "x" + origh + " nuova:" + neww + "x" + newh + " crop: offx=" + offx + " offy=" + offy + " w=" + w + " h=" + h));
                bufi = bufic = bufi.getSubimage(offx, offy, w, h);
            }
            fileCache.getParentFile().mkdirs();
            if (fileSorgente.getName().toLowerCase().endsWith(".png")) {
                ImageIO.write((RenderedImage)bufi, "png", fileCache);
            } else {
                JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault());
                iwparam.setCompressionMode(2);
                iwparam.setCompressionQuality((float)z);
                ImageWriter iw = ImageIO.getImageWritersByFormatName("jpg").next();
                ImageOutputStream ios = ImageIO.createImageOutputStream(new FileOutputStream(fileCache));
                iw.setOutput(ios);
                iw.write(null, new IIOImage(bufi, null, null), iwparam);
                ios.close();
            }
            log.debug((Object)"NON USATA CACHE");
            BufferedImage bufferedImage = ImageIO.read(fileCache);
            return bufferedImage;
        }
        catch (Exception err) {
            err.printStackTrace();
            log.error((Object)("Errore su miniatura per " + path + " / err:" + err), (Throwable)err);
            throw err;
        }
        catch (Throwable tr) {
            tr.printStackTrace();
            throw tr;
        }
        finally {
            long t2 = System.currentTimeMillis();
            System.out.println("ImgUtils.getImage stop " + conta_getImage);
            log.info((Object)("tempo millis:" + (t2 - t1)));
        }
    }

    public static BufferedImage colorize(BufferedImage image, Color color) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage dyed = new BufferedImage(w, h, 2);
        Graphics2D g = dyed.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.setComposite(AlphaComposite.SrcAtop);
        g.setColor(color);
        g.fillRect(0, 0, w, h);
        g.dispose();
        return dyed;
    }
}

