/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import it.tnx.commons.cu;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventListener;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class JUtil {
    public static boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean equalsToString(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            o1 = o2 instanceof Number ? "0" : "";
        }
        if (o2 == null) {
            o2 = o1 instanceof Number ? "0" : "";
        }
        return o1.toString().equalsIgnoreCase(o2.toString());
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        return o instanceof String ? ((String)o).trim().length() == 0 : String.valueOf(o).length() == 0;
    }

    public static String ControllaCF(String cf) {
        int c;
        int i;
        int[] setdisp = new int[]{1, 0, 5, 7, 9, 13, 15, 17, 19, 21, 2, 4, 18, 20, 11, 3, 6, 8, 12, 14, 16, 10, 22, 25, 24, 23};
        if (cf.length() == 0) {
            return "";
        }
        if (cf.length() != 16) {
            return "La lunghezza del codice fiscale non e' corretta: il codice fiscale dovrebbe essere lungo 16 caratteri.";
        }
        String cf2 = cf.toUpperCase();
        for (i = 0; i < 16; ++i) {
            c = cf2.charAt(i);
            if (c >= 48 && c <= 57 || c >= 65 && c <= 90) continue;
            return "Il codice fiscale contiene dei caratteri non validi: i soli caratteri validi sono le lettere e le cifre.";
        }
        int s = 0;
        for (i = 1; i <= 13; i += 2) {
            c = cf2.charAt(i);
            s = c >= 48 && c <= 57 ? s + c - 48 : s + c - 65;
        }
        for (i = 0; i <= 14; i += 2) {
            c = cf2.charAt(i);
            if (c >= 48 && c <= 57) {
                c = c - 48 + 65;
            }
            s += setdisp[c - 65];
        }
        if (s % 26 + 65 != cf2.charAt(15)) {
            return "Il codice fiscale non e' corretto: il codice di controllo non corrisponde.";
        }
        return "";
    }

    public static String ControllaPIVA(String pi) {
        int i;
        if (pi.length() == 0) {
            return "";
        }
        if (pi.length() != 11) {
            return "La lunghezza della partita IVA non e' corretta: la partita IVA dovrebbe essere lunga 11 caratteri.";
        }
        for (i = 0; i < 11; ++i) {
            if (pi.charAt(i) >= '0' && pi.charAt(i) <= '9') continue;
            return "La partita IVA contiene dei caratteri non ammessi: la partita IVA dovrebbe contenere solo cifre.";
        }
        int s = 0;
        for (i = 0; i <= 9; i += 2) {
            s += pi.charAt(i) - 48;
        }
        for (i = 1; i <= 9; i += 2) {
            int c = 2 * (pi.charAt(i) - 48);
            if (c > 9) {
                c -= 9;
            }
            s += c;
        }
        if ((10 - s % 10) % 10 != pi.charAt(10) - 48) {
            return "La partita IVA non e' valida: il codice di controllo non corrisponde.";
        }
        return "";
    }

    public static Object ifNull(Object test, Object ifNull) {
        if (test == null) {
            return ifNull;
        }
        return test;
    }

    public static boolean hasListenerClass(EventListener[] listeners, Class _class) {
        for (EventListener l : listeners) {
            if (!l.getClass().equals(_class)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidDateIta(String data) {
        try {
            SimpleDateFormat datef = null;
            if (data.length() == 8 || data.length() == 7) {
                datef = new SimpleDateFormat("dd/MM/yy");
            } else if (data.length() == 10 || data.length() == 9) {
                datef = new SimpleDateFormat("dd/MM/yyyy");
            } else {
                return false;
            }
            Calendar cal = Calendar.getInstance();
            datef.setLenient(false);
            cal.setTime(datef.parse(data));
        }
        catch (Exception err) {
            return false;
        }
        return true;
    }

    public static List<String> getResourceFiles(String path, Object claz) throws IOException {
        String resource;
        ArrayList<String> filenames = new ArrayList<String>();
        InputStream in = JUtil.getResourceAsStream(path, claz);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((resource = br.readLine()) != null) {
            filenames.add(resource);
        }
        return filenames;
    }

    private static InputStream getResourceAsStream(String resource, Object claz) {
        InputStream in = JUtil.getContextClassLoader().getResourceAsStream(resource);
        return in == null ? claz.getClass().getResourceAsStream(resource) : in;
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Integer getJavaMajor() {
        String java = System.getProperty("java.version");
        String[] split = StringUtils.split((String)java, (String)".");
        if (split[0].equals("1")) {
            return cu.i0(split[1]);
        }
        return cu.i0(split[0]);
    }

    public static boolean isJava10OrNewer() {
        return JUtil.getJavaMajor() >= 10;
    }

    public static boolean isJava7OrNewer() {
        return JUtil.getJavaMajor() >= 7;
    }

    public static boolean is4k() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int ws = gd.getDisplayMode().getWidth();
        return ws >= 3500;
    }
}

