/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import it.tnx.commons.DebugUtils;
import java.awt.BorderLayout;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class RuntimeUtils {
    public static int run(String run) throws IOException, InterruptedException {
        return RuntimeUtils.run(run, false);
    }

    public static int run(String run, boolean showOutput) throws IOException, InterruptedException {
        return RuntimeUtils.run(run, showOutput, true);
    }

    public static int run(final String run, boolean showOutput, boolean waitfor) throws IOException, InterruptedException {
        System.out.println("RuntimeUtils run:" + run);
        Runtime rt = Runtime.getRuntime();
        final Process proc = rt.exec(run);
        JFrame frame = null;
        JScrollPane scroll = null;
        JTextArea text = null;
        if (showOutput) {
            frame = new JFrame("RuntimeUtils Output");
            text = new JTextArea();
            scroll = new JScrollPane(text);
            text.setFont(new Font("Courier New", 0, 11));
            text.setEditable(false);
            frame.setLayout(new BorderLayout(10, 10));
            frame.add(scroll);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gs = ge.getScreenDevices();
            DisplayMode dm = gs[0].getDisplayMode();
            int screenWidth = dm.getWidth();
            int screenHeight = dm.getHeight();
            frame.setSize(screenWidth, screenHeight / 6);
            frame.setLocation(0, screenHeight - screenHeight / 5);
            frame.setDefaultCloseOperation(2);
            frame.setVisible(true);
        }
        final JFrame framef = frame;
        StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR", text){

            @Override
            public void output(final String line) {
                if (this.text != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            text.append(type + " > " + line + "\n");
                        }
                    });
                } else {
                    System.out.println(this.type + " > " + line);
                }
            }
        };
        StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT", text){

            @Override
            public void output(final String line) {
                if (this.text != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            text.append(type + " > " + line + "\n");
                        }
                    });
                } else {
                    System.out.println(this.type + " > " + line);
                }
            }
        };
        errorGobbler.start();
        outputGobbler.start();
        if (!showOutput) {
            if (waitfor) {
                int exitVal = proc.waitFor();
                System.out.println("RuntimeUtils run:" + run + " -> ExitValue: " + exitVal);
                return exitVal;
            }
            return 0;
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                int exitVal = -1;
                try {
                    exitVal = proc.waitFor();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                System.out.println("RuntimeUtils run:" + run + " -> ExitValue: " + exitVal);
                framef.dispose();
            }
        };
        t.start();
        return 0;
    }

    public static String runWait(String run) throws IOException, InterruptedException {
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(run);
        final StringBuilder sb = new StringBuilder();
        StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR"){

            @Override
            public void output(String line) {
                sb.append(line);
            }
        };
        StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT"){

            @Override
            public void output(String line) {
                sb.append(line);
            }
        };
        errorGobbler.start();
        outputGobbler.start();
        int exitVal = proc.waitFor();
        System.out.println("RuntimeUtils run:" + run + " -> ExitValue: " + exitVal);
        return sb.toString();
    }

    public static String runWait(String[] run) throws IOException, InterruptedException {
        System.out.print("runWait:");
        for (String r : run) {
            System.out.print(" " + r);
        }
        System.out.println("");
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(run);
        final StringBuilder sb = new StringBuilder();
        StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR"){

            @Override
            public void output(String line) {
                sb.append(line + "\n");
            }
        };
        StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT"){

            @Override
            public void output(String line) {
                sb.append(line + "\n");
            }
        };
        errorGobbler.start();
        outputGobbler.start();
        int exitVal = proc.waitFor();
        System.out.println("RuntimeUtils run:" + run + " -> ExitValue: " + exitVal);
        return sb.toString();
    }

    public static List<String> getJvmOptions() {
        RuntimeMXBean RuntimemxBean = ManagementFactory.getRuntimeMXBean();
        return RuntimemxBean.getInputArguments();
    }

    public static boolean isInDebug() {
        return RuntimeUtils.getJvmOptions().contains("-Xdebug");
    }

    public static void main(String[] args) {
        List<String> l = RuntimeUtils.getJvmOptions();
        DebugUtils.dump(l);
        System.out.println(RuntimeUtils.isInDebug());
    }

    public static class StreamGobbler
    extends Thread {
        InputStream is;
        String type;
        JTextArea text;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        StreamGobbler(InputStream is, String type, JTextArea text) {
            this.is = is;
            this.type = type;
            this.text = text;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.output(line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        public void output(String line) {
            System.out.println(this.type + ">" + line);
        }
    }
}

