/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class StringUtilsTnx {
    public static boolean isNumber(String text) {
        return StringUtilsTnx.isNumber(text, Locale.ITALIAN);
    }

    public static boolean isNumber(String text, Locale locale) {
        NumberFormat f = DecimalFormat.getInstance(Locale.ITALIAN);
        try {
            f.parse(text);
        }
        catch (ParseException ex) {
            return false;
        }
        return true;
    }

    public static double parseDoubleOrZero(String text) {
        return StringUtilsTnx.parseDoubleOrZero(text, Locale.ITALIAN);
    }

    public static double parseDoubleOrZero(String text, Locale locale) {
        NumberFormat f = DecimalFormat.getInstance(Locale.ITALIAN);
        try {
            return f.parse(text).doubleValue();
        }
        catch (ParseException ex) {
            return 0.0;
        }
    }

    public static String addslashes(String str) {
        return str.replaceAll("\\\\", "\\\\");
    }

    public static final String highlightWord(String string, String word, String startHighlight, String endHighlight) {
        if (string == null || word == null || startHighlight == null || endHighlight == null) {
            return null;
        }
        if (word.length() == 0) {
            return string;
        }
        String word_lc = word.toLowerCase();
        String string_lc = string.toLowerCase();
        StringBuffer sb = new StringBuffer();
        int ind = string_lc.indexOf(word_lc);
        if (ind >= 0) {
            sb.append(string.substring(0, ind));
            sb.append(startHighlight);
            sb.append(string.substring(ind, ind + word.length()));
            sb.append(endHighlight);
            sb.append(string.substring(ind + word.length()));
        }
        return sb.toString();
    }

    public static String abbreviateMiddle(String input, String middle, int length) {
        if (input != null && input.length() > length) {
            int half = (length - middle.length()) / 2;
            Pattern pattern = Pattern.compile("^(.{" + half + ",}?)" + "\\b.*\\b" + "(.{" + half + ",}?)$");
            Matcher matcher = pattern.matcher(input);
            if (matcher.matches()) {
                return matcher.group(1) + middle + matcher.group(2);
            }
        }
        return input;
    }

    public static String html2text(String html) {
        return StringUtilsTnx.html2text(html, true, true, true);
    }

    public static String html2text(String html, boolean br2nl, boolean div2nl, boolean p2nl) {
        if (br2nl) {
            html = StringUtils.replace((String)html, (String)"<br>", (String)"\n");
        }
        if (div2nl) {
            html = StringUtils.replace((String)html, (String)"</div>", (String)"\n");
        }
        if (p2nl) {
            html = StringUtils.replace((String)html, (String)"</p>", (String)"\n");
        }
        html = html.replaceAll("\\<.*?>", "");
        return StringEscapeUtils.unescapeHtml((String)html);
    }
}

