/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons.swing;

import it.tnx.commons.swing.CheckTreeSelectionModel;
import it.tnx.commons.swing.TristateCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class CheckTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private CheckTreeSelectionModel selectionModel;
    private TreeCellRenderer delegate;
    private TristateCheckBox checkBox = new TristateCheckBox();

    public CheckTreeCellRenderer(TreeCellRenderer delegate, CheckTreeSelectionModel selectionModel) {
        this.delegate = delegate;
        this.selectionModel = selectionModel;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.checkBox.setOpaque(false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TreePath path;
        Component renderer = this.delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof File) {
            File file = (File)value;
            JLabel lab = (JLabel)renderer;
            if (file.getParent() != null && row > 0) {
                lab.setText(file.getName());
            }
        }
        if ((path = tree.getPathForRow(row)) != null) {
            if (this.selectionModel.isPathSelected(path, true)) {
                this.checkBox.setState(TristateCheckBox.SELECTED);
            } else {
                this.checkBox.setState(this.selectionModel.isPartiallySelected(path) ? null : TristateCheckBox.NOT_SELECTED);
            }
        }
        this.removeAll();
        this.add((Component)this.checkBox, "West");
        this.add(renderer, "Center");
        return this;
    }
}

