/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons.swing;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;

public class FileSystemModel
implements TreeModel {
    private String root;
    private boolean onlyFolders = false;
    private Vector listeners;
    private HashMap cache = new HashMap();
    FileFilter filtro = null;

    public FileSystemModel() {
        this.root = System.getProperty("user.home");
        File tempFile = new File(this.root);
        this.root = tempFile.getParent();
        this.listeners = new Vector();
    }

    public FileSystemModel(String rootFile, File startPath, boolean onlyFolders) {
        this(rootFile, startPath, onlyFolders, null);
    }

    public FileSystemModel(String rootFile, File startPath, boolean onlyFolders, FileFilter filtro) {
        this.root = rootFile != null ? rootFile : null;
        this.onlyFolders = onlyFolders;
        this.filtro = filtro;
        this.listeners = new Vector();
    }

    @Override
    public Object getRoot() {
        if (this.root == null) {
            return "Computer";
        }
        return new File(this.root);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof String) {
            return File.listRoots()[index];
        }
        File directory = (File)parent;
        Object[] directoryMembers = null;
        if (this.cache.containsKey(parent)) {
            directoryMembers = (File[])this.cache.get(parent);
        } else {
            System.out.println("parent1:" + parent);
            directoryMembers = directory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (FileSystemModel.this.filtro != null && !FileSystemModel.this.filtro.accept(pathname)) {
                        return false;
                    }
                    if (FileSystemModel.this.onlyFolders) {
                        return !pathname.isFile();
                    }
                    return true;
                }
            });
            Arrays.sort(directoryMembers);
            this.cache.put(parent, directoryMembers);
        }
        return directoryMembers[index];
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof String) {
            return File.listRoots().length;
        }
        final File fileSystemMember = (File)parent;
        if (fileSystemMember.isDirectory()) {
            Object[] directoryMembers = null;
            if (this.cache.containsKey(parent)) {
                directoryMembers = (File[])this.cache.get(parent);
            } else {
                System.out.println("parent2:" + parent);
                directoryMembers = fileSystemMember.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        if (FileSystemModel.this.filtro != null && !FileSystemModel.this.filtro.accept(pathname)) {
                            return false;
                        }
                        if (FileSystemModel.this.onlyFolders) {
                            File test_locale;
                            if (pathname.isFile()) {
                                return false;
                            }
                            return !fileSystemMember.getAbsolutePath().toUpperCase().startsWith("T") || (test_locale = new File("c" + StringUtils.substring((String)pathname.getAbsolutePath(), (int)1))).exists();
                        }
                        return true;
                    }
                });
                Arrays.sort(directoryMembers);
                this.cache.put(parent, directoryMembers);
            }
            return directoryMembers.length;
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        File directory = (File)parent;
        File directoryMember = (File)child;
        String[] directoryMemberNames = directory.list();
        int result = -1;
        for (int i = 0; i < directoryMemberNames.length; ++i) {
            if (!directoryMember.getName().equals(directoryMemberNames[i])) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof String) {
            return false;
        }
        return ((File)node).isFile();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (l != null && !this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        if (l != null) {
            this.listeners.removeElement(l);
        }
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void fireTreeNodesInserted(TreeModelEvent e) {
        Enumeration listenerCount = this.listeners.elements();
        while (listenerCount.hasMoreElements()) {
            TreeModelListener listener = (TreeModelListener)listenerCount.nextElement();
            listener.treeNodesInserted(e);
        }
    }

    public void fireTreeNodesRemoved(TreeModelEvent e) {
        Enumeration listenerCount = this.listeners.elements();
        while (listenerCount.hasMoreElements()) {
            TreeModelListener listener = (TreeModelListener)listenerCount.nextElement();
            listener.treeNodesRemoved(e);
        }
    }

    public void fireTreeNodesChanged(TreeModelEvent e) {
        Enumeration listenerCount = this.listeners.elements();
        while (listenerCount.hasMoreElements()) {
            TreeModelListener listener = (TreeModelListener)listenerCount.nextElement();
            listener.treeNodesChanged(e);
        }
    }

    public void fireTreeStructureChanged(TreeModelEvent e) {
        Enumeration listenerCount = this.listeners.elements();
        while (listenerCount.hasMoreElements()) {
            TreeModelListener listener = (TreeModelListener)listenerCount.nextElement();
            listener.treeStructureChanged(e);
        }
    }
}

