/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;

public class JPanelFontChooser
extends JPanel {
    Font def = null;
    private JLabel carattere_standard;
    private JLabel esempio;
    public JComboBox font_names;
    public JSpinner font_size;
    private JLabel jLabel2;
    private JLabel jLabel3;

    public JPanelFontChooser() {
        this.initComponents();
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = e.getAllFonts();
        Arrays.sort(fonts, new Comparator<Font>(){

            @Override
            public int compare(Font o1, Font o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        DefaultComboBoxModel fontsm = (DefaultComboBoxModel)this.font_names.getModel();
        for (Font f : fonts) {
            if (fontsm.getIndexOf(f.getFamily()) >= 0) continue;
            fontsm.addElement(f.getFamily());
        }
        this.font_size.setValue(10);
        this.font_size.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JPanelFontChooser.this.aggiornascritta();
            }
        });
        this.setDefFont(UIManager.getDefaults().getFont("Label.font"), true);
    }

    private void aggiornascritta() {
        Font f = new Font((String)this.font_names.getSelectedItem(), 0, (Integer)this.font_size.getValue());
        this.esempio.setFont(f);
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.font_names = new JComboBox();
        this.font_size = new JSpinner();
        this.esempio = new JLabel();
        this.jLabel2 = new JLabel();
        this.carattere_standard = new JLabel();
        this.jLabel3.setText("jLabel3");
        this.font_names.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JPanelFontChooser.this.font_namesItemStateChanged(evt);
            }
        });
        this.esempio.setText("Esempio di scritta del carattere selezionato");
        this.jLabel2.setForeground(new Color(102, 102, 102));
        this.jLabel2.setText("Carattere di sistema:");
        this.carattere_standard.setForeground(new Color(102, 102, 102));
        this.carattere_standard.setText("...");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.esempio, -1, 380, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.carattere_standard)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.font_names, -2, -1, -2).addPreferredGap(0).add((Component)this.font_size, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.esempio, -2, 47, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.font_names, -2, -1, -2).add((Component)this.font_size, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.carattere_standard)).addContainerGap(113, Short.MAX_VALUE)));
    }

    private void font_namesItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.aggiornascritta();
        }
    }

    private Font getDefFont() {
        return this.def;
    }

    public void setDefFont(Font f, boolean select) {
        this.carattere_standard.setText(f.getFamily() + " " + f.getSize());
        this.carattere_standard.setFont(f);
        if (select) {
            this.font_size.setValue(f.getSize());
            this.font_names.setSelectedItem(f.getFamily());
        }
    }

    public static void main(String[] args) {
        JDialog d = new JDialog();
        d.getContentPane().add(new JPanelFontChooser());
        d.pack();
        d.setLocationRelativeTo(null);
        d.setVisible(true);
    }
}

