/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons.table;

import it.tnx.commons.CastUtils;
import it.tnx.commons.cu;
import it.tnx.commons.table.ListMapTableModel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.tree.TreeCellEditor;

public class EditorUtils {

    public static class EliminaEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        int current;
        JButton button;
        JLabel label = new JLabel("");
        JDialog dialog;
        JTable table;
        protected static final String ELIMINA = "elimina";
        ImageIcon icona = new ImageIcon(this.getClass().getResource("/it/tnx/commons/res/Delete Sign-16.png"));

        public EliminaEditor() {
            this.button = new JButton();
            this.button.setText("");
            this.button.setMargin(new Insets(1, 1, 1, 1));
            this.button.setHorizontalAlignment(0);
            this.button.setHorizontalTextPosition(0);
            this.button.setActionCommand(ELIMINA);
            this.button.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ELIMINA.equals(e.getActionCommand())) {
                int row = this.table.getSelectedRow();
                System.out.println("eliminare:" + row);
                if (this.table.getModel() instanceof DefaultTableModel) {
                    DefaultTableModel tableModel = (DefaultTableModel)this.table.getModel();
                    tableModel.removeRow(row);
                } else if (this.table.getModel() instanceof ListMapTableModel) {
                    ListMapTableModel tableModel = (ListMapTableModel)this.table.getModel();
                    tableModel.removeRow(row);
                }
                this.fireEditingStopped();
            } else {
                this.current = 0;
            }
        }

        @Override
        public Object getCellEditorValue() {
            return new Integer(this.current);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.current = 0;
            this.table = table;
            Object val = table.getValueAt(row, 1);
            if (val != null) {
                this.button.setIcon(this.icona);
                return this.button;
            }
            return this.label;
        }
    }

    public static class NumberEditor
    extends DefaultCellEditor {
        JTextField tf = null;
        NumberFormat nf = NumberFormat.getNumberInstance();
        public boolean returnNull = false;

        public NumberEditor() {
            super(new JTextField());
            this.tf = (JTextField)this.editorComponent;
            this.init();
        }

        public NumberEditor(JTextField tf) {
            super(tf);
            this.tf = tf;
            this.init();
        }

        public NumberEditor(JTextField tf, NumberFormat nf) {
            super(tf);
            this.tf = tf;
            this.nf = nf;
            this.init();
        }

        private void init() {
            this.tf.setHorizontalAlignment(4);
            this.tf.setBorder(null);
            this.tf.setDocument(new PlainDocument(){

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    if (str.equals(".")) {
                        str = ",";
                    }
                    super.insertString(offs, str, a);
                }
            });
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object param) {
                    Double _value = null;
                    _value = param instanceof BigDecimal ? Double.valueOf(((BigDecimal)param).doubleValue()) : (param instanceof Integer ? CastUtils.toDouble(param) : (param instanceof Double ? (Double)param : CastUtils.toDouble(param)));
                    if (_value == null) {
                        NumberEditor.this.tf.setText("");
                    } else {
                        NumberEditor.this.tf.setText(NumberEditor.this.nf.format(_value));
                    }
                }

                @Override
                public Object getCellEditorValue() {
                    if (NumberEditor.this.returnNull) {
                        return cu.toDoubleAll(NumberEditor.this.tf.getText());
                    }
                    return cu.toDouble0All(NumberEditor.this.tf.getText());
                }
            };
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return super.getCellEditorValue();
        }
    }

    public static class ComboEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    TreeCellEditor {
        protected JComponent editorComponent;
        JComboBox comboBox = null;
        protected EditorDelegate delegate;
        protected int clickCountToStart = 1;
        int lastkey = 0;

        public ComboEditor(final JComboBox comboBox) {
            this.editorComponent = comboBox;
            this.comboBox = comboBox;
            comboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            comboBox.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    System.out.println(e);
                    ComboEditor.this.lastkey = e.getKeyCode();
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
            this.delegate = new EditorDelegate(){

                @Override
                public void setValue(Object value) {
                    comboBox.setSelectedItem(value);
                }

                @Override
                public Object getCellEditorValue() {
                    return comboBox.getSelectedItem();
                }

                @Override
                public boolean shouldSelectCell(EventObject anEvent) {
                    if (anEvent instanceof MouseEvent) {
                        MouseEvent e = (MouseEvent)anEvent;
                        return e.getID() != 506;
                    }
                    return true;
                }

                @Override
                public boolean stopCellEditing() {
                    System.out.println("stopcellediting");
                    return true;
                }
            };
            comboBox.addActionListener(this.delegate);
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.delegate.setValue(value);
            return this.editorComponent;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, false);
            this.delegate.setValue(stringValue);
            return this.editorComponent;
        }

        protected class EditorDelegate
        implements ActionListener,
        ItemListener,
        Serializable {
            protected Object value;

            protected EditorDelegate() {
            }

            public Object getCellEditorValue() {
                return this.value;
            }

            public void setValue(Object value) {
                this.value = value;
            }

            public boolean isCellEditable(EventObject anEvent) {
                if (anEvent instanceof MouseEvent) {
                    return ((MouseEvent)anEvent).getClickCount() >= ComboEditor.this.clickCountToStart;
                }
                return true;
            }

            public boolean shouldSelectCell(EventObject anEvent) {
                return true;
            }

            public boolean startCellEditing(EventObject anEvent) {
                return true;
            }

            public boolean stopCellEditing() {
                System.out.println("stopcellediting2");
                ComboEditor.this.fireEditingStopped();
                return true;
            }

            public void cancelCellEditing() {
                ComboEditor.this.fireEditingCanceled();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("lastkey:" + ComboEditor.this.lastkey);
                if (ComboEditor.this.lastkey == 10) {
                    ComboEditor.this.stopCellEditing();
                }
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                ComboEditor.this.stopCellEditing();
            }
        }
    }

    public static class CurrencyEditor
    extends DefaultCellEditor {
        JTextField tf = null;
        NumberFormat nf = NumberFormat.getCurrencyInstance();
        public boolean returnNull = false;

        public CurrencyEditor() {
            super(new JTextField());
            this.tf = (JTextField)this.editorComponent;
            this.init();
        }

        public CurrencyEditor(int min, int max) {
            super(new JTextField());
            this.tf = (JTextField)this.editorComponent;
            this.nf.setMinimumFractionDigits(min);
            this.nf.setMaximumFractionDigits(max);
            this.init();
        }

        public CurrencyEditor(JTextField tf) {
            super(tf);
            this.tf = tf;
            this.init();
        }

        public CurrencyEditor(JTextField tf, NumberFormat nf) {
            super(tf);
            this.tf = tf;
            this.nf = nf;
            this.init();
        }

        private void init() {
            this.tf.setHorizontalAlignment(4);
            this.tf.setBorder(null);
            this.tf.setDocument(new PlainDocument(){

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    if (str.equals(".")) {
                        str = ",";
                    }
                    super.insertString(offs, str, a);
                }
            });
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object param) {
                    Double _value = null;
                    _value = param instanceof BigDecimal ? Double.valueOf(((BigDecimal)param).doubleValue()) : (param instanceof Integer ? CastUtils.toDouble(param) : (param instanceof Double ? (Double)param : CastUtils.toDouble(param)));
                    if (_value == null) {
                        CurrencyEditor.this.tf.setText("");
                    } else {
                        CurrencyEditor.this.tf.setText(CurrencyEditor.this.nf.format(_value));
                    }
                }

                @Override
                public Object getCellEditorValue() {
                    try {
                        return CurrencyEditor.this.nf.parse(CurrencyEditor.this.tf.getText()).doubleValue();
                    }
                    catch (ParseException ex) {
                        if (CurrencyEditor.this.returnNull) {
                            return CastUtils.toDouble(CurrencyEditor.this.tf.getText());
                        }
                        return CastUtils.toDouble0(CurrencyEditor.this.tf.getText());
                    }
                }
            };
        }

        public void setBorder(Border border) {
            this.editorComponent.setBorder(border);
        }
    }

    public static class DateCuToDateItaEditor
    extends DefaultCellEditor {
        JTextField tf = null;
        DateFormat df = DateFormat.getDateInstance(3);

        public DateCuToDateItaEditor(JTextField tf) {
            super(tf);
            this.tf = tf;
            this.init();
        }

        private void init() {
            this.tf.setBorder(null);
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object param) {
                    Date _value = (Date)param;
                    if (_value == null) {
                        DateCuToDateItaEditor.this.tf.setText("");
                    } else {
                        DateCuToDateItaEditor.this.tf.setText(DateCuToDateItaEditor.this.df.format(_value));
                    }
                }

                @Override
                public Object getCellEditorValue() {
                    return cu.toDateIta(DateCuToDateItaEditor.this.tf.getText());
                }
            };
        }
    }

    public static class DateEditor
    extends DefaultCellEditor {
        JTextField tf = null;
        DateFormat df = DateFormat.getDateInstance();

        public DateEditor(JTextField tf) {
            super(tf);
            this.tf = tf;
            this.init();
        }

        public DateEditor(JTextField tf, DateFormat df) {
            super(tf);
            this.tf = tf;
            this.df = df;
            this.init();
        }

        private void init() {
            this.tf.setBorder(null);
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object param) {
                    Date _value = (Date)param;
                    if (_value == null) {
                        DateEditor.this.tf.setText("");
                    } else {
                        DateEditor.this.tf.setText(DateEditor.this.df.format(_value));
                    }
                }

                @Override
                public Object getCellEditorValue() {
                    try {
                        return DateEditor.this.df.parse(DateEditor.this.tf.getText());
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                        return null;
                    }
                }
            };
        }
    }
}

