/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons.table;

import it.tnx.commons.SwingUtils;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.FocusManager;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class ExcelAdapter
implements ActionListener {
    private String rowstring;
    private String value;
    private Clipboard system;
    private StringSelection stsel;
    private JTable jTable1;

    public ExcelAdapter(JTable myJTable) {
        this.jTable1 = myJTable;
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
        this.jTable1.registerKeyboardAction(this, "Copy", copy, 0);
        this.jTable1.registerKeyboardAction(this, "Paste", paste, 0);
        this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public JTable getJTable() {
        return this.jTable1;
    }

    public void setJTable(JTable jTable1) {
        this.jTable1 = jTable1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        if (e.getActionCommand().compareTo("Copy") == 0) {
            StringBuffer sbf = new StringBuffer();
            int numcols = this.jTable1.getSelectedColumnCount();
            int numrows = this.jTable1.getSelectedRowCount();
            int[] rowsselected = this.jTable1.getSelectedRows();
            int[] colsselected = this.jTable1.getSelectedColumns();
            if (numrows - 1 != rowsselected[rowsselected.length - 1] - rowsselected[0] || numrows != rowsselected.length || numcols - 1 != colsselected[colsselected.length - 1] - colsselected[0] || numcols != colsselected.length) {
                JOptionPane.showMessageDialog(null, "Invalid Copy Selection", "Invalid Copy Selection", 0);
                return;
            }
            for (i = 0; i < numrows; ++i) {
                for (int j = 0; j < numcols; ++j) {
                    sbf.append(this.jTable1.getValueAt(rowsselected[i], colsselected[j]));
                    if (j >= numcols - 1) continue;
                    sbf.append("\t");
                }
                sbf.append("\n");
            }
            this.stsel = new StringSelection(sbf.toString());
            this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.system.setContents(this.stsel, this.stsel);
        }
        if (e.getActionCommand().compareTo("Paste") == 0) {
            this.startPaste();
            System.out.println("Trying to Paste");
            int startRow = this.jTable1.getSelectedRows()[0];
            int startCol = this.jTable1.getSelectedColumns()[0];
            try {
                String trstring = (String)this.system.getData(DataFlavor.stringFlavor);
                StringTokenizer st1 = new StringTokenizer(trstring, "\n");
                int pasterows = 0;
                i = 0;
                while (st1.hasMoreTokens()) {
                    st1.nextToken();
                    ++pasterows;
                    ++i;
                }
                if (pasterows > this.jTable1.getRowCount()) {
                    this.ensureRows(pasterows);
                }
                st1 = new StringTokenizer(trstring, "\n");
                i = 0;
                while (st1.hasMoreTokens()) {
                    this.rowstring = st1.nextToken();
                    String[] splits = this.rowstring.split("\\t");
                    for (int j = 0; j < splits.length; ++j) {
                        this.value = splits[j];
                        if (startRow + i >= this.jTable1.getRowCount() || startCol + j >= this.jTable1.getColumnCount()) continue;
                        this.jTable1.setValueAt(this.value, startRow + i, startCol + j);
                    }
                    ++i;
                }
                this.endPaste();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                SwingUtils.showErrorMessage(FocusManager.getCurrentManager().getActiveWindow(), ex.toString());
            }
        }
    }

    public void ensureRows(int pasterows) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void endPaste() {
    }

    public void startPaste() {
    }
}

