/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons.table;

import it.tnx.commons.CastUtils;
import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class RendererUtils {

    public static class EliminaRenderer
    extends DefaultTableCellRenderer {
        ImageIcon icona = new ImageIcon(this.getClass().getResource("/it/tnx/commons/res/Delete Sign-16.png"));

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel lab = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            lab.setText("");
            Object val = table.getValueAt(row, 1);
            if (val != null) {
                lab.setHorizontalAlignment(0);
                lab.setHorizontalTextPosition(0);
                lab.setIcon(this.icona);
                lab.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.lightGray));
                return lab;
            }
            lab.setIcon(null);
            lab.setBorder(null);
            return lab;
        }
    }

    public static class NumberRenderer
    extends DefaultTableCellRenderer {
        NumberFormat formatter = NumberFormat.getNumberInstance();

        public NumberRenderer() {
            this.init();
        }

        public NumberRenderer(NumberFormat formatter) {
            this.formatter = formatter;
            this.init();
        }

        public NumberRenderer(int mindec, int maxdec) {
            this.formatter.setMinimumFractionDigits(mindec);
            this.formatter.setMaximumFractionDigits(maxdec);
            this.init();
        }

        @Override
        protected void setValue(Object value) {
            this.setText(value == null ? "" : this.formatter.format(CastUtils.toDouble0All(value)));
        }

        private void init() {
            this.setHorizontalAlignment(4);
            this.setBorder(null);
        }
    }

    public static class CurrencyRenderer
    extends DefaultTableCellRenderer {
        NumberFormat formatter = NumberFormat.getCurrencyInstance();

        public CurrencyRenderer() {
            this.init();
        }

        public CurrencyRenderer(NumberFormat formatter) {
            this.formatter = formatter;
            this.init();
        }

        public CurrencyRenderer(int mindec, int maxdec) {
            this.formatter.setMinimumFractionDigits(mindec);
            this.formatter.setMaximumFractionDigits(maxdec);
            this.init();
        }

        @Override
        protected void setValue(Object value) {
            if (value instanceof String && CastUtils.toString(value).equals("")) {
                this.setText("");
                return;
            }
            this.setText(value == null ? "" : this.formatter.format(CastUtils.toDouble0All(value)));
        }

        private void init() {
            this.setHorizontalAlignment(4);
            this.setBorder(null);
        }
    }

    public static class DateRenderer
    extends DefaultTableCellRenderer {
        DateFormat formatter;

        public DateRenderer() {
            this.formatter = DateFormat.getDateInstance();
        }

        public DateRenderer(DateFormat formatter) {
            this.formatter = formatter;
        }

        @Override
        protected void setValue(Object value) {
            try {
                if (value instanceof Date) {
                    this.setText(value == null ? "" : this.formatter.format(value));
                } else {
                    this.setText(value == null ? "" : String.valueOf(value));
                }
            }
            catch (Exception e) {
                System.out.println(e.toString() + " value:" + value);
                e.printStackTrace();
            }
        }
    }
}

