/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons.table;

import it.tnx.commons.CastUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.commons.table.DbDefaultTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.StringUtils;

public class TableUtils {
    public static Object NUMERO_RIGA = new Object();

    public static void addAutoNewRow(final JTable table) throws Exception {
        if (!(table.getModel() instanceof DefaultTableModel)) {
            throw new Exception("Table model not compatible with addAutoNewRow");
        }
        table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0 && e.getLastRow() == table.getRowCount() - 1 && table.getModel() instanceof DefaultTableModel) {
                    ((DefaultTableModel)table.getModel()).addRow(new Object[table.getColumnCount()]);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadData(Connection conn, String sql, DefaultTableModel model) throws Exception {
        ResultSet r = null;
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            TableUtils.loadData(r, model);
        }
        finally {
            if (r != null) {
                r.getStatement().close();
                r.close();
            }
        }
    }

    public static void loadData(ResultSet r, DefaultTableModel model) throws Exception {
        while (r.next()) {
            model.addRow(DbUtils.getRow(r));
        }
    }

    public static void loadDataDb(ResultSet r, DefaultTableModel model) throws Exception {
        int cols = r.getMetaData().getColumnCount();
        while (r.next()) {
            Object[] row = new Object[cols + 1];
            row[0] = null;
            for (int c = 1; c <= cols; ++c) {
                row[c] = r.getObject(c);
            }
            model.addRow(row);
        }
    }

    public static void loadData(List<Map> list, DefaultTableModel model) throws Exception {
        int row = 0;
        for (Map r : list) {
            Set keys = r.keySet();
            for (Object k : keys) {
                if (model.findColumn(cu.s(k)) < 0) continue;
                model.setValueAt(r.get(k), row, model.findColumn(cu.s(k)));
            }
            ++row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadData(Connection conn, String sql, JTable tab) throws Exception {
        ResultSet r = null;
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            ResultSetMetaData m = r.getMetaData();
            Object[] cols = new Object[m.getColumnCount()];
            for (int i = 0; i < m.getColumnCount(); ++i) {
                cols[i] = m.getColumnName(i + 1);
            }
            DefaultTableModel model = new DefaultTableModel(cols, 0);
            TableUtils.loadData(r, model);
            tab.setModel(model);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (r != null) {
                r.getStatement().close();
                r.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDataDb(Connection conn, String sql, final JTable tab, String pk) throws Exception {
        ResultSet r = null;
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            ResultSetMetaData m = r.getMetaData();
            Object[] cols = new Object[m.getColumnCount()];
            for (int i = 0; i < m.getColumnCount(); ++i) {
                cols[i] = m.getColumnName(i + 1);
            }
            final DbDefaultTableModel model = new DbDefaultTableModel(cols, 0, pk);
            TableUtils.loadDataDb(r, model);
            tab.setModel(model);
            tab.setRowHeight(20);
            tab.getColumnModel().getColumn(0).setPreferredWidth(30);
            tab.getColumnModel().getColumn(0).setMaxWidth(30);
            tab.getColumnModel().getColumn(0).setMinWidth(30);
            tab.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
                ImageIcon imgAsterisk = new ImageIcon(this.getClass().getResource("/it/tnx/commons/table/asterisk.png"));
                ImageIcon imgEdit = new ImageIcon(this.getClass().getResource("/it/tnx/commons/table/edit.png"));

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel lab = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    lab.setHorizontalAlignment(0);
                    lab.setBackground(UIManager.getDefaults().getColor("OptionPane.background"));
                    lab.setForeground(Color.DARK_GRAY);
                    lab.setText("");
                    if (cu.s(value).equals("*")) {
                        lab.setIcon(this.imgAsterisk);
                    } else if (row == table.getSelectedRow()) {
                        lab.setIcon(this.imgEdit);
                    } else {
                        lab.setIcon(null);
                    }
                    return lab;
                }
            });
            model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (e.getType() == 0 && e.getLastRow() == model.getRowCount() - 1) {
                        model.addRow(new Object[model.getColumnCount()]);
                    }
                }
            });
        }
        finally {
            if (r != null) {
                r.getStatement().close();
                r.close();
            }
        }
        if (tab != null) {
            final JPopupMenu pop = new JPopupMenu("Tabella");
            JMenuItem elimina = new JMenuItem("Elimina");
            elimina.setIcon(new ImageIcon(TableUtils.class.getClass().getResource("/it/tnx/commons/table/delete.png")));
            elimina.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("elimina:" + e);
                    ((DbDefaultTableModel)tab.getModel()).removeRow(tab.getSelectedRow());
                }
            });
            pop.add(elimina);
            tab.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        pop.show(tab, e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        pop.show(tab, e.getX(), e.getY());
                    }
                }
            });
        }
    }

    public static void saveData(Connection conn, JTable tab, String nome_tab, Map<String, Object> campi_default, Map<String, String> nomi_campi) throws Exception {
        String sql = "select * from " + nome_tab + " limit 0";
        ResultSet r = null;
        ResultSetMetaData m = null;
        r = DbUtils.tryOpenResultSet(conn, sql);
        m = r.getMetaData();
        String[] campi = null;
        HashMap<String, Integer> campi_maptipi = new HashMap<String, Integer>();
        HashMap<String, String> campi_maptipis = new HashMap<String, String>();
        campi_maptipi = new HashMap();
        campi_maptipis = new HashMap();
        if (campi == null) {
            campi = new String[m.getColumnCount()];
            for (int i = 0; i < m.getColumnCount(); ++i) {
                String campo;
                campi[i] = campo = m.getColumnName(i + 1);
            }
        }
        for (String campo : campi) {
            Integer index = DbUtils.getColumnIndex(m, campo);
            if (index == null) continue;
            campi_maptipi.put(campo, m.getColumnType(index));
            campi_maptipis.put(campo, m.getColumnTypeName(index));
        }
        int rows = tab.getRowCount();
        int cols = tab.getColumnCount();
        for (int i = 0; i < rows; ++i) {
            System.out.println("tableutils savedata row = " + i);
            sql = "insert into " + nome_tab + " set ";
            for (int c = 0; c < cols; ++c) {
                String campotab = CastUtils.toString(tab.getColumnModel().getColumn(c).getIdentifier());
                if (nomi_campi != null && nomi_campi.containsKey(campotab)) {
                    campotab = nomi_campi.get(campotab);
                }
                String tipocampo = (String)campi_maptipis.get(campotab);
                Object value = null;
                if (campi_default != null && campi_default.containsKey(campotab)) {
                    value = campi_default.get(campotab);
                    if (value == NUMERO_RIGA) {
                        value = i + 1;
                    }
                } else {
                    value = tab.getValueAt(i, c);
                }
                String tipocampoobj = "";
                if (value != null) {
                    tipocampoobj = value.getClass().getName();
                }
                System.out.println(" col:" + c + " campo:" + campotab + " tipocampo:" + tipocampo + " value:" + value + " tipocampoobject:" + tipocampoobj);
                sql = sql + campotab + " = " + DbUtils.sql(value);
                if (c >= cols - 1) continue;
                sql = sql + ", ";
            }
            System.out.println("tableutils savedata sql = " + sql);
            DbUtils.tryExecQuery(conn, sql);
        }
    }

    public static void saveDataDb(Connection conn, JTable tab, String nome_tab, String pk, Map<String, Object> campi_default, Map<String, String> nomi_campi) throws Exception {
        String sql = "select * from " + nome_tab + " limit 0";
        ResultSet r = null;
        ResultSetMetaData m = null;
        r = DbUtils.tryOpenResultSet(conn, sql);
        m = r.getMetaData();
        String[] campi = null;
        HashMap<String, Integer> campi_maptipi = new HashMap<String, Integer>();
        HashMap<String, String> campi_maptipis = new HashMap<String, String>();
        campi_maptipi = new HashMap();
        campi_maptipis = new HashMap();
        if (campi == null) {
            campi = new String[m.getColumnCount()];
            for (int i = 0; i < m.getColumnCount(); ++i) {
                String campo;
                campi[i] = campo = m.getColumnName(i + 1);
            }
        }
        for (String campo : campi) {
            Integer index = DbUtils.getColumnIndex(m, campo);
            if (index == null) continue;
            campi_maptipi.put(campo, m.getColumnType(index));
            campi_maptipis.put(campo, m.getColumnTypeName(index));
        }
        DbDefaultTableModel model = (DbDefaultTableModel)tab.getModel();
        if (model.deletedPk.size() > 0) {
            for (Object pkToDel : model.deletedPk) {
                sql = "delete from " + nome_tab + " where " + pk + " = " + dbu.sql(pkToDel);
                dbu.tryExecQuery(conn, sql);
            }
            model.deletedPk.clear();
        }
        int rows = tab.getRowCount();
        int cols = tab.getColumnCount();
        for (int i = 0; i < rows; ++i) {
            System.out.println("tableutils savedata row = " + i);
            sql = tab.getValueAt(i, 0).equals("*") ? "insert into " + nome_tab + " set " : "update " + nome_tab + " set ";
            boolean tuttoNull = true;
            for (int c = 1; c < cols; ++c) {
                String campotab = CastUtils.toString(tab.getColumnModel().getColumn(c).getIdentifier());
                if (nomi_campi != null && nomi_campi.containsKey(campotab)) {
                    campotab = nomi_campi.get(campotab);
                }
                String tipocampo = (String)campi_maptipis.get(campotab);
                Object value = null;
                if (campi_default != null && campi_default.containsKey(campotab)) {
                    value = campi_default.get(campotab);
                    if (value == NUMERO_RIGA) {
                        value = i + 1;
                    }
                } else {
                    value = tab.getValueAt(i, c);
                }
                String tipocampoobj = "";
                if (value != null) {
                    tipocampoobj = value.getClass().getName();
                }
                System.out.println(" col:" + c + " campo:" + campotab + " tipocampo:" + tipocampo + " value:" + value + " tipocampoobject:" + tipocampoobj);
                if (value != null && StringUtils.isNotBlank((String)cu.s(value))) {
                    tuttoNull = false;
                }
                sql = sql + campotab + " = " + DbUtils.sql(value);
                if (c >= cols - 1) continue;
                sql = sql + ", ";
            }
            if (!tab.getValueAt(i, 0).equals("*")) {
                Integer colPk = tab.getColumn(pk).getModelIndex();
                Object valPk = tab.getValueAt(i, colPk);
                sql = sql + " where " + pk + " = " + dbu.sql(valPk);
            }
            boolean esegui = true;
            if (tab.getValueAt(i, 0).equals("*") && tuttoNull) {
                esegui = false;
            }
            if (!esegui) continue;
            System.out.println("tableutils savedata sql = " + sql);
            dbu.tryExecQuery(conn, sql);
        }
    }

    public static List<Map> getListMap(JTable tab) {
        ArrayList<Map> list = new ArrayList<Map>();
        for (int row = 0; row < tab.getRowCount(); ++row) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            for (int icol = 0; icol < tab.getColumnCount(); ++icol) {
                m.put(tab.getColumnName(icol), tab.getValueAt(row, icol));
            }
            list.add(m);
        }
        return list;
    }

    public static Map getMap(JTable tab, int row) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (int icol = 0; icol < tab.getColumnCount(); ++icol) {
            m.put(tab.getColumnName(icol), tab.getValueAt(row, icol));
        }
        return m;
    }

    public static void hideColumn(JTable tab, String columnTitle) {
        tab.getColumn(columnTitle).setMinWidth(0);
        tab.getColumn(columnTitle).setMaxWidth(0);
        tab.getColumn(columnTitle).setPreferredWidth(0);
        tab.getColumn(columnTitle).setWidth(0);
    }

    public static void hideColumnExcept(JTable tab, String ... columns) {
        List<String> list = Arrays.asList(columns);
        for (int icol = 0; icol < tab.getColumnCount(); ++icol) {
            String colTitle = tab.getColumnName(icol);
            if (list.contains(colTitle)) continue;
            TableUtils.hideColumn(tab, colTitle);
        }
    }
}

