/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons.tail;

import it.tnx.commons.tail.LogFileTailerListener;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Set;

public class LogFileTailer
extends Thread {
    private long sampleInterval = 5000L;
    private File logfile;
    private boolean startAtBeginning = false;
    private boolean tailing = false;
    private Set listeners = new HashSet();

    public LogFileTailer(File file) {
        this.logfile = file;
    }

    public LogFileTailer(File file, long sampleInterval, boolean startAtBeginning) {
        this.logfile = file;
        this.sampleInterval = sampleInterval;
    }

    public void addLogFileTailerListener(LogFileTailerListener l) {
        this.listeners.add(l);
    }

    public void removeLogFileTailerListener(LogFileTailerListener l) {
        this.listeners.remove(l);
    }

    protected void fireNewLogFileLine(String line) {
        for (LogFileTailerListener l : this.listeners) {
            l.newLogFileLine(line);
        }
    }

    public void stopTailing() {
        this.tailing = false;
    }

    @Override
    public void run() {
        long filePointer = 0L;
        filePointer = this.startAtBeginning ? 0L : this.logfile.length();
        try {
            this.tailing = true;
            RandomAccessFile file = new RandomAccessFile(this.logfile, "r");
            while (this.tailing) {
                try {
                    long fileLength = this.logfile.length();
                    if (fileLength < filePointer) {
                        file = new RandomAccessFile(this.logfile, "r");
                        filePointer = 0L;
                    }
                    if (fileLength > filePointer) {
                        file.seek(filePointer);
                        String line = file.readLine();
                        while (line != null) {
                            this.fireNewLogFileLine(line);
                            line = file.readLine();
                        }
                        filePointer = file.getFilePointer();
                    }
                    LogFileTailer.sleep(this.sampleInterval);
                }
                catch (Exception e) {}
            }
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

