/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.exifRewrite;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryFileParser;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceArray;
import org.apache.sanselan.common.byteSources.ByteSourceFile;
import org.apache.sanselan.common.byteSources.ByteSourceInputStream;
import org.apache.sanselan.formats.jpeg.JpegConstants;
import org.apache.sanselan.formats.jpeg.JpegUtils;
import org.apache.sanselan.formats.tiff.write.TiffImageWriterBase;
import org.apache.sanselan.formats.tiff.write.TiffImageWriterLossless;
import org.apache.sanselan.formats.tiff.write.TiffImageWriterLossy;
import org.apache.sanselan.formats.tiff.write.TiffOutputSet;
import org.apache.sanselan.util.Debug;

public class ExifRewriter
extends BinaryFileParser
implements JpegConstants {
    public ExifRewriter() {
        this.setByteOrder(77);
    }

    public ExifRewriter(int byteOrder) {
        this.setByteOrder(byteOrder);
    }

    private JFIFPieces analyzeJFIF(ByteSource byteSource) throws ImageReadException, IOException {
        final ArrayList pieces = new ArrayList();
        final ArrayList exifPieces = new ArrayList();
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            @Override
            public boolean beginSOS() {
                return true;
            }

            @Override
            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
                pieces.add(new JFIFPieceImageData(markerBytes, imageData));
            }

            @Override
            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
                if (marker != 65505) {
                    pieces.add(new JFIFPieceSegment(marker, markerBytes, markerLengthBytes, segmentData));
                } else if (!BinaryFileParser.byteArrayHasPrefix(segmentData, JpegConstants.ExifIdentifierCode)) {
                    pieces.add(new JFIFPieceSegment(marker, markerBytes, markerLengthBytes, segmentData));
                } else {
                    JFIFPieceSegmentExif piece = new JFIFPieceSegmentExif(marker, markerBytes, markerLengthBytes, segmentData);
                    pieces.add(piece);
                    exifPieces.add(piece);
                }
                return true;
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        return new JFIFPieces(pieces, exifPieces);
    }

    public void removeExifMetadata(File src, OutputStream os) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceFile byteSource = new ByteSourceFile(src);
        this.removeExifMetadata(byteSource, os);
    }

    public void removeExifMetadata(byte[] src, OutputStream os) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceArray byteSource = new ByteSourceArray(src);
        this.removeExifMetadata(byteSource, os);
    }

    public void removeExifMetadata(InputStream src, OutputStream os) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceInputStream byteSource = new ByteSourceInputStream(src, null);
        this.removeExifMetadata(byteSource, os);
    }

    public void removeExifMetadata(ByteSource byteSource, OutputStream os) throws ImageReadException, IOException, ImageWriteException {
        JFIFPieces jfifPieces = this.analyzeJFIF(byteSource);
        List pieces = jfifPieces.pieces;
        this.writeSegmentsReplacingExif(os, pieces, null);
    }

    public void updateExifMetadataLossless(File src, OutputStream os, TiffOutputSet outputSet) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceFile byteSource = new ByteSourceFile(src);
        this.updateExifMetadataLossless(byteSource, os, outputSet);
    }

    public void updateExifMetadataLossless(byte[] src, OutputStream os, TiffOutputSet outputSet) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceArray byteSource = new ByteSourceArray(src);
        this.updateExifMetadataLossless(byteSource, os, outputSet);
    }

    public void updateExifMetadataLossless(InputStream src, OutputStream os, TiffOutputSet outputSet) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceInputStream byteSource = new ByteSourceInputStream(src, null);
        this.updateExifMetadataLossless(byteSource, os, outputSet);
    }

    public void updateExifMetadataLossless(ByteSource byteSource, OutputStream os, TiffOutputSet outputSet) throws ImageReadException, IOException, ImageWriteException {
        TiffImageWriterBase writer;
        JFIFPieces jfifPieces = this.analyzeJFIF(byteSource);
        List pieces = jfifPieces.pieces;
        if (jfifPieces.exifPieces.size() > 0) {
            JFIFPieceSegment exifPiece = null;
            exifPiece = (JFIFPieceSegment)jfifPieces.exifPieces.get(0);
            byte[] exifBytes = exifPiece.segmentData;
            exifBytes = this.getByteArrayTail("trimmed exif bytes", exifBytes, 6);
            writer = new TiffImageWriterLossless(outputSet.byteOrder, exifBytes);
        } else {
            writer = new TiffImageWriterLossy(outputSet.byteOrder);
        }
        boolean includeEXIFPrefix = true;
        byte[] newBytes = this.writeExifSegment(writer, outputSet, includeEXIFPrefix);
        this.writeSegmentsReplacingExif(os, pieces, newBytes);
    }

    public void updateExifMetadataLossy(byte[] src, OutputStream os, TiffOutputSet outputSet) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceArray byteSource = new ByteSourceArray(src);
        this.updateExifMetadataLossy(byteSource, os, outputSet);
    }

    public void updateExifMetadataLossy(InputStream src, OutputStream os, TiffOutputSet outputSet) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceInputStream byteSource = new ByteSourceInputStream(src, null);
        this.updateExifMetadataLossy(byteSource, os, outputSet);
    }

    public void updateExifMetadataLossy(File src, OutputStream os, TiffOutputSet outputSet) throws ImageReadException, IOException, ImageWriteException {
        ByteSourceFile byteSource = new ByteSourceFile(src);
        this.updateExifMetadataLossy(byteSource, os, outputSet);
    }

    public void updateExifMetadataLossy(ByteSource byteSource, OutputStream os, TiffOutputSet outputSet) throws ImageReadException, IOException, ImageWriteException {
        JFIFPieces jfifPieces = this.analyzeJFIF(byteSource);
        List pieces = jfifPieces.pieces;
        TiffImageWriterLossy writer = new TiffImageWriterLossy(outputSet.byteOrder);
        boolean includeEXIFPrefix = true;
        byte[] newBytes = this.writeExifSegment(writer, outputSet, includeEXIFPrefix);
        this.writeSegmentsReplacingExif(os, pieces, newBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSegmentsReplacingExif(OutputStream os, List segments, byte[] newBytes) throws ImageWriteException, IOException {
        int byteOrder = this.getByteOrder();
        try {
            os.write(SOI);
            boolean hasExif = false;
            for (int i = 0; i < segments.size(); ++i) {
                JFIFPiece piece = (JFIFPiece)segments.get(i);
                if (!(piece instanceof JFIFPieceSegmentExif)) continue;
                hasExif = true;
            }
            if (!hasExif && newBytes != null) {
                byte[] markerBytes = this.convertShortToByteArray(65505, byteOrder);
                if (newBytes.length > 65535) {
                    throw new ExifOverflowException("APP1 Segment is too long: " + newBytes.length);
                }
                int markerLength = newBytes.length + 2;
                byte[] markerLengthBytes = this.convertShortToByteArray(markerLength, byteOrder);
                int index = 0;
                JFIFPieceSegment firstSegment = (JFIFPieceSegment)segments.get(index);
                if (firstSegment.marker == 65504) {
                    index = 1;
                }
                segments.add(0, new JFIFPieceSegmentExif(65505, markerBytes, markerLengthBytes, newBytes));
            }
            boolean APP1Written = false;
            for (int i = 0; i < segments.size(); ++i) {
                JFIFPiece piece = (JFIFPiece)segments.get(i);
                if (piece instanceof JFIFPieceSegmentExif) {
                    if (APP1Written) continue;
                    APP1Written = true;
                    if (newBytes == null) continue;
                    byte[] markerBytes = this.convertShortToByteArray(65505, byteOrder);
                    if (newBytes.length > 65535) {
                        throw new ExifOverflowException("APP1 Segment is too long: " + newBytes.length);
                    }
                    int markerLength = newBytes.length + 2;
                    byte[] markerLengthBytes = this.convertShortToByteArray(markerLength, byteOrder);
                    os.write(markerBytes);
                    os.write(markerLengthBytes);
                    os.write(newBytes);
                    continue;
                }
                piece.write(os);
            }
        }
        finally {
            try {
                os.close();
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    private byte[] writeExifSegment(TiffImageWriterBase writer, TiffOutputSet outputSet, boolean includeEXIFPrefix) throws IOException, ImageWriteException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (includeEXIFPrefix) {
            os.write(ExifIdentifierCode);
            os.write(0);
            os.write(0);
        }
        writer.write(os, outputSet);
        return os.toByteArray();
    }

    public static class ExifOverflowException
    extends ImageWriteException {
        public ExifOverflowException(String s) {
            super(s);
        }
    }

    private static class JFIFPieceImageData
    extends JFIFPiece {
        public final byte[] markerBytes;
        public final byte[] imageData;

        public JFIFPieceImageData(byte[] markerBytes, byte[] imageData) {
            this.markerBytes = markerBytes;
            this.imageData = imageData;
        }

        @Override
        protected void write(OutputStream os) throws IOException {
            os.write(this.markerBytes);
            os.write(this.imageData);
        }
    }

    private static class JFIFPieceSegmentExif
    extends JFIFPieceSegment {
        public JFIFPieceSegmentExif(int marker, byte[] markerBytes, byte[] markerLengthBytes, byte[] segmentData) {
            super(marker, markerBytes, markerLengthBytes, segmentData);
        }
    }

    private static class JFIFPieceSegment
    extends JFIFPiece {
        public final int marker;
        public final byte[] markerBytes;
        public final byte[] markerLengthBytes;
        public final byte[] segmentData;

        public JFIFPieceSegment(int marker, byte[] markerBytes, byte[] markerLengthBytes, byte[] segmentData) {
            this.marker = marker;
            this.markerBytes = markerBytes;
            this.markerLengthBytes = markerLengthBytes;
            this.segmentData = segmentData;
        }

        @Override
        protected void write(OutputStream os) throws IOException {
            os.write(this.markerBytes);
            os.write(this.markerLengthBytes);
            os.write(this.segmentData);
        }
    }

    private static abstract class JFIFPiece {
        private JFIFPiece() {
        }

        protected abstract void write(OutputStream var1) throws IOException;
    }

    private static class JFIFPieces {
        public final List pieces;
        public final List exifPieces;

        public JFIFPieces(List pieces, List exifPieces) {
            this.pieces = pieces;
            this.exifPieces = exifPieces;
        }
    }
}

