/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.sampleUsage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.formats.jpeg.JpegImageMetadata;
import org.apache.sanselan.formats.jpeg.exifRewrite.ExifRewriter;
import org.apache.sanselan.formats.tiff.TiffImageMetadata;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;
import org.apache.sanselan.formats.tiff.write.TiffOutputDirectory;
import org.apache.sanselan.formats.tiff.write.TiffOutputField;
import org.apache.sanselan.formats.tiff.write.TiffOutputSet;

public class WriteExifMetadataExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExifMetadata(File jpegImageFile, File dst) throws IOException, ImageReadException, ImageWriteException {
        OutputStream os = null;
        try {
            os = new FileOutputStream(dst);
            os = new BufferedOutputStream(os);
            new ExifRewriter().removeExifMetadata(jpegImageFile, os);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeExifMetadata(File jpegImageFile, File dst) throws IOException, ImageReadException, ImageWriteException {
        OutputStream os = null;
        try {
            TiffOutputField aperture;
            TiffImageMetadata exif;
            TiffOutputSet outputSet = null;
            IImageMetadata metadata = Sanselan.getMetadata(jpegImageFile);
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            if (null != jpegMetadata && null != (exif = jpegMetadata.getExif())) {
                outputSet = exif.getOutputSet();
            }
            if (null == outputSet) {
                outputSet = new TiffOutputSet();
            }
            if (null != (aperture = outputSet.findField(TiffConstants.EXIF_TAG_APERTURE_VALUE))) {
                outputSet.removeField(TiffConstants.EXIF_TAG_APERTURE_VALUE);
            }
            aperture = TiffOutputField.create(TiffConstants.EXIF_TAG_APERTURE_VALUE, outputSet.byteOrder, new Double(0.3));
            TiffOutputDirectory exifDirectory = outputSet.getOrCreateExifDirectory();
            exifDirectory.add(aperture);
            double longitude = -74.0;
            double latitude = 40.71666666666667;
            outputSet.setGPSInDegrees(longitude, latitude);
            os = new FileOutputStream(dst);
            os = new BufferedOutputStream(os);
            new ExifRewriter().updateExifMetadataLossless(jpegImageFile, os, outputSet);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

