/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.io;

import com.google.common.io.CountingOutputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

public class PrimitiveOutput {
    private final CountingOutputStream dataOutStream;
    private final DataOutput dataOut;

    public PrimitiveOutput(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("Invalid OutputStream: null");
        }
        this.dataOutStream = new CountingOutputStream(outputStream);
        this.dataOut = new LittleEndianDataOutputStream((OutputStream)this.dataOutStream);
    }

    public void align(Alignment alignment) throws IOException {
        if (alignment == Alignment.ONE) {
            return;
        }
        long alignmentOffset = (long)alignment.getOffByOneAlignment() + this.dataOutStream.getCount() & (long)(~alignment.getOffByOneAlignment());
        this.pad(alignmentOffset - this.dataOutStream.getCount());
    }

    public long getCount() {
        return this.dataOutStream.getCount();
    }

    public void pad(long n) throws IOException {
        while (n-- > 0L) {
            this.writeByte(0);
        }
    }

    public void write(int b) throws IOException {
        this.dataOut.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.dataOut.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.dataOut.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.dataOut.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.dataOut.writeByte(v);
    }

    public void writeShort(int v) throws IOException {
        this.dataOut.writeShort(v);
    }

    public void writeChar(int v) throws IOException {
        this.dataOut.writeChar(v);
    }

    public void writeInt(int v) throws IOException {
        this.dataOut.writeInt(v);
    }

    public void writeInt(long v) throws IOException {
        this.writeInt((int)v);
    }

    public void writeLong(long v) throws IOException {
        this.dataOut.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.dataOut.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.dataOut.writeDouble(v);
    }

    public void writeBytes(String s) throws IOException {
        this.dataOut.writeBytes(s);
    }

    public void writeChars(String s) throws IOException {
        this.dataOut.writeChars(s);
    }
}

