/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.io.ndr.arrays;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.PacketOutput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.arrays.RPCConformantBuffer;
import java.io.IOException;

public abstract class RPCConformantArray<T>
extends RPCConformantBuffer {
    private T[] array;

    public RPCConformantArray(T[] array) {
        super(array.length);
        this.array = array;
    }

    protected abstract void unmarshalEntryPreamble(PacketInput var1, int var2) throws IOException;

    protected abstract void unmarshalEntryEntity(PacketInput var1, int var2) throws IOException;

    protected abstract void unmarshalEntryDeferrals(PacketInput var1, int var2) throws IOException;

    protected abstract void marshalEntryPreamble(PacketOutput var1, int var2) throws IOException;

    protected abstract void marshalEntryEntity(PacketOutput var1, int var2) throws IOException;

    protected abstract void marshalEntryDeferrals(PacketOutput var1, int var2) throws IOException;

    public T[] getArray() {
        return this.array;
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        int i;
        for (i = 0; i < this.array.length; ++i) {
            this.unmarshalEntryPreamble(in, i);
        }
        for (i = 0; i < this.array.length; ++i) {
            this.unmarshalEntryEntity(in, i);
        }
        for (i = 0; i < this.array.length; ++i) {
            this.unmarshalEntryDeferrals(in, i);
        }
    }

    @Override
    public void marshalPreamble(PacketOutput out) throws IOException {
        out.align(Alignment.FOUR);
        out.writeInt(this.getMaximumCount());
    }

    @Override
    public void marshalEntity(PacketOutput out) throws IOException {
    }

    @Override
    public void marshalDeferrals(PacketOutput out) throws IOException {
        int i;
        if (this.array == null) {
            return;
        }
        for (i = 0; i < this.array.length; ++i) {
            this.marshalEntryPreamble(out, i);
        }
        for (i = 0; i < this.array.length; ++i) {
            this.marshalEntryEntity(out, i);
        }
        for (i = 0; i < this.array.length; ++i) {
            this.marshalEntryDeferrals(out, i);
        }
    }
}

