/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssamr.messages;

import com.rapid7.client.dcerpc.io.PacketOutput;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.messages.RequestCall;
import com.rapid7.client.dcerpc.mssamr.messages.SamrQueryDisplayInformation2Response;
import com.rapid7.client.dcerpc.mssamr.objects.DisplayInformationClass;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRDomainDisplayGroupBuffer;
import java.io.IOException;

public abstract class SamrQueryDisplayInformation2Request<T extends Unmarshallable>
extends RequestCall<SamrQueryDisplayInformation2Response<T>> {
    public static final short OP_NUM = 48;
    private final byte[] domainHandle;
    private final int index;
    private final int entryCount;
    private final int preferredMaximumLength;

    public SamrQueryDisplayInformation2Request(byte[] domainHandle, int index, int entryCount, int preferredMaximumLength) {
        super((short)48);
        this.domainHandle = domainHandle;
        this.index = index;
        this.entryCount = entryCount;
        this.preferredMaximumLength = preferredMaximumLength;
    }

    public abstract DisplayInformationClass getDisplayInformationClass();

    @Override
    public void marshal(PacketOutput packetOut) throws IOException {
        packetOut.write(this.domainHandle);
        packetOut.writeShort(this.getDisplayInformationClass().getInfoLevel());
        packetOut.pad(2L);
        packetOut.writeInt(this.index);
        packetOut.writeInt(this.entryCount);
        packetOut.writeInt(this.preferredMaximumLength);
    }

    public static class DomainDisplayGroup
    extends SamrQueryDisplayInformation2Request<SAMPRDomainDisplayGroupBuffer> {
        public DomainDisplayGroup(byte[] domainHandle, int index, int entryCount, int preferredMaximumLength) {
            super(domainHandle, index, entryCount, preferredMaximumLength);
        }

        @Override
        public DisplayInformationClass getDisplayInformationClass() {
            return DisplayInformationClass.DomainDisplayGroup;
        }

        @Override
        public SamrQueryDisplayInformation2Response.DomainDisplayGroup getResponseObject() {
            return new SamrQueryDisplayInformation2Response.DomainDisplayGroup();
        }
    }
}

