/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssamr.messages;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.messages.RequestResponse;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRUserAllInformation;
import com.rapid7.client.dcerpc.mssamr.objects.UserInformationClass;
import java.io.IOException;
import java.rmi.UnmarshalException;

public abstract class SamrQueryInformationUserResponse<T extends Unmarshallable>
extends RequestResponse {
    private T userInformation;

    public T getUserInformation() {
        return this.userInformation;
    }

    public abstract UserInformationClass getUserInformationClass();

    abstract T createUserInformation();

    @Override
    public void unmarshalResponse(PacketInput packetIn) throws IOException {
        if (packetIn.readReferentID() != 0) {
            int infoLevel = packetIn.readUnsignedShort();
            if (infoLevel != this.getUserInformationClass().getInfoLevel()) {
                throw new UnmarshalException(String.format("Incoming USER_INFORMATION_CLASS %d does not match expected: %d", infoLevel, this.getUserInformationClass().getInfoLevel()));
            }
            this.userInformation = this.createUserInformation();
            packetIn.readUnmarshallable(this.userInformation);
        } else {
            this.userInformation = null;
        }
    }

    public static class UserAllInformation
    extends SamrQueryInformationUserResponse<SAMPRUserAllInformation> {
        @Override
        public UserInformationClass getUserInformationClass() {
            return UserInformationClass.USER_ALL_INFORMATION;
        }

        @Override
        SAMPRUserAllInformation createUserInformation() {
            return new SAMPRUserAllInformation();
        }
    }
}

