/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.PacketOutput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Marshallable;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.Objects;

public abstract class WChar
implements Unmarshallable,
Marshallable {
    private String value = "";
    private int offset;
    private int actualCount;

    public abstract boolean isNullTerminated();

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Expected non-null value");
        }
        this.value = value;
    }

    @Override
    public void marshalPreamble(PacketOutput out) throws IOException {
        out.align(Alignment.FOUR);
        out.writeInt(this.getCodePoints());
    }

    @Override
    public void marshalEntity(PacketOutput out) throws IOException {
        out.align(Alignment.FOUR);
        out.writeInt(0);
        out.writeInt(this.getCodePoints());
    }

    @Override
    public void marshalDeferrals(PacketOutput out) throws IOException {
        out.writeChars(this.value);
        if (this.isNullTerminated()) {
            out.writeShort(0);
        }
    }

    @Override
    public void unmarshalPreamble(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        in.fullySkipBytes(4);
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        this.offset = this.readIndex("Offset", in);
        this.actualCount = this.readIndex("ActualCount", in);
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        boolean nullTerminated;
        int length;
        in.align(Alignment.TWO);
        in.fullySkipBytes(2 * this.offset);
        if (this.isNullTerminated() && this.actualCount > 0) {
            length = this.actualCount - 1;
            nullTerminated = true;
        } else {
            length = this.actualCount;
            nullTerminated = false;
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(in.readChar());
        }
        this.value = sb.toString();
        if (nullTerminated) {
            in.fullySkipBytes(2);
        }
    }

    public int hashCode() {
        return Objects.hash(this.isNullTerminated(), this.getValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WChar)) {
            return false;
        }
        WChar other = (WChar)obj;
        return this.isNullTerminated() == other.isNullTerminated() && Objects.equals(this.getValue(), other.getValue());
    }

    public String toString() {
        return this.getValue() == null ? "null" : String.format("\"%s\"", this.getValue());
    }

    private int getCodePoints() {
        return this.getValue().length() + (this.isNullTerminated() ? 1 : 0);
    }

    private int readIndex(String name, PacketInput in) throws IOException {
        long ret = in.readUnsignedInt();
        if (ret > Integer.MAX_VALUE) {
            throw new UnmarshalException(String.format("%s %d > %d", name, ret, Integer.MAX_VALUE));
        }
        return (int)ret;
    }

    public static class NonNullTerminated
    extends WChar {
        public static NonNullTerminated of(String value) {
            NonNullTerminated ret = new NonNullTerminated();
            ret.setValue(value);
            return ret;
        }

        @Override
        public boolean isNullTerminated() {
            return false;
        }
    }

    public static class NullTerminated
    extends WChar {
        public static NullTerminated of(String value) {
            NullTerminated ret = new NullTerminated();
            ret.setValue(value);
            return ret;
        }

        @Override
        public boolean isNullTerminated() {
            return true;
        }
    }
}

