/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.transport;

import com.rapid7.client.dcerpc.Interface;
import com.rapid7.client.dcerpc.PDUType;
import com.rapid7.client.dcerpc.PFCFlag;
import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.PacketOutput;
import com.rapid7.client.dcerpc.io.Transport;
import com.rapid7.client.dcerpc.messages.BindRequest;
import com.rapid7.client.dcerpc.messages.BindResponse;
import com.rapid7.client.dcerpc.messages.Request;
import com.rapid7.client.dcerpc.messages.RequestCall;
import com.rapid7.client.dcerpc.messages.RequestResponse;
import com.rapid7.client.dcerpc.messages.Response;
import com.rapid7.client.dcerpc.transport.exceptions.RPCFaultException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class RPCTransport
implements Transport {
    protected static final int DEFAULT_MAX_XMIT_FRAG = 16384;
    protected static final int DEFAULT_MAX_RECV_FRAG = 16384;
    private final AtomicInteger callID = new AtomicInteger();
    private int maxXmitFrag = 16384;
    private int maxRecvFrag = 16384;

    public void bind(Interface abstractSyntax, Interface transferSyntax) throws IOException {
        BindRequest request = new BindRequest(16384, 16384, abstractSyntax, transferSyntax);
        ByteArrayOutputStream packetOutputStream = new ByteArrayOutputStream();
        PacketOutput packetOut = new PacketOutput(packetOutputStream);
        request.setCallID(this.getCallID());
        request.setPFCFlags(EnumSet.of(PFCFlag.FIRST_FRAGMENT, PFCFlag.LAST_FRAGMENT));
        request.marshal(packetOut);
        byte[] packetInBytes = new byte[this.getMaxXmitFrag()];
        int packetInByteLength = this.transact(packetOutputStream.toByteArray(), packetInBytes);
        ByteArrayInputStream packetInputStream = new ByteArrayInputStream(packetInBytes, 0, packetInByteLength);
        PacketInput packetIn = new PacketInput(packetInputStream);
        BindResponse response = new BindResponse();
        response.unmarshal(packetIn);
        if (!response.isACK()) {
            throw new IOException(String.format("BIND %s (%s) failed.", abstractSyntax.getName(), abstractSyntax.getRepr()));
        }
        this.setMaxXmitFrag(response.getMaxXmitFrag());
        this.setMaxRecvFrag(response.getMaxRecvFrag());
    }

    public <T extends RequestResponse> T call(RequestCall<T> call) throws IOException {
        ByteArrayOutputStream requestPacketOutputStream = new ByteArrayOutputStream();
        PacketOutput requestPacketOut = new PacketOutput(requestPacketOutputStream);
        Request request = new Request();
        request.setCallID(this.getCallID());
        request.setPFCFlags(EnumSet.of(PFCFlag.FIRST_FRAGMENT, PFCFlag.LAST_FRAGMENT));
        request.setOpNum(call.getOpNum());
        request.setStub(call.getStub());
        request.marshal(requestPacketOut);
        byte[] packetOutBytes = requestPacketOutputStream.toByteArray();
        byte[] packetInBytes = new byte[this.getMaxXmitFrag()];
        MutableInt packetInByteLength = new MutableInt();
        packetInByteLength.setValue(this.transact(packetOutBytes, packetInBytes));
        ByteArrayOutputStream responseStubOutputStream = new ByteArrayOutputStream();
        Response response = new Response();
        while (true) {
            ByteArrayInputStream packetInputStream = new ByteArrayInputStream(packetInBytes, 0, packetInByteLength.getValue());
            PacketInput packetIn = new PacketInput(packetInputStream);
            response.unmarshal(packetIn);
            responseStubOutputStream.write(response.getStub());
            Set<PFCFlag> pfcFlags = response.getPFCFlags();
            if (pfcFlags.contains((Object)PFCFlag.LAST_FRAGMENT)) break;
            packetInByteLength.setValue(this.read(packetInBytes));
        }
        byte[] responseStub = responseStubOutputStream.toByteArray();
        ByteArrayInputStream stubInputStream = new ByteArrayInputStream(responseStub);
        PacketInput stubIn = new PacketInput(stubInputStream);
        if (response.getPDUType() != PDUType.RESPONSE) {
            if (response.getPDUType() == PDUType.FAULT || response.getPDUType() == PDUType.REJECT) {
                throw RPCFaultException.read(stubIn);
            }
            throw new IOException(String.format("Expected PDU %s but got: %s", new Object[]{PDUType.RESPONSE, response.getPDUType()}));
        }
        T result = call.getResponseObject();
        ((RequestResponse)result).unmarshal(stubIn);
        return result;
    }

    protected int getCallID() {
        return this.callID.getAndIncrement();
    }

    protected int getMaxXmitFrag() {
        return this.maxXmitFrag;
    }

    protected int getMaxRecvFrag() {
        return this.maxRecvFrag;
    }

    protected void setMaxXmitFrag(int maxXmitFrag) {
        this.maxXmitFrag = maxXmitFrag;
    }

    protected void setMaxRecvFrag(int maxRecvFrag) {
        this.maxRecvFrag = maxRecvFrag;
    }
}

