/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.LinkAudience;
import com.dropbox.core.v2.sharing.LinkExpiry;
import com.dropbox.core.v2.sharing.LinkPassword;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class LinkSettings {
    protected final LinkAudience audience;
    protected final LinkExpiry expiry;
    protected final LinkPassword password;

    public LinkSettings(LinkAudience audience, LinkExpiry expiry, LinkPassword password) {
        this.audience = audience;
        this.expiry = expiry;
        this.password = password;
    }

    public LinkSettings() {
        this(null, null, null);
    }

    public LinkAudience getAudience() {
        return this.audience;
    }

    public LinkExpiry getExpiry() {
        return this.expiry;
    }

    public LinkPassword getPassword() {
        return this.password;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.audience, this.expiry, this.password});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            LinkSettings other = (LinkSettings)obj;
            return (this.audience == other.audience || this.audience != null && this.audience.equals((Object)other.audience)) && (this.expiry == other.expiry || this.expiry != null && this.expiry.equals(other.expiry)) && (this.password == other.password || this.password != null && this.password.equals(other.password));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<LinkSettings> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LinkSettings value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.audience != null) {
                g.writeFieldName("audience");
                StoneSerializers.nullable(LinkAudience.Serializer.INSTANCE).serialize(value.audience, g);
            }
            if (value.expiry != null) {
                g.writeFieldName("expiry");
                StoneSerializers.nullable(LinkExpiry.Serializer.INSTANCE).serialize(value.expiry, g);
            }
            if (value.password != null) {
                g.writeFieldName("password");
                StoneSerializers.nullable(LinkPassword.Serializer.INSTANCE).serialize(value.password, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public LinkSettings deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            LinkPassword f_password;
            LinkExpiry f_expiry;
            LinkAudience f_audience;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_audience = null;
                f_expiry = null;
                f_password = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("audience".equals(field)) {
                        f_audience = StoneSerializers.nullable(LinkAudience.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("expiry".equals(field)) {
                        f_expiry = StoneSerializers.nullable(LinkExpiry.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("password".equals(field)) {
                        f_password = StoneSerializers.nullable(LinkPassword.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            LinkSettings value = new LinkSettings(f_audience, f_expiry, f_password);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected LinkAudience audience = null;
        protected LinkExpiry expiry = null;
        protected LinkPassword password = null;

        protected Builder() {
        }

        public Builder withAudience(LinkAudience audience) {
            this.audience = audience;
            return this;
        }

        public Builder withExpiry(LinkExpiry expiry) {
            this.expiry = expiry;
            return this;
        }

        public Builder withPassword(LinkPassword password) {
            this.password = password;
            return this;
        }

        public LinkSettings build() {
            return new LinkSettings(this.audience, this.expiry, this.password);
        }
    }
}

