/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

final class PlasticIconFactory {
    private static Icon checkBoxIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon menuArrowIcon;
    private static Icon expandedTreeIcon;
    private static Icon collapsedTreeIcon;
    private static Icon comboBoxButtonIcon;
    private static Icon closeIcon;
    private static Icon altMaximizeIcon;
    private static Icon maximizeIcon;
    private static Icon minimizeIcon;
    private static Icon iconifyIcon;

    private PlasticIconFactory() {
    }

    private static void drawCheck(Graphics g, int x, int y) {
        g.translate(x, y);
        g.drawLine(3, 5, 3, 5);
        g.fillRect(3, 6, 2, 2);
        g.drawLine(4, 8, 9, 3);
        g.drawLine(5, 8, 9, 4);
        g.drawLine(5, 9, 9, 5);
        g.translate(-x, -y);
    }

    static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    static Icon getExpandedTreeIcon() {
        if (expandedTreeIcon == null) {
            expandedTreeIcon = new ExpandedTreeIcon();
        }
        return expandedTreeIcon;
    }

    static Icon getCollapsedTreeIcon() {
        if (collapsedTreeIcon == null) {
            collapsedTreeIcon = new CollapsedTreeIcon();
        }
        return collapsedTreeIcon;
    }

    static Icon getComboBoxButtonIcon() {
        if (comboBoxButtonIcon == null) {
            comboBoxButtonIcon = new ComboBoxButtonIcon();
        }
        return comboBoxButtonIcon;
    }

    static Icon getCloseIcon() {
        if (closeIcon == null) {
            closeIcon = new CloseIcon();
        }
        return closeIcon;
    }

    static Icon getMaximizeIcon() {
        if (maximizeIcon == null) {
            maximizeIcon = new MaximizeIcon();
        }
        return maximizeIcon;
    }

    static Icon getMinimizeIcon() {
        if (minimizeIcon == null) {
            minimizeIcon = new MinimizeIcon();
        }
        return minimizeIcon;
    }

    static Icon getIconifyIcon() {
        if (iconifyIcon == null) {
            iconifyIcon = new IconifyIcon();
        }
        return iconifyIcon;
    }

    private static class IconifyIcon
    extends CloseIcon {
        private IconifyIcon() {
        }

        public void customPaint(Graphics2D g2) {
            if (this.buttonModel.isPressed() || this.buttonModel.isArmed()) {
                g2.setColor(Color.RED);
            } else {
                g2.setColor(Color.DARK_GRAY);
            }
            g2.setStroke(new BasicStroke(2.0f, 1, 1));
            g2.drawLine(4, 10, 10, 10);
        }
    }

    private static class MinimizeIcon
    extends CloseIcon {
        private MinimizeIcon() {
        }

        public void customPaint(Graphics2D g2) {
            if (this.buttonModel.isPressed() || this.buttonModel.isArmed()) {
                g2.setColor(Color.RED);
            } else {
                g2.setColor(Color.DARK_GRAY);
            }
            g2.setStroke(new BasicStroke(2.0f, 1, 1));
            g2.drawRect(5, 2, 7, 7);
            g2.drawRect(2, 5, 7, 7);
        }
    }

    private static class MaximizeIcon
    extends CloseIcon {
        private MaximizeIcon() {
        }

        public void customPaint(Graphics2D g2) {
            if (this.buttonModel.isPressed() || this.buttonModel.isArmed()) {
                g2.setColor(Color.RED);
            } else {
                g2.setColor(Color.DARK_GRAY);
            }
            g2.setStroke(new BasicStroke(2.0f, 1, 1));
            g2.drawRect(2, 2, 10, 10);
        }
    }

    private static class CloseIcon
    implements Icon {
        ButtonModel buttonModel;
        static final int SIZE = 14;

        private CloseIcon() {
        }

        public int getIconWidth() {
            return 14;
        }

        public int getIconHeight() {
            return 14;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JButton parentButton = (JButton)c;
            this.buttonModel = parentButton.getModel();
            ColorUIResource backgroundColor = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource internalBackgroundColor = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource mainItemColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource darkHighlightColor = MetalLookAndFeel.getBlack();
            ColorUIResource xLightHighlightColor = MetalLookAndFeel.getWhite();
            ColorUIResource boxLightHighlightColor = MetalLookAndFeel.getWhite();
            if (parentButton.getClientProperty("paintActive") != Boolean.TRUE) {
                internalBackgroundColor = backgroundColor = MetalLookAndFeel.getControl();
                mainItemColor = MetalLookAndFeel.getControlDarkShadow();
                if (this.buttonModel.isPressed() && this.buttonModel.isArmed()) {
                    xLightHighlightColor = internalBackgroundColor = MetalLookAndFeel.getControlShadow();
                    mainItemColor = darkHighlightColor;
                }
            } else if (this.buttonModel.isPressed() && this.buttonModel.isArmed()) {
                xLightHighlightColor = internalBackgroundColor = MetalLookAndFeel.getPrimaryControlShadow();
                mainItemColor = darkHighlightColor;
            }
            g.translate(x, y);
            g.setColor(backgroundColor);
            g.fillRect(0, 0, 14, 14);
            Graphics2D g2 = (Graphics2D)g;
            Object old_antialiasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            Object old_alpha_interp = g2.getRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            Color oldcolor = g2.getColor();
            Stroke oldstroke = g2.getStroke();
            g2.translate(x, y);
            this.customPaint(g2);
            g2.translate(-x, -y);
            g2.setColor(oldcolor);
            g2.setStroke(oldstroke);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, old_antialiasing);
            if (old_alpha_interp == null) {
                g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, old_alpha_interp);
            }
        }

        public void customPaint(Graphics2D g2) {
            if (this.buttonModel.isPressed() || this.buttonModel.isArmed()) {
                g2.setColor(Color.RED);
            } else {
                g2.setColor(Color.DARK_GRAY);
            }
            g2.setStroke(new BasicStroke(2.0f, 1, 1));
            g2.drawLine(3, 3, 11, 11);
            g2.drawLine(3, 11, 11, 3);
        }
    }

    private static class ComboBoxButtonIcon
    implements Icon,
    Serializable {
        private ComboBoxButtonIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JComponent component = (JComponent)c;
            int iconWidth = this.getIconWidth();
            g.translate(x, y);
            g.setColor(component.isEnabled() ? MetalLookAndFeel.getControlInfo() : MetalLookAndFeel.getControlShadow());
            g.drawLine(0, 0, iconWidth - 1, 0);
            g.drawLine(1, 1, 1 + (iconWidth - 3), 1);
            g.drawLine(2, 2, 2 + (iconWidth - 5), 2);
            g.drawLine(3, 3, 3 + (iconWidth - 7), 3);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 8;
        }

        public int getIconHeight() {
            return 4;
        }
    }

    private static class CollapsedTreeIcon
    extends ExpandedTreeIcon {
        private CollapsedTreeIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            g.drawLine(x + 4, y + 2, x + 4, y + 6);
        }
    }

    private static class ExpandedTreeIcon
    implements Icon,
    Serializable {
        protected static final int SIZE = 9;
        protected static final int HALF_SIZE = 4;

        private ExpandedTreeIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.WHITE);
            g.fillRect(x, y, 8, 8);
            g.setColor(Color.GRAY);
            g.drawRect(x, y, 8, 8);
            g.setColor(Color.BLACK);
            g.drawLine(x + 2, y + 4, x + 6, y + 4);
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 9;
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int WIDTH = 4;
        private static final int HEIGHT = 8;

        private MenuArrowIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            g.translate(x, y);
            if (PlasticUtils.isLeftToRight(b)) {
                g.drawLine(0, 0, 0, 7);
                g.drawLine(1, 1, 1, 6);
                g.drawLine(2, 2, 2, 5);
                g.drawLine(3, 3, 3, 4);
            } else {
                g.drawLine(4, 0, 4, 7);
                g.drawLine(3, 1, 3, 6);
                g.drawLine(2, 2, 2, 5);
                g.drawLine(1, 3, 1, 4);
            }
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 4;
        }

        public int getIconHeight() {
            return 8;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = 13;

        private RadioButtonMenuItemIcon() {
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            if (b.isSelected()) {
                this.drawDot(g, x, y);
            }
        }

        private void drawDot(Graphics g, int x, int y) {
            g.translate(x, y);
            g.drawLine(5, 4, 8, 4);
            g.fillRect(4, 5, 6, 4);
            g.drawLine(5, 9, 8, 9);
            g.translate(-x, -y);
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = 13;

        private CheckBoxMenuItemIcon() {
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            if (b.isSelected()) {
                PlasticIconFactory.drawCheck(g, x, y + 1);
            }
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = 13;

        private CheckBoxIcon() {
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JCheckBox cb = (JCheckBox)c;
            ButtonModel model = cb.getModel();
            if (model.isEnabled()) {
                if (cb.isBorderPaintedFlat()) {
                    g.setColor(PlasticLookAndFeel.getControlDarkShadow());
                    g.drawRect(x, y, 11, 11);
                    g.setColor(PlasticLookAndFeel.getControlHighlight());
                    g.fillRect(x + 1, y + 1, 10, 10);
                } else if (model.isPressed() && model.isArmed()) {
                    g.setColor(MetalLookAndFeel.getControlShadow());
                    g.fillRect(x, y, 12, 12);
                    PlasticUtils.drawPressed3DBorder(g, x, y, 13, 13);
                } else {
                    PlasticUtils.drawFlush3DBorder(g, x, y, 13, 13);
                }
                g.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawRect(x, y, 11, 11);
            }
            if (model.isSelected()) {
                PlasticIconFactory.drawCheck(g, x, y);
            }
        }
    }
}

