/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.range.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericRange
extends AbstractNumericRange<Double> {
    protected double _min;
    protected double _max;

    public NumericRange() {
        this(0.0, 1.0);
    }

    public NumericRange(double min, double max) {
        this._min = Math.min(min, max);
        this._max = Math.max(min, max);
    }

    public NumericRange(NumericRange numericRange) {
        this(numericRange.minimum(), numericRange.maximum());
    }

    @Override
    public Range<Double> copy() {
        return new NumericRange(this);
    }

    @Override
    public double minimum() {
        return this._min;
    }

    @Override
    public double maximum() {
        return this._max;
    }

    public double getMin() {
        return this._min;
    }

    public void setMin(double min) {
        double old = this._min;
        if (old == min) {
            return;
        }
        assert (min <= this._max);
        this._min = min;
        this.firePropertyChange("min", old, min);
    }

    public double getMax() {
        return this._max;
    }

    public void setMax(double max) {
        double old = this._max;
        if (old == max) {
            return;
        }
        assert (max >= this._min);
        this._max = max;
        this.firePropertyChange("max", old, max);
    }

    @Override
    public double size() {
        return this._max - this._min;
    }

    @Override
    public Double lower() {
        return this.minimum();
    }

    @Override
    public void adjust(Double lower, Double upper) {
        this.setMin(lower);
        this.setMax(upper);
    }

    @Override
    public Double upper() {
        return this.maximum();
    }

    @Override
    public boolean contains(Double x) {
        return x != null && x >= this._min && x <= this._max;
    }

    public NumericRange stretch(double stretchFactor) {
        return this.stretch(stretchFactor, stretchFactor);
    }

    public NumericRange stretch(double stretchFactorForLower, double stretchFactorForUpper) {
        double mid = (this._max + this._min) / 2.0;
        double halfSize = this.size() / 2.0;
        return new NumericRange(mid - halfSize * stretchFactorForLower, mid + halfSize * stretchFactorForUpper);
    }

    public boolean equals(Object other) {
        if (other instanceof NumericRange) {
            NumericRange otherRange = (NumericRange)other;
            return this._min == otherRange._min && this._max == otherRange._max;
        }
        return false;
    }

    public String toString() {
        return String.format("#<NumericRange min=%f max=%f>", this._min, this._max);
    }

    public static NumericRange union(NumericRange r1, NumericRange r2) {
        if (r1 == null) {
            return r2;
        }
        if (r2 == null) {
            return r1;
        }
        double r1Min = r1._min;
        double r2Min = r2._min;
        double r1Max = r1._max;
        double r2Max = r2._max;
        double min = Math.min(r1Min, r2Min);
        double max = Math.max(r1Max, r2Max);
        return new NumericRange(min, max);
    }
}

