/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CheckBoxListSelectionModel
extends DefaultListSelectionModel
implements ListDataListener {
    private static final long serialVersionUID = -4133723317923726786L;
    private ListModel _model;
    private boolean _allEntryConsidered = true;
    private int _allEntryIndex = -1;
    private boolean _allEntryIndexSet = false;

    public CheckBoxListSelectionModel() {
        this.setSelectionMode(2);
    }

    public CheckBoxListSelectionModel(ListModel model) {
        this._model = model;
        if (this.isAllEntryConsidered()) {
            this._allEntryIndex = this.findAllEntryIndex();
            this._model.addListDataListener(this);
        }
        this.setSelectionMode(2);
    }

    public int getAllEntryIndex() {
        return this._allEntryIndex;
    }

    public void setAllEntryIndex(int allEntryIndex) {
        this._allEntryIndex = allEntryIndex;
        this._allEntryIndexSet = this._allEntryIndex != -1;
    }

    private int findAllEntryIndex() {
        if (this.getModel() == null) {
            return -1;
        }
        for (int i = this.getModel().getSize() - 1; i >= 0; --i) {
            if (!JideSwingUtilities.equals(this.getModel().getElementAt(i), "(All)")) continue;
            return i;
        }
        return -1;
    }

    public ListModel getModel() {
        return this._model;
    }

    public void setModel(ListModel model) {
        int oldLength = 0;
        int newLength = 0;
        if (this._model != null) {
            oldLength = this._model.getSize();
            this._model.removeListDataListener(this);
        }
        this._model = model;
        if (this._model != null) {
            newLength = this._model.getSize();
            this._model.removeListDataListener(this);
            if (this.isAllEntryConsidered()) {
                this._model.addListDataListener(this);
                this._allEntryIndex = this.findAllEntryIndex();
            } else if (!this._allEntryIndexSet) {
                this._allEntryIndex = -1;
            }
        }
        if (oldLength > newLength) {
            this.removeIndexInterval(newLength, oldLength);
        }
    }

    public void intervalAdded(ListDataEvent e) {
        if (this.isAllEntryConsidered()) {
            this._allEntryIndex = this.findAllEntryIndex();
        }
    }

    public void intervalRemoved(ListDataEvent e) {
        if (this.isAllEntryConsidered()) {
            this._allEntryIndex = this.findAllEntryIndex();
        }
    }

    public void contentsChanged(ListDataEvent e) {
        if (this.isAllEntryConsidered()) {
            this._allEntryIndex = this.findAllEntryIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertIndexInterval(int index, int length, boolean before) {
        if (before) {
            boolean old = this.isSelectedIndex(index);
            super.setValueIsAdjusting(true);
            try {
                if (old) {
                    this.removeSelectionInterval(index, index);
                }
                super.insertIndexInterval(index, length, before);
                if (!old) return;
                this.addSelectionInterval(index + length, index + length);
                return;
            }
            finally {
                super.setValueIsAdjusting(false);
            }
        } else {
            super.insertIndexInterval(index, length, before);
        }
    }

    public boolean isAllEntryConsidered() {
        return this._allEntryConsidered;
    }

    public void setAllEntryConsidered(boolean allEntryConsidered) {
        this._allEntryConsidered = allEntryConsidered;
        if (this._model != null) {
            this._model.removeListDataListener(this);
        }
        if (this.isAllEntryConsidered()) {
            this._allEntryIndex = this.findAllEntryIndex();
            if (this._model != null) {
                this._model.addListDataListener(this);
            }
        } else {
            this._allEntryIndex = -1;
        }
    }

    public boolean isSelectedIndex(int index) {
        boolean selected = super.isSelectedIndex(index);
        return selected || this.getAllEntryIndex() >= 0 && super.isSelectedIndex(this.getAllEntryIndex());
    }

    private boolean selectAll(int index0, int index1) {
        if (this.getAllEntryIndex() < 0) {
            return false;
        }
        if (index0 == 0 && index1 == this.getModel().getSize() - 1 || index1 == 0 && index0 == this.getModel().getSize() - 1) {
            return false;
        }
        if (index0 >= this.getAllEntryIndex() && index1 <= this.getAllEntryIndex() || index1 >= this.getAllEntryIndex() && index0 <= this.getAllEntryIndex()) {
            this.setSelectionInterval(0, this.getModel().getSize() - 1);
            return true;
        }
        return false;
    }

    private boolean unselectAll(int index0, int index1) {
        if (this.getAllEntryIndex() < 0) {
            return false;
        }
        if (index0 == this.getAllEntryIndex() || index1 == this.getAllEntryIndex()) {
            this.clearSelection();
            return true;
        }
        return false;
    }

    private void selectAllIf() {
        if (this.getAllEntryIndex() < 0) {
            return;
        }
        for (int i = this.getModel().getSize() - 1; i >= 0; --i) {
            if (i == this.getAllEntryIndex() || this.isSelectedIndex(i)) continue;
            return;
        }
        super.addSelectionInterval(this.getAllEntryIndex(), this.getAllEntryIndex());
    }

    public void setSelectionInterval(int index0, int index1) {
        if (!this.selectAll(index0, index1)) {
            super.setSelectionInterval(index0, index1);
            this.selectAllIf();
        }
    }

    public int getMinSelectionIndex() {
        int index = super.getMinSelectionIndex();
        if (this.getAllEntryIndex() < 0) {
            return index;
        }
        if (super.isSelectedIndex(this.getAllEntryIndex()) && this.getAllEntryIndex() == 0) {
            return 1;
        }
        return index;
    }

    public void addSelectionInterval(int index0, int index1) {
        if (!this.selectAll(index0, index1)) {
            super.addSelectionInterval(index0, index1);
            this.selectAllIf();
        }
    }

    public void removeSelectionInterval(int index0, int index1) {
        if (!this.unselectAll(index0, index1)) {
            if (this.getAllEntryIndex() >= 0) {
                super.removeSelectionInterval(this.getAllEntryIndex(), this.getAllEntryIndex());
            }
            super.removeSelectionInterval(index0, index1);
        }
    }
}

