/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class StyledLabelBuilder {
    private StringBuffer buffer = new StringBuffer();
    private List ranges = new ArrayList();
    private int start = 0;
    private Map styles = new HashMap();
    private static int[] colorShorthandTable = new int[]{0, 17, 34, 51, 68, 85, 102, 119, 136, 153, 170, 187, 204, 221, 238, 255};
    private static Map colorNamesMap = new TreeMap();

    public void clear() {
        this.buffer.delete(0, this.buffer.length());
        this.ranges.clear();
        this.start = 0;
    }

    public StyledLabelBuilder register(String text, Color fontColor) {
        this.styles.put(text, new StyleRange(fontColor));
        return this;
    }

    public StyledLabelBuilder register(String text, int fontStyle) {
        this.styles.put(text, new StyleRange(fontStyle));
        return this;
    }

    public StyledLabelBuilder register(String text, int fontStyle, Color fontColor) {
        this.styles.put(text, new StyleRange(fontStyle, fontColor));
        return this;
    }

    public StyledLabelBuilder register(String text, int fontStyle, Color fontColor, int additionalStyle) {
        this.styles.put(text, new StyleRange(this.start, text.length(), fontStyle, fontColor, additionalStyle));
        return this;
    }

    public StyledLabelBuilder register(String text, int fontStyle, Color fontColor, int additionalStyle, Color lineColor) {
        this.styles.put(text, new StyleRange(this.start, text.length(), fontStyle, fontColor, additionalStyle, lineColor));
        return this;
    }

    public StyledLabelBuilder register(String text, int fontStyle, Color fontColor, int additionalStyle, Color lineColor, Stroke lineStroke) {
        this.styles.put(text, new StyleRange(this.start, text.length(), fontStyle, fontColor, additionalStyle, lineColor, lineStroke));
        return this;
    }

    public StyledLabelBuilder register(String text, int fontStyle, Color fontColor, int additionalStyle, Color lineColor, Stroke lineStroke, float fontShrinkRatio) {
        this.styles.put(text, new StyleRange(this.start, text.length(), fontStyle, fontColor, additionalStyle, lineColor, lineStroke, fontShrinkRatio));
        return this;
    }

    public StyledLabelBuilder register(String text, int fontStyle, int additionalStyle) {
        this.styles.put(text, new StyleRange(this.start, text.length(), fontStyle, additionalStyle));
        return this;
    }

    public StyledLabelBuilder register(String text, int fontStyle, int additionalStyle, float fontShrinkRatio) {
        this.styles.put(text, new StyleRange(this.start, text.length(), fontStyle, additionalStyle, fontShrinkRatio));
        return this;
    }

    public StyledLabelBuilder register(String text, String format) {
        ParsedStyleResult result = StyledLabelBuilder.parseStyleAnnotation(format.toCharArray(), 0, this);
        this.styles.put(text, new StyleRange(result.fontStyle, result.fontColor, result.backgroundColor, result.additionalStyle, result.lineColor));
        return this;
    }

    public StyledLabelBuilder add(String text) {
        this.buffer.append(text);
        this.start += text.length();
        return this;
    }

    public StyledLabelBuilder add(String text, Color fontColor) {
        this.ranges.add(new StyleRange(this.start, text.length(), fontColor));
        return this.add(text);
    }

    public StyledLabelBuilder add(String text, int fontStyle) {
        this.ranges.add(new StyleRange(this.start, text.length(), fontStyle));
        return this.add(text);
    }

    public StyledLabelBuilder add(String text, int fontStyle, Color fontColor) {
        this.ranges.add(new StyleRange(this.start, text.length(), fontStyle, fontColor));
        return this.add(text);
    }

    public StyledLabelBuilder add(String text, int fontStyle, Color fontColor, int additionalStyle) {
        this.ranges.add(new StyleRange(this.start, text.length(), fontStyle, fontColor, additionalStyle));
        return this.add(text);
    }

    public StyledLabelBuilder add(String text, int fontStyle, Color fontColor, int additionalStyle, Color lineColor) {
        this.ranges.add(new StyleRange(this.start, text.length(), fontStyle, fontColor, additionalStyle, lineColor));
        return this.add(text);
    }

    public StyledLabelBuilder add(String text, int fontStyle, Color fontColor, Color backgroundColor, int additionalStyle, Color lineColor) {
        this.ranges.add(new StyleRange(this.start, text.length(), fontStyle, fontColor, backgroundColor, additionalStyle, lineColor));
        return this.add(text);
    }

    public StyledLabelBuilder add(String text, int fontStyle, Color fontColor, Color backgroundColor, int additionalStyle, Color lineColor, Stroke lineStroke) {
        this.ranges.add(new StyleRange(this.start, text.length(), fontStyle, fontColor, backgroundColor, additionalStyle, lineColor, lineStroke));
        return this.add(text);
    }

    public StyledLabelBuilder add(String text, int fontStyle, Color fontColor, int additionalStyle, Color lineColor, Stroke lineStroke, float fontShrinkRatio) {
        this.ranges.add(new StyleRange(this.start, text.length(), fontStyle, fontColor, additionalStyle, lineColor, lineStroke, fontShrinkRatio));
        return this.add(text);
    }

    public StyledLabelBuilder add(String text, String style) {
        StyleRange range = (StyleRange)this.styles.get(style);
        if (range == null) {
            ParsedStyleResult result = StyledLabelBuilder.parseStyleAnnotation(style.toCharArray(), 0, this);
            return this.add(text, result.fontStyle, result.fontColor, result.backgroundColor, result.additionalStyle, result.lineColor);
        }
        return this.add(text, range.getFontStyle(), range.getFontColor(), range.getAdditionalStyle(), range.getLineColor(), range.getLineStroke(), range.getFontShrinkRatio());
    }

    public StyledLabelBuilder add(String text, int fontStyle, int additionalStyle) {
        this.ranges.add(new StyleRange(this.start, text.length(), fontStyle, additionalStyle));
        return this.add(text);
    }

    public StyledLabelBuilder add(String text, int fontStyle, int additionalStyle, float fontShrinkRatio) {
        this.ranges.add(new StyleRange(this.start, text.length(), fontStyle, additionalStyle, fontShrinkRatio));
        return this.add(text);
    }

    public StyledLabel configure(StyledLabel label, String style) {
        StyledLabelBuilder.setStyledText(label, style, this);
        return label;
    }

    public StyledLabel configure(StyledLabel label) {
        label.setText(this.buffer.toString());
        int size = this.ranges.size();
        for (int i = 0; i < size; ++i) {
            label.addStyleRange((StyleRange)this.ranges.get(i));
        }
        return label;
    }

    public StyledLabel createLabel() {
        return this.configure(new StyledLabel());
    }

    public static StyledLabel createStyledLabel(String text) {
        StyledLabel label = new StyledLabel();
        StyledLabelBuilder.setStyledText(label, text);
        return label;
    }

    public static void setStyledText(StyledLabel label, String text) {
        StyledLabelBuilder.setStyledText(label, text.toCharArray());
    }

    private static void setStyledText(StyledLabel label, String text, StyledLabelBuilder builder) {
        StyledLabelBuilder.setStyledText(label, text.toCharArray(), builder);
    }

    public static void setStyledText(StyledLabel label, char[] text) {
        StyledLabelBuilder.setStyledText(label, text, null);
    }

    private static void setStyledText(StyledLabel label, char[] text, StyledLabelBuilder builder) {
        StringBuffer labelText = new StringBuffer(text.length);
        boolean escaped = false;
        label.clearStyleRanges();
        label.setLineWrap(false);
        int endOfText = text.length;
        for (int j = text.length - 1; j >= 0; --j) {
            if (text[j] != '@') continue;
            if (!StyledLabelBuilder.isGlobalConfiguration(label, text, j + 1)) break;
            endOfText = j;
            break;
        }
        block5: for (int i = 0; i < endOfText; ++i) {
            if (escaped) {
                labelText.append(text[i]);
                escaped = false;
                continue;
            }
            switch (text[i]) {
                case '{': {
                    ParsedStyleResult result = StyledLabelBuilder.parseStylePart(text, i + 1, builder);
                    if (result == null) {
                        labelText.append(text[i]);
                        continue block5;
                    }
                    int realIndex = labelText.length();
                    labelText.append(result.text);
                    if (result.text.length() > 0) {
                        label.addStyleRange(new StyleRange(realIndex, result.text.length(), result.fontStyle, result.fontColor, result.backgroundColor, result.additionalStyle, result.lineColor));
                    }
                    i = result.endOffset;
                    continue block5;
                }
                case '\\': {
                    escaped = true;
                    continue block5;
                }
                default: {
                    labelText.append(text[i]);
                }
            }
        }
        label.setText(labelText.toString());
    }

    private static boolean isGlobalConfiguration(StyledLabel label, char[] text, int offset) {
        String globalString = new String(text, offset, text.length - offset);
        String[] subStringsLevel0 = globalString.split(",");
        if (subStringsLevel0.length <= 0 || subStringsLevel0[0] == null) {
            return false;
        }
        int defaultRows = 1;
        int maxRows = 0;
        int minRows = 0;
        int preferredWidth = 0;
        for (String subStringLevel0 : subStringsLevel0) {
            String[] subStrings = subStringLevel0.split(":");
            if (subStrings.length <= 0 || subStrings[0] == null) {
                return false;
            }
            String property = subStrings[0].trim().toLowerCase();
            if ("rows".equals(property) || "row".equals(property) || "r".equals(property)) {
                if (subStrings.length > 4 || subStrings.length < 1) {
                    return false;
                }
                if (subStrings.length >= 2 && subStrings[1].trim().length() > 0) {
                    try {
                        defaultRows = Integer.valueOf(subStrings[1]);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                if (subStrings.length >= 3 && subStrings[2].trim().length() > 0) {
                    try {
                        minRows = Integer.valueOf(subStrings[2]);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                    if (minRows > defaultRows || minRows < 0) {
                        if (subStrings[1].trim().length() > 0) {
                            minRows = 0;
                        } else if (minRows > defaultRows) {
                            defaultRows = minRows;
                        } else {
                            minRows = 0;
                        }
                    }
                }
                if (subStrings.length < 4 || subStrings[3].trim().length() <= 0) continue;
                try {
                    maxRows = Integer.valueOf(subStrings[3]);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (maxRows >= defaultRows && maxRows >= 0) continue;
                maxRows = 0;
                continue;
            }
            if ("w".equals(property) || "width".equals(property) || "preferredwidth".equals(property)) {
                if (subStrings.length != 2) {
                    return false;
                }
                if (subStrings[1].trim().length() <= 0) continue;
                try {
                    preferredWidth = Integer.valueOf(subStrings[1]);
                    continue;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return false;
        }
        label.setLineWrap(true);
        label.setRows(defaultRows);
        label.setMaxRows(maxRows);
        label.setMinRows(minRows);
        label.setPreferredWidth(preferredWidth);
        if (defaultRows == 1 && maxRows == 1 && minRows == 1) {
            label.setLineWrap(false);
        }
        return true;
    }

    public static String parseToVoidStyledTextConfusion(String originalString) {
        String destString = originalString.replaceAll("\\\\", "\\\\\\\\");
        destString = destString.replaceAll("\\{", "\\\\{");
        return destString;
    }

    private static ParsedStyleResult parseStylePart(char[] text, int start, StyledLabelBuilder builder) {
        ParsedStyleResult result = new ParsedStyleResult();
        int i = start;
        int findIndex = StyledLabelBuilder.findNext(text, ':', i);
        if (findIndex < 0) {
            return null;
        }
        result.text = StyledLabelBuilder.createTrimmedString(text, i, findIndex - 1);
        return StyledLabelBuilder.parseStyleAnnotation(text, findIndex + 1, builder, result);
    }

    private static ParsedStyleResult parseStyleAnnotation(char[] text, int start, StyledLabelBuilder builder) {
        ParsedStyleResult result = new ParsedStyleResult();
        return StyledLabelBuilder.parseStyleAnnotation(text, start, builder, result);
    }

    private static ParsedStyleResult parseStyleAnnotation(char[] text, int findIndex, StyledLabelBuilder builder, ParsedStyleResult result) {
        int i = findIndex;
        char[] importantChars = new char[]{',', '}'};
        boolean endOfTag = false;
        while (i < text.length && !endOfTag) {
            String style;
            int colonIndex;
            findIndex = StyledLabelBuilder.findNextOf(text, importantChars, i);
            if (findIndex == -1 || text[findIndex] == '}') {
                endOfTag = true;
            }
            if ((colonIndex = (style = StyledLabelBuilder.createTrimmedString(text, i, findIndex == -1 ? text.length - 1 : findIndex - 1)).indexOf(58)) != -1) {
                String color = style.substring(colonIndex + 1);
                if (color.length() > 1) {
                    if (color.charAt(0) == '(') {
                        findIndex = StyledLabelBuilder.findNext(text, ')', i + colonIndex + 1);
                        style = StyledLabelBuilder.createTrimmedString(text, i, findIndex + 1);
                        color = style.substring(colonIndex + 1);
                        if (text[findIndex + 1] == '}') {
                            endOfTag = true;
                        }
                        ++findIndex;
                    }
                    if (style.charAt(0) == 'f') {
                        result.fontColor = StyledLabelBuilder.toColor(color);
                    } else if (style.charAt(0) == 'b') {
                        result.backgroundColor = StyledLabelBuilder.toColor(color);
                    } else {
                        result.lineColor = StyledLabelBuilder.toColor(color);
                    }
                }
            } else if (style.equals("plain") || style.equals("p")) {
                result.fontStyle = 0;
            } else if (style.equals("bold") || style.equals("b")) {
                result.fontStyle = 1;
            } else if (style.equals("italic") || style.equals("i")) {
                result.fontStyle = 2;
            } else if (style.equals("bolditalic") || style.equals("bi")) {
                result.fontStyle = 3;
            } else if (style.equals("strike") || style.equals("s")) {
                result.additionalStyle |= 1;
            } else if (style.equals("doublestrike") || style.equals("ds")) {
                result.additionalStyle |= 2;
            } else if (style.equals("waved") || style.equals("w")) {
                result.additionalStyle |= 4;
            } else if (style.equals("underlined") || style.equals("u")) {
                result.additionalStyle |= 8;
            } else if (style.equals("dotted") || style.equals("d")) {
                result.additionalStyle |= 0x10;
            } else if (style.equals("superscript") || style.equals("sp")) {
                result.additionalStyle |= 0x20;
            } else if (style.equals("subscript") || style.equals("sb")) {
                result.additionalStyle |= 0x40;
            } else if (builder != null && builder.styles.containsKey(style)) {
                StyleRange range = (StyleRange)builder.styles.get(style);
                result.fontStyle = range.getFontStyle();
                result.fontColor = range.getFontColor();
                result.backgroundColor = range.getBackgroundColor();
                result.additionalStyle = range.getAdditionalStyle();
                result.lineColor = range.getLineColor();
            } else if (style.length() > 0) {
                System.err.println("Unknown style '" + style + "'");
            }
            i = findIndex + 1;
        }
        result.endOffset = i - 1;
        return result;
    }

    private static Color toColor(String str) {
        switch (str.charAt(0)) {
            case '(': {
                int red = StyledLabelBuilder.nextColorInt(str, 1);
                int index = str.indexOf(44);
                int green = StyledLabelBuilder.nextColorInt(str, index + 1);
                index = str.indexOf(44, index + 1);
                int blue = StyledLabelBuilder.nextColorInt(str, index + 1);
                return new Color(red, green, blue);
            }
            case '#': {
                if (str.length() == 4) {
                    return new Color(StyledLabelBuilder.getShorthandValue(str.charAt(1)), StyledLabelBuilder.getShorthandValue(str.charAt(2)), StyledLabelBuilder.getShorthandValue(str.charAt(3)));
                }
                return new Color(Integer.parseInt(str.substring(1), 16));
            }
            case '0': {
                return new Color(Integer.parseInt(str.substring(2), 16));
            }
        }
        return (Color)colorNamesMap.get(str);
    }

    private static int nextColorInt(String str, int index) {
        char c;
        int colorLength;
        char c2;
        while (index < str.length() && ('0' > (c2 = str.charAt(index)) || c2 > '9')) {
            ++index;
        }
        for (colorLength = index; colorLength < index + 3 && (c = str.charAt(colorLength)) >= '0' && '9' >= c; ++colorLength) {
        }
        return Integer.parseInt(str.substring(index, colorLength));
    }

    private static int getShorthandValue(char c) {
        if ('A' <= (c = Character.toUpperCase(c)) && c <= 'F') {
            return colorShorthandTable[c - 65 + 10];
        }
        return colorShorthandTable[c - 48];
    }

    public static Map getColorNamesMap() {
        return colorNamesMap;
    }

    private static String createTrimmedString(char[] text, int start, int end) {
        while ((text[start] == ' ' || text[start] == '\t') && start < text.length) {
            ++start;
        }
        while ((text[end] == ' ' || text[end] == '\t') && start < end) {
            --end;
        }
        if (end >= start) {
            StringBuffer buffer = new StringBuffer(end - start);
            boolean escaped = false;
            for (int i = start; i <= end; ++i) {
                if (text[i] == '\\' && !escaped) {
                    escaped = true;
                    continue;
                }
                buffer.append(text[i]);
                if (!escaped) continue;
                escaped = false;
            }
            return buffer.toString();
        }
        return "";
    }

    private static int findNextOf(char[] text, char[] chars, int start) {
        boolean escaped = false;
        for (int i = start; i < text.length; ++i) {
            if (escaped) {
                escaped = false;
                continue;
            }
            if (text[i] == '\\') {
                escaped = true;
                continue;
            }
            for (char c : chars) {
                if (text[i] != c) continue;
                return i;
            }
        }
        return -1;
    }

    private static int findNext(char[] text, char c, int start) {
        boolean escaped = false;
        for (int i = start; i < text.length; ++i) {
            if (escaped) {
                escaped = false;
                continue;
            }
            if (text[i] == '\\') {
                escaped = true;
                continue;
            }
            if (text[i] != c) continue;
            return i;
        }
        return -1;
    }

    static {
        colorNamesMap.put("white", new Color(0xFFFFFF));
        colorNamesMap.put("lightGray", new Color(0xC0C0C0));
        colorNamesMap.put("gray", new Color(0x808080));
        colorNamesMap.put("darkGray", new Color(0x404040));
        colorNamesMap.put("black", new Color(0));
        colorNamesMap.put("red", new Color(0xFF0000));
        colorNamesMap.put("pink", new Color(0xFFAFAF));
        colorNamesMap.put("orange", new Color(16762880));
        colorNamesMap.put("yellow", new Color(0xFFFF00));
        colorNamesMap.put("green", new Color(65280));
        colorNamesMap.put("magenta", new Color(0xFF00FF));
        colorNamesMap.put("cyan", new Color(65535));
        colorNamesMap.put("blue", new Color(255));
    }

    private static class ParsedStyleResult {
        String text;
        int endOffset;
        int fontStyle = 0;
        Color fontColor = null;
        Color lineColor = null;
        Color backgroundColor = null;
        int additionalStyle = 0;

        private ParsedStyleResult() {
        }
    }
}

