/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.ConfigException;
import com.caucho.config.gen.AbstractAspectFactory;
import com.caucho.config.gen.AspectBeanFactory;
import com.caucho.config.gen.AspectFactory;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.CandiUtil;
import com.caucho.config.gen.DefaultInterceptors;
import com.caucho.config.gen.InterceptorGenerator;
import com.caucho.config.inject.AnnotatedOverrideMap;
import com.caucho.config.inject.AnyLiteral;
import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import com.caucho.config.reflect.BaseType;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.decorator.Delegate;
import javax.ejb.Stateful;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InterceptionType;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.interceptor.AroundInvoke;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptor;
import javax.interceptor.InterceptorBinding;
import javax.interceptor.Interceptors;
import javax.interceptor.InvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class InterceptorFactory<X>
extends AbstractAspectFactory<X> {
    private static final L10N L = new L10N(InterceptorFactory.class);
    private InjectManager _manager;
    private boolean _isInterceptorOrDecorator;
    private HashMap<AnnotatedType<?>, ClassInterceptors> _interceptorMap = new HashMap();
    private ClassInterceptors _selfInterceptors;
    private HashMap<Class<?>, Annotation> _classInterceptorBindings;
    private HashSet<Class<?>> _decoratorClasses;
    private boolean _isExcludeClassInterceptors;
    private boolean _isExcludeDefaultInterceptors;
    private boolean _isPassivating;
    private boolean _isStateful;

    public InterceptorFactory(AspectBeanFactory<X> beanFactory, AspectFactory<X> next, InjectManager manager) {
        super(beanFactory, next);
        if (manager.isChildManager()) {
            manager = manager.getParent();
        }
        this._manager = manager;
        this.introspectType();
    }

    public HashMap<Class<?>, Annotation> getClassInterceptorBindings() {
        return this._classInterceptorBindings;
    }

    public HashSet<Class<?>> getDecoratorClasses() {
        return this._decoratorClasses;
    }

    public boolean isPassivating() {
        return this._isPassivating;
    }

    public boolean isStateful() {
        return this._isStateful || this.getBeanType().isAnnotationPresent(Stateful.class);
    }

    public boolean isSelfInterceptor() {
        return this._selfInterceptors.getSelfInterceptors() != null;
    }

    @Override
    public AspectGenerator<X> create(AnnotatedMethod<? super X> method, boolean isEnhanced) {
        if (this._isInterceptorOrDecorator) {
            return super.create(method, isEnhanced);
        }
        boolean isPrivate = Modifier.isPrivate(method.getJavaMember().getModifiers());
        boolean isLifecycle = method.isAnnotationPresent(PostConstruct.class);
        AnnotatedType beanType = this.getBeanType();
        boolean isExcludeClassInterceptors = false;
        if (method.isAnnotationPresent(ExcludeClassInterceptors.class) || beanType.isAnnotationPresent(ExcludeClassInterceptors.class)) {
            isExcludeClassInterceptors = true;
        }
        boolean isExcludeDefaultInterceptors = false;
        if (method.isAnnotationPresent(ExcludeDefaultInterceptors.class) || beanType.isAnnotationPresent(ExcludeDefaultInterceptors.class)) {
            isExcludeDefaultInterceptors = true;
        }
        HashSet<Class<?>> methodInterceptors = null;
        InterceptionType type = InterceptionType.AROUND_INVOKE;
        Class<AroundInvoke> annType = AroundInvoke.class;
        if (method.isAnnotationPresent(PostConstruct.class)) {
            type = InterceptionType.POST_CONSTRUCT;
            annType = PostConstruct.class;
        } else if (method.isAnnotationPresent(PreDestroy.class)) {
            type = InterceptionType.PRE_DESTROY;
            annType = PreDestroy.class;
        }
        ClassInterceptors typeInterceptors = this.getTypeInterceptors(beanType);
        if (!isExcludeDefaultInterceptors) {
            methodInterceptors = this.addInterceptors(methodInterceptors, typeInterceptors.getDefaultInterceptors(), annType);
        }
        if (!isExcludeClassInterceptors) {
            methodInterceptors = this.addInterceptors(methodInterceptors, typeInterceptors.getClassInterceptors(), annType);
        }
        Interceptors interceptorsAnn = (Interceptors)method.getAnnotation(Interceptors.class);
        boolean isMethodInterceptor = false;
        if (interceptorsAnn != null) {
            for (Class iClass : interceptorsAnn.value()) {
                if (!this.hasAroundInvoke(iClass)) continue;
                isMethodInterceptor = true;
                if (methodInterceptors == null) {
                    methodInterceptors = new LinkedHashSet();
                }
                methodInterceptors.add(iClass);
            }
        }
        methodInterceptors = this.addInterceptors(methodInterceptors, typeInterceptors.getSelfInterceptors(), annType);
        HashMap<Class<?>, Annotation> interceptorMap = null;
        interceptorMap = this.addInterceptorBindings(interceptorMap, method.getAnnotations());
        HashSet<Class<?>> decoratorSet = this.introspectDecorators(method);
        if ((method.isAnnotationPresent(Inject.class) || method.isAnnotationPresent(PostConstruct.class)) && (isMethodInterceptor || interceptorMap != null)) {
            throw new ConfigException(L.l("{0}.{1} is invalid because it's annotated with @Inject or @PostConstruct but also has interceptor bindings", (Object)method.getJavaMember().getDeclaringClass().getName(), (Object)method.getJavaMember().getName()));
        }
        if (method.isAnnotationPresent(Inject.class)) {
            return super.create(method, isEnhanced);
        }
        if (!isExcludeClassInterceptors && this._classInterceptorBindings != null) {
            if (interceptorMap != null) {
                interceptorMap.putAll(this._classInterceptorBindings);
            } else {
                interceptorMap = this._classInterceptorBindings;
            }
        }
        if (methodInterceptors != null || interceptorMap != null || decoratorSet != null) {
            AspectGenerator<? super X> next = super.create(method, true);
            return new InterceptorGenerator<X>(this, method, next, type, methodInterceptors, interceptorMap, decoratorSet, isExcludeClassInterceptors);
        }
        return super.create(method, isEnhanced);
    }

    private boolean hasAroundInvoke(Class<?> cl) {
        if (cl == null) {
            return false;
        }
        for (Method m : cl.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(AroundInvoke.class)) continue;
            return true;
        }
        return this.hasAroundInvoke(cl.getSuperclass());
    }

    @Override
    public void generateInject(JavaWriter out, HashMap<String, Object> map) throws IOException {
        super.generateInject(out, map);
        if (this._isInterceptorOrDecorator) {
            return;
        }
        if (this.isEnhanced()) {
            this.generateInject(out, map, InterceptionType.POST_CONSTRUCT, PostConstruct.class);
            this.generateInject(out, map, InterceptionType.AROUND_INVOKE, AroundInvoke.class);
            this.generateInject(out, map, InterceptionType.PRE_DESTROY, PreDestroy.class);
        }
    }

    private void generateInject(JavaWriter out, HashMap<String, Object> map, InterceptionType type, Class<? extends Annotation> annType) throws IOException {
        HashSet<Class<?>> interceptors = null;
        interceptors = this.addInterceptors(interceptors, this._selfInterceptors.getClassInterceptors(), annType);
        interceptors = this.addInterceptors(interceptors, this._selfInterceptors.getDefaultInterceptors(), annType);
        if ((interceptors = this.addInterceptors(interceptors, this._selfInterceptors.getSelfInterceptors(), annType)) != null) {
            InterceptorGenerator gen = new InterceptorGenerator(this, interceptors, type);
            gen.generateInject(out, map);
        }
    }

    @Override
    public void generatePostConstruct(JavaWriter out, HashMap<String, Object> map) throws IOException {
        if (!this._isInterceptorOrDecorator && this.isEnhanced()) {
            HashSet<Class<?>> set = null;
            set = this.addInterceptors(set, this._selfInterceptors.getClassInterceptors(), AroundInvoke.class);
            if ((set = this.addInterceptors(set, this._selfInterceptors.getDefaultInterceptors(), AroundInvoke.class)) != null) {
                InterceptorGenerator gen = new InterceptorGenerator(this, set, InterceptionType.AROUND_INVOKE);
                gen.generateClassPostConstruct(out, map);
                return;
            }
        }
        super.generatePostConstruct(out, map);
    }

    @Override
    public void generatePreDestroy(JavaWriter out, HashMap<String, Object> map) throws IOException {
        super.generatePreDestroy(out, map);
        if (this._isInterceptorOrDecorator) {
            return;
        }
        if (this.isEnhanced()) {
            HashSet<Class<?>> set = null;
            if ((set = this.addInterceptors(set, this._selfInterceptors.getClassInterceptors(), PreDestroy.class)) != null || this._classInterceptorBindings != null) {
                InterceptorGenerator gen = new InterceptorGenerator(this, set, InterceptionType.PRE_DESTROY);
                gen.generateClassPreDestroy(out, map);
            }
        }
    }

    @Override
    public void generateEpilogue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        super.generateEpilogue(out, map);
        if (this._isInterceptorOrDecorator) {
            return;
        }
        if (this.isEnhanced()) {
            this.generateEpilogue(out, map, InterceptionType.AROUND_INVOKE, AroundInvoke.class);
            this.generateEpilogue(out, map, InterceptionType.PRE_DESTROY, PreDestroy.class);
        }
    }

    private void generateEpilogue(JavaWriter out, HashMap<String, Object> map, InterceptionType type, Class<? extends Annotation> annType) throws IOException {
        HashSet interceptors = new LinkedHashSet();
        interceptors = this.addInterceptors(interceptors, this._selfInterceptors.getClassInterceptors(), annType);
        interceptors = this.addInterceptors(interceptors, this._selfInterceptors.getDefaultInterceptors(), annType);
        interceptors = this.addInterceptors(interceptors, this._selfInterceptors.getSelfInterceptors(), annType);
        InterceptorGenerator gen = new InterceptorGenerator(this, interceptors, type);
        gen.generateEpilogue(out, map);
    }

    @Override
    public boolean isEnhanced() {
        if (this._isInterceptorOrDecorator) {
            return false;
        }
        if (this._selfInterceptors.getClassInterceptors() != null) {
            return true;
        }
        if (this._selfInterceptors.getSelfInterceptors() != null) {
            return true;
        }
        if (this._classInterceptorBindings != null) {
            return true;
        }
        return super.isEnhanced();
    }

    private boolean isInterceptorPresentRec(Class<?> cl) {
        if (cl == null) {
            return false;
        }
        if (this.isInterceptorPresent(cl)) {
            return true;
        }
        return this.isInterceptorPresentRec(cl.getSuperclass());
    }

    private boolean isInterceptorPresent(Class<?> cl) {
        for (Method m : cl.getDeclaredMethods()) {
            Class<?>[] param = m.getParameterTypes();
            if (param.length != 1 || !param[0].equals(InvocationContext.class)) continue;
            return true;
        }
        return false;
    }

    private HashSet<Class<?>> addInterceptors(HashSet<Class<?>> set, ArrayList<Class<?>> sourceList, Class<? extends Annotation> annType) {
        if (sourceList == null) {
            return set;
        }
        for (Class<?> cl : sourceList) {
            set = this.addInterceptor(set, cl, cl, annType);
        }
        return set;
    }

    private HashSet<Class<?>> addInterceptor(HashSet<Class<?>> set, Class<?> cl, Class<?> subClass, Class<? extends Annotation> annType) {
        if (subClass == null || subClass == Object.class) {
            return set;
        }
        for (Method m : subClass.getDeclaredMethods()) {
            Class<?>[] param;
            if (Modifier.isAbstract(m.getModifiers()) || (param = m.getParameterTypes()).length != 1 || !param[0].equals(InvocationContext.class) || !this.isAnnotationPresent(m, annType)) continue;
            if (set == null) {
                set = new LinkedHashSet();
            }
            set.add(cl);
            return set;
        }
        return this.addInterceptor(set, cl, subClass.getSuperclass(), annType);
    }

    private boolean isAnnotationPresent(Method m, Class<? extends Annotation> annType) {
        if (m.isAnnotationPresent(annType)) {
            return true;
        }
        AnnotatedMethod<?> annMethod = AnnotatedOverrideMap.getMethod(m);
        if (annMethod == null) {
            return false;
        }
        return annMethod.isAnnotationPresent(annType);
    }

    private void introspectType() {
        if (this.getBeanType().isAnnotationPresent(Interceptor.class) || this.getBeanType().isAnnotationPresent(javax.decorator.Decorator.class)) {
            this._isInterceptorOrDecorator = true;
            return;
        }
        for (AnnotatedField field : this.getBeanType().getFields()) {
            if (!field.isAnnotationPresent(Delegate.class)) continue;
            this._isInterceptorOrDecorator = true;
            return;
        }
        for (AnnotatedMethod method : this.getBeanType().getMethods()) {
            for (AnnotatedParameter param : method.getParameters()) {
                if (!param.isAnnotationPresent(Delegate.class)) continue;
                this._isInterceptorOrDecorator = true;
                return;
            }
        }
        for (Annotation ann : this.getBeanType().getAnnotations()) {
            if (this._manager.isPassivatingScope(ann.annotationType())) {
                this._isPassivating = true;
                continue;
            }
            if (!Stateful.class.equals(ann.annotationType())) continue;
            this._isStateful = true;
        }
        this._selfInterceptors = this.getTypeInterceptors(this.getBeanType());
        this.introspectClassInterceptorBindings();
        this.introspectClassDecorators();
        if (this.isPassivating()) {
            this.validatePassivating();
        }
    }

    private void validatePassivating() {
    }

    private ClassInterceptors getTypeInterceptors(AnnotatedType<?> beanType) {
        ClassInterceptors interceptors = this._interceptorMap.get(beanType);
        if (interceptors == null) {
            interceptors = this.introspectTypeInterceptors(beanType);
            this._interceptorMap.put(beanType, interceptors);
        }
        return interceptors;
    }

    private ClassInterceptors introspectTypeInterceptors(AnnotatedType<?> beanType) {
        ArrayList<Class<?>> selfInterceptors = this.introspectSelfInterceptors(beanType);
        ArrayList<Class<?>> classInterceptors = this.introspectClassInterceptors(beanType);
        ArrayList<Class<?>> defaultInterceptors = this.introspectDefaultInterceptors(beanType);
        ClassInterceptors interceptors = new ClassInterceptors(classInterceptors, defaultInterceptors, selfInterceptors);
        return interceptors;
    }

    private ArrayList<Class<?>> introspectClassInterceptors(AnnotatedType<?> beanType) {
        if (beanType == null) {
            return null;
        }
        ArrayList<Class> classInterceptors = null;
        if (beanType.isAnnotationPresent(ExcludeClassInterceptors.class)) {
            return classInterceptors;
        }
        Interceptors interceptors = (Interceptors)beanType.getAnnotation(Interceptors.class);
        if (interceptors != null) {
            classInterceptors = new ArrayList<Class>();
            for (Class iClass : interceptors.value()) {
                if (classInterceptors.contains(iClass)) continue;
                classInterceptors.add(iClass);
            }
        }
        return classInterceptors;
    }

    private ArrayList<Class<?>> introspectSelfInterceptors(AnnotatedType<?> beanType) {
        ArrayList<Class> selfInterceptors = null;
        if (this.isInterceptorPresentRec(beanType.getJavaClass())) {
            selfInterceptors = new ArrayList<Class>();
            selfInterceptors.add(beanType.getJavaClass());
        }
        return selfInterceptors;
    }

    private ArrayList<Class<?>> introspectDefaultInterceptors(AnnotatedType<?> beanType) {
        ArrayList defaultInterceptors = null;
        if (beanType.isAnnotationPresent(ExcludeDefaultInterceptors.class)) {
            return defaultInterceptors;
        }
        DefaultInterceptors interceptors = (DefaultInterceptors)beanType.getAnnotation(DefaultInterceptors.class);
        if (interceptors != null) {
            defaultInterceptors = new ArrayList();
            for (Class<?> iClass : interceptors.value()) {
                if (defaultInterceptors.contains(iClass)) continue;
                defaultInterceptors.add(iClass);
            }
        }
        return defaultInterceptors;
    }

    private void introspectClassInterceptors(ArrayList<Class<?>> list, Class<?> iClass) {
        if (this.isInterceptorPresent(iClass) && !list.contains(iClass)) {
            list.add(iClass);
        }
    }

    private void introspectClassInterceptorBindings() {
        this._classInterceptorBindings = this.addInterceptorBindings(null, this.getBeanType().getAnnotations());
    }

    private void introspectClassDecorators() {
        BaseType type;
        Annotation[] decoratorBindings;
        Set types = this.getBeanType().getTypeClosure();
        HashSet<Annotation> decoratorBindingSet = new HashSet<Annotation>();
        boolean isQualifier = false;
        for (Annotation ann : this.getBeanType().getAnnotations()) {
            if (!ann.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            decoratorBindingSet.add(ann);
            if (Named.class.equals(ann.annotationType())) continue;
            isQualifier = true;
        }
        if (!isQualifier) {
            decoratorBindingSet.add((Annotation)DefaultLiteral.DEFAULT);
        }
        decoratorBindingSet.add((Annotation)AnyLiteral.ANY);
        if (decoratorBindingSet != null) {
            decoratorBindings = new Annotation[decoratorBindingSet.size()];
            decoratorBindingSet.toArray(decoratorBindings);
        } else {
            decoratorBindings = new Annotation[]{};
        }
        List<Decorator<?>> decorators = this._manager.resolveDecorators(types, decoratorBindings);
        if (decorators.size() == 0) {
            return;
        }
        if (this.isPassivating() || this.isStateful()) {
            CandiUtil.validatePassivatingDecorators(this.getBeanType().getJavaClass(), decorators);
        }
        HashSet<Type> closure = new HashSet<Type>();
        for (Decorator<?> decorator : decorators) {
            type = this._manager.createTargetBaseType(decorator.getDelegateType());
            closure.addAll(type.getTypeClosure(this._manager));
        }
        this._decoratorClasses = new HashSet();
        for (Type genericType : closure) {
            type = this._manager.createTargetBaseType(genericType);
            Class<?> rawClass = type.getRawClass();
            if (Object.class.equals(rawClass)) continue;
            this._decoratorClasses.add(rawClass);
        }
    }

    private HashSet<Class<?>> introspectDecorators(AnnotatedMethod<? super X> annMethod) {
        if (annMethod.getJavaMember().getDeclaringClass().equals(Object.class)) {
            return null;
        }
        if (this._decoratorClasses == null) {
            return null;
        }
        HashSet decoratorSet = null;
        for (Class<?> decoratorClass : this._decoratorClasses) {
            for (Method method : decoratorClass.getMethods()) {
                if (!AnnotatedTypeUtil.isMatch(method, annMethod.getJavaMember())) continue;
                if (decoratorSet == null) {
                    decoratorSet = new HashSet();
                }
                decoratorSet.add(decoratorClass);
            }
        }
        return decoratorSet;
    }

    private HashMap<Class<?>, Annotation> addInterceptorBindings(HashMap<Class<?>, Annotation> interceptorMap, Set<Annotation> annotations) {
        for (Annotation ann : annotations) {
            interceptorMap = this.addInterceptorBindings(interceptorMap, ann);
        }
        return interceptorMap;
    }

    private HashMap<Class<?>, Annotation> addInterceptorBindings(HashMap<Class<?>, Annotation> interceptorMap, Annotation ann) {
        Class<? extends Annotation> annType = ann.annotationType();
        if (annType.isAnnotationPresent(InterceptorBinding.class)) {
            Annotation oldAnn;
            if (interceptorMap == null) {
                interceptorMap = new HashMap();
            }
            if ((oldAnn = interceptorMap.put(ann.annotationType(), ann)) != null && !((Object)oldAnn).equals(ann)) {
                throw new ConfigException(L.l("duplicate @InterceptorBindings {0} and {1} are not allowed, because Resin can't tell which one to use.", (Object)ann, (Object)oldAnn));
            }
        }
        if (annType.isAnnotationPresent(Stereotype.class)) {
            for (Annotation subAnn : annType.getAnnotations()) {
                interceptorMap = this.addInterceptorBindings(interceptorMap, subAnn);
            }
        }
        return interceptorMap;
    }

    public AnnotatedMethod<? super X> getAroundInvokeMethod() {
        return null;
    }

    public void generateThis(JavaWriter out) throws IOException {
        out.print("this");
    }

    public void generateBeanInfo(JavaWriter out) throws IOException {
        out.print("bean");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassInterceptors {
        private ArrayList<Class<?>> _classInterceptors = new ArrayList();
        private ArrayList<Class<?>> _defaultInterceptors = new ArrayList();
        private ArrayList<Class<?>> _selfInterceptors = new ArrayList();

        ClassInterceptors(ArrayList<Class<?>> classInterceptors, ArrayList<Class<?>> defaultInterceptors, ArrayList<Class<?>> selfInterceptors) {
            this._classInterceptors = classInterceptors;
            this._defaultInterceptors = defaultInterceptors;
            this._selfInterceptors = selfInterceptors;
        }

        public ArrayList<Class<?>> getClassInterceptors() {
            return this._classInterceptors;
        }

        public ArrayList<Class<?>> getDefaultInterceptors() {
            return this._defaultInterceptors;
        }

        public ArrayList<Class<?>> getSelfInterceptors() {
            return this._selfInterceptors;
        }
    }
}

