/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.inject.InjectManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractInjectionPoint
implements InjectionPoint {
    private Type _type;
    private Member _member;
    private Bean _bean;
    private Set<Annotation> _bindings;
    private Annotation[] _annotations;

    public AbstractInjectionPoint(InjectManager inject, Bean bean, Member member, Type type, Set<Annotation> bindings, Annotation[] annotations) {
        this._bean = bean;
        this._member = member;
        this._type = type;
        this._bindings = bindings;
        this._annotations = annotations;
    }

    public Annotated getAnnotated() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Set<Annotation> getQualifiers() {
        return this._bindings;
    }

    public Type getType() {
        return this._type;
    }

    public Bean<?> getBean() {
        return this._bean;
    }

    public Member getMember() {
        return this._member;
    }

    public Annotation[] getAnnotations() {
        return this._annotations;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation ann : this.getAnnotations()) {
            if (!ann.annotationType().equals(annotationType)) continue;
            return (T)ann;
        }
        return null;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annType) {
        for (Annotation ann : this.getAnnotations()) {
            if (!ann.annotationType().equals(annType)) continue;
            return true;
        }
        return false;
    }

    public boolean isDelegate() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._type + "," + this._bindings + "]";
    }
}

