/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.j2ee;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.j2ee.BeanNameLiteral;
import com.caucho.config.j2ee.EjbQualifierLiteral;
import com.caucho.config.j2ee.JavaeeInjectionHandler;
import com.caucho.config.j2ee.JndiValueGenerator;
import com.caucho.config.program.BeanValueGenerator;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.FieldGeneratorProgram;
import com.caucho.config.program.MethodGeneratorProgram;
import com.caucho.config.program.NullProgram;
import com.caucho.config.program.ValueGenerator;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.ejb.EJB;
import javax.ejb.EJBs;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbHandler
extends JavaeeInjectionHandler {
    private static final L10N L = new L10N(EjbHandler.class);

    public EjbHandler(InjectManager manager) {
        super(manager);
    }

    @Override
    public ConfigProgram introspectField(AnnotatedField<?> field) {
        EJB ejb = (EJB)field.getAnnotation(EJB.class);
        return this.generateContext(field, ejb);
    }

    @Override
    public ConfigProgram introspectMethod(AnnotatedMethod<?> method) {
        EJB ejb = (EJB)method.getAnnotation(EJB.class);
        return this.generateContext(method, ejb);
    }

    @Override
    public ConfigProgram introspectType(AnnotatedType<?> type) {
        EJB ejb;
        for (Class parentClass = type.getJavaClass().getSuperclass(); parentClass != null; parentClass = parentClass.getSuperclass()) {
            EJB ejb2;
            EJBs ejbs = parentClass.getAnnotation(EJBs.class);
            if (ejbs != null) {
                for (EJB ejb3 : ejbs.value()) {
                    this.introspectClass(this.getClass().getName(), ejb3);
                }
            }
            if ((ejb2 = parentClass.getAnnotation(EJB.class)) == null) continue;
            this.introspectClass(this.getClass().getName(), ejb2);
        }
        EJBs ejbs = (EJBs)type.getAnnotation(EJBs.class);
        if (ejbs != null) {
            for (EJB ejb4 : ejbs.value()) {
                this.introspectClass(this.getClass().getName(), ejb4);
            }
        }
        if ((ejb = (EJB)type.getAnnotation(EJB.class)) != null) {
            this.introspectClass(this.getClass().getName(), ejb);
        }
        return new NullProgram();
    }

    private void introspectClass(String location, EJB ejb) {
        String name = ejb.name();
        Class bindType = ejb.beanInterface();
        if ("".equals(name)) {
            throw new ConfigException(L.l("{0}: @EJB name() attribute is required for @EJB on a class.", (Object)location));
        }
        if (Object.class.equals((Object)bindType)) {
            throw new ConfigException(L.l("{0}: @EJB beanInterface() attribute is required for @EJB on a class.", (Object)location));
        }
        ValueGenerator gen = this.bindGenerator(location, ejb, bindType);
        if (name != null && !"".equals(name)) {
            this.bindJndi(name, gen, name);
        }
    }

    private ConfigProgram generateContext(AnnotatedField<?> field, EJB ejb) throws ConfigException {
        String name = ejb.name();
        Field javaField = field.getJavaMember();
        String location = this.getLocation(javaField);
        Class<?> bindType = javaField.getType();
        ValueGenerator gen = this.bindGenerator(location, ejb, bindType);
        if (name != null && !"".equals(name)) {
            this.bindJndi(name, gen, name);
        }
        this.bindJndi(javaField, gen);
        return new FieldGeneratorProgram(javaField, gen);
    }

    private ConfigProgram generateContext(AnnotatedMethod<?> method, EJB ejb) throws ConfigException {
        String name = ejb.name();
        Method javaMethod = method.getJavaMember();
        String location = this.getLocation(javaMethod);
        Class bindType = javaMethod.getParameterTypes()[0];
        if (!Object.class.equals((Object)ejb.beanInterface())) {
            bindType = ejb.beanInterface();
        }
        ValueGenerator gen = this.bindGenerator(location, ejb, bindType);
        if (name != null && !"".equals(name)) {
            this.bindJndi(name, gen, name);
        }
        this.bindJndi(javaMethod, gen);
        return new MethodGeneratorProgram(javaMethod, gen);
    }

    protected ValueGenerator bindGenerator(String location, EJB ejb, Class<?> bindType) {
        String name = ejb.name();
        String mappedName = ejb.mappedName();
        String beanName = ejb.beanName();
        String lookupName = ejb.lookup();
        if (!Object.class.equals((Object)ejb.beanInterface())) {
            bindType = ejb.beanInterface();
        }
        if (lookupName != null && !"".equals(lookupName)) {
            return new JndiValueGenerator(location, bindType, lookupName);
        }
        Bean<?> bean = null;
        bean = !"".equals(beanName) ? this.bind(location, bindType, new BeanNameLiteral(beanName)) : this.bind(location, bindType, EjbQualifierLiteral.QUALIFIER);
        if (bean == null) {
            bean = this.bind(location, bindType, name, new Annotation[0]);
        }
        if (bean == null) {
            bean = this.bind(location, bindType, mappedName, new Annotation[0]);
        }
        if (bean == null) {
            if (!"".equals(name)) {
                throw new ConfigException(location + L.l("name='{0}' is an unknown @EJB.", (Object)name));
            }
            if (!"".equals(mappedName)) {
                throw new ConfigException(location + L.l("mappedName='{0}' is an unknown @EJB.", (Object)mappedName));
            }
            throw new ConfigException(location + L.l("@EJB cannot find any defined EJBs.  No @EJB with type='{0}'", (Object)bindType));
        }
        return new BeanValueGenerator(location, bean);
    }
}

