/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.program;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.InlineBeanType;
import com.caucho.config.type.TypeFactory;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import javax.enterprise.context.spi.CreationalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyStringProgram
extends ConfigProgram {
    private static final L10N L = new L10N(PropertyStringProgram.class);
    private final String _name;
    private final QName _qName;
    private final String _value;
    private final boolean _isOptional;

    public PropertyStringProgram(String name, String value) {
        this(name, value, false);
    }

    public PropertyStringProgram(String name, String value, boolean isOptional) {
        this._name = name;
        this._qName = new QName(name);
        this._value = value;
        this._isOptional = isOptional;
    }

    public PropertyStringProgram(QName qName, String value) {
        this._name = qName.getLocalName();
        this._qName = qName;
        this._value = value;
        this._isOptional = false;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public <T> void inject(T bean, CreationalContext<T> env) {
        try {
            ConfigType<?> type = TypeFactory.getType(bean.getClass());
            Attribute attr = type.getAttribute(this._qName);
            if (attr != null) {
                attr.setValue(bean, this._qName, attr.getConfigType().valueOf(this._value));
            } else if (!(this._qName.equals(InlineBeanType.TEXT) && "".equals(this._value.trim()) || this._isOptional)) {
                throw new ConfigException(L.l("'{0}' is an unknown property of '{1}'", (Object)this._qName, (Object)bean.getClass().getName()));
            }
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    @Override
    public <T> T create(ConfigType<T> type, CreationalContext<T> env) throws ConfigException {
        return (T)type.valueOf(this._value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._qName + "," + this._value + "]";
    }
}

