/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.inject.Module;
import com.caucho.naming.ObjectProxy;
import java.lang.reflect.Type;
import java.util.Hashtable;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class BeanJndiProxy
implements ObjectProxy {
    private BeanManager _manager;
    private Bean<?> _bean;

    public BeanJndiProxy(BeanManager manager, Bean<?> bean) {
        if (manager == null) {
            throw new NullPointerException();
        }
        if (bean == null) {
            throw new NullPointerException();
        }
        this._manager = manager;
        this._bean = bean;
    }

    public Object createObject(Hashtable env) throws NamingException {
        CreationalContext cxt = this._manager.createCreationalContext(this._bean);
        Class type = this._bean.getBeanClass();
        return this._manager.getReference(this._bean, (Type)type, cxt);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._bean + "]";
    }
}

