/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.config.cfg.BeanConfig;
import com.caucho.config.inject.InjectManager;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.spi.Bean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceConfig
extends BeanConfig {
    private static final L10N L = new L10N(InterfaceConfig.class);
    private boolean _isDeploy;
    private boolean _isFactory = true;
    private String _tagName = "bean";
    private String _valueName;
    private Object _value;

    public InterfaceConfig() {
    }

    public InterfaceConfig(Class<?> type) {
        this();
        this.setBeanConfigClass(type);
    }

    public InterfaceConfig(Class<?> type, String tagName) {
        this(type);
        this.setTagName(tagName);
    }

    @Override
    protected String getDefaultScope() {
        return null;
    }

    @Override
    public void setType(Class<?> cl) {
        this.setClass(cl);
    }

    @Override
    public void setClass(Class<?> cl) {
        super.setClass(cl);
        if (!this.getBeanConfigClass().isAssignableFrom(cl)) {
            throw new ConfigException(L.l("instance class '{0}' must implement '{1}'", (Object)cl.getName(), (Object)this.getBeanConfigClass().getName()));
        }
    }

    public void setDeploy(boolean isDeploy) {
        this._isDeploy = isDeploy;
        if (this._isDeploy) {
            this.setScope("singleton");
        }
    }

    public void setFactory(boolean isFactory) {
        this._isFactory = isFactory;
    }

    public void setTagName(String tagName) {
        this._tagName = tagName;
    }

    @Override
    public String getTagName() {
        return this._tagName;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.setDeploy(true);
    }

    @Override
    public void setJndiName(String name) {
        super.setJndiName(name);
        this.setDeploy(true);
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this._valueName = (String)value;
        } else {
            this._value = value;
        }
    }

    @Override
    @PostConstruct
    public void init() {
        if (this._valueName != null) {
            InjectManager webBeans = InjectManager.create();
            Set<Bean<?>> beans = webBeans.getBeans(this._valueName);
            if (beans.size() > 0) {
                this._bean = beans.iterator().next();
            }
            if (this._bean == null) {
                this._value = Jndi.lookup(this._valueName);
            }
            if (this._bean == null && this._value == null) {
                throw new ConfigException(L.l("'{0}' is an unknown bean", (Object)this._valueName));
            }
        } else if (this.getClassType() != null) {
            super.init();
        }
    }

    @Override
    public void deploy() {
        if (this._isDeploy) {
            super.deploy();
        }
    }

    @Override
    public Object getObject() {
        if (this._value != null) {
            return this._value;
        }
        if (this.getClassType() != null) {
            return super.getObject();
        }
        if (this.getBeanConfigClass().isAssignableFrom(String.class)) {
            return this._valueName;
        }
        return null;
    }

    public Object getObjectNoInit() {
        if (this._value != null) {
            return this._value;
        }
        if (this.getClassType() != null) {
            return super.createObjectNoInit();
        }
        if (this.getBeanConfigClass().isAssignableFrom(String.class)) {
            return this._valueName;
        }
        return null;
    }

    public Object replaceObject() {
        if (this._isFactory) {
            return this.getObject();
        }
        return this;
    }

    public Object replaceObjectNoInit() {
        if (this._isFactory) {
            return this.getObjectNoInit();
        }
        return this;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getBeanConfigClass().getName() + "]";
    }
}

