/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.ELParseException;
import com.caucho.el.ELParser;
import com.caucho.el.EnvironmentContext;
import com.caucho.el.Expr;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.L10N;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EL {
    private static final Logger log = Logger.getLogger(EL.class.getName());
    private static final L10N L = new L10N(EL.class);
    private static EnvironmentLocal<ELContext> _elEnvironment = new EnvironmentLocal();
    private static EnvironmentLocal<HashMap<String, Object>> _envVar = new EnvironmentLocal();
    public static final Object NULL = new Object();

    public static ELContext getEnvironment() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return EL.getEnvironment(loader);
    }

    public static ELContext getEnvironment(ClassLoader loader) {
        ELContext context = _elEnvironment.getLevel(loader);
        if (context == null) {
            context = new EnvironmentContext(loader);
            _elEnvironment.set(context, loader);
        }
        return context;
    }

    public static void setEnvironment(ELContext env) {
        _elEnvironment.set(env);
    }

    public static void setEnvironment(ELContext env, ClassLoader loader) {
        _elEnvironment.set(env, loader);
    }

    public static void setVariableMap(HashMap<String, Object> map, ClassLoader loader) {
        _envVar.set(map, loader);
    }

    public static Object getLevelVar(String name, ClassLoader loader) {
        HashMap<String, Object> varMap = _envVar.getLevel(loader);
        if (varMap == null) {
            return null;
        }
        return varMap.get(name);
    }

    public static Object putVar(String name, Object value) {
        return EL.putVar(name, value, Thread.currentThread().getContextClassLoader());
    }

    public static Object putVar(String name, Object value, ClassLoader loader) {
        HashMap<String, Object> varMap = _envVar.getLevel(loader);
        if (varMap == null) {
            varMap = new HashMap();
            _envVar.set(varMap, loader);
        }
        return varMap.put(name, value);
    }

    public static Object evalObject(String value) throws ELParseException, ELException {
        ELParser parser = new ELParser(EL.getEnvironment(), value);
        Expr expr = parser.parse();
        return expr.getValue(EL.getEnvironment());
    }

    public static String evalString(String value, ELContext env) throws ELParseException, ELException {
        ELParser parser = new ELParser(EL.getEnvironment(), value);
        Expr expr = parser.parse();
        return expr.evalString(env);
    }

    public static boolean evalBoolean(String value, ELContext env) throws ELParseException, ELException {
        ELParser parser = new ELParser(EL.getEnvironment(), value);
        Expr expr = parser.parse();
        return expr.evalBoolean(env);
    }
}

