/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectValueExpression
extends ValueExpression {
    protected static final Logger log = Logger.getLogger(ObjectValueExpression.class.getName());
    protected static final L10N L = new L10N(Expr.class);
    private final Expr _expr;
    private final String _expressionString;
    private final Class _expectedType;

    public ObjectValueExpression(Expr expr, String expressionString, Class<?> expectedType) {
        this._expr = expr;
        this._expressionString = expressionString;
        this._expectedType = expectedType;
    }

    public ObjectValueExpression(Expr expr, String expressionString) {
        this._expr = expr;
        this._expressionString = expressionString;
        this._expectedType = Object.class;
    }

    public ObjectValueExpression(Expr expr) {
        this._expr = expr;
        this._expressionString = this._expr.toString();
        this._expectedType = Object.class;
    }

    public ObjectValueExpression() {
        this._expr = null;
        this._expressionString = null;
        this._expectedType = Object.class;
    }

    public boolean isLiteralText() {
        return this._expr.isLiteralText();
    }

    public String getExpressionString() {
        return this._expressionString;
    }

    public Class<?> getExpectedType() {
        return this._expectedType;
    }

    public Class<?> getType(ELContext context) throws PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException("context can't be null");
        }
        return this._expr.getType(context);
    }

    public Object getValue(ELContext context) throws PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException("context can't be null");
        }
        Object rawValue = this._expr.getValue(context);
        Object value = Expr.coerceToType(rawValue, this._expectedType);
        return value;
    }

    public boolean isReadOnly(ELContext context) throws PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException("context can't be null");
        }
        return this._expr.isReadOnly(context);
    }

    public void setValue(ELContext context, Object value) throws PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (context == null) {
            throw new NullPointerException("context can't be null");
        }
        this._expr.setValue(context, value);
    }

    public int hashCode() {
        return this._expr.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectValueExpression)) {
            return false;
        }
        ObjectValueExpression expr = (ObjectValueExpression)((Object)o);
        return this._expr.equals((Object)expr._expr);
    }

    public String toString() {
        return "ObjectValueExpression[" + this.getExpressionString() + "]";
    }
}

