/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.AbstractJavaCompiler;
import com.caucho.java.JavaCompileException;
import com.caucho.java.JavaCompilerUtil;
import com.caucho.java.JavacErrorParser;
import com.caucho.java.LineMap;
import com.caucho.loader.ClassLoaderContext;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.CharBuffer;
import com.caucho.util.FreeList;
import com.caucho.util.LruCache;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.MemoryStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalCompiler2
extends AbstractJavaCompiler {
    private static final Logger log = Logger.getLogger(InternalCompiler2.class.getName());
    private static final List<JavaFileObject> NULL_FILE_LIST = Collections.emptyList();
    private static final EnvironmentLocal<FileCache> _fileCacheLocal = new EnvironmentLocal();
    private static final FreeList<JavaFileManager> _freeSystemManager = new FreeList(4);

    public InternalCompiler2(JavaCompilerUtil compiler) {
        super(compiler);
    }

    @Override
    protected void compileInt(String[] path, LineMap lineMap) throws IOException, JavaCompileException {
        this.executeInt(path, lineMap);
    }

    protected Path getClassDir() {
        return this._compiler.getClassDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInt(String[] path, LineMap lineMap) throws JavaCompileException, IOException {
        MemoryStream tempStream = new MemoryStream();
        WriteStream error = new WriteStream(tempStream);
        try {
            String encoding;
            ArrayList<String> optionList = new ArrayList<String>();
            optionList.add("-d");
            optionList.add(this._compiler.getClassDirName());
            if (this._compiler.getEncoding() != null && (encoding = Encoding.getJavaName(this._compiler.getEncoding())) != null && !encoding.equals("ISO8859_1")) {
                optionList.add("-encoding");
                optionList.add(this._compiler.getEncoding());
            }
            optionList.add("-classpath");
            optionList.add(this._compiler.getClassPath());
            ArrayList<String> options = this._compiler.getArgs();
            if (options != null) {
                optionList.addAll(options);
            }
            Iterable<String> classes = null;
            ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
            for (int i = 0; i < path.length; ++i) {
                Path javaPath = this._compiler.getSourceDir().lookup(path[i]);
                files.add(this.createJavaFileObject(javaPath));
            }
            if (log.isLoggable(Level.FINER)) {
                this.logJavac(optionList);
            }
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                try {
                    JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
                    DiagnosticListenerImpl diagnosticListener = new DiagnosticListenerImpl();
                    JavaFileManager parentFileManager = this.buildFileManager(compiler, oldLoader, diagnosticListener);
                    CauchoFileManager fileManager = new CauchoFileManager(parentFileManager);
                    JavaCompiler.CompilationTask value = compiler.getTask(error.getPrintWriter(), fileManager, diagnosticListener, options, classes, files);
                    Boolean result = value.call();
                }
                catch (Exception e) {
                    throw new JavaCompileException(e);
                }
                error.close();
                tempStream.close();
                Object var18_21 = null;
                thread.setContextClassLoader(oldLoader);
            }
            catch (Throwable throwable) {
                Object var18_22 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
            boolean status = false;
            ReadStream read = tempStream.openReadAndSaveBuffer();
            JavacErrorParser parser = new JavacErrorParser(this, path[0], this._compiler.getEncoding());
            String errors = parser.parseErrors(read, lineMap);
            read.close();
            if (errors != null) {
                errors = errors.trim();
            }
            if (log.isLoggable(Level.FINE)) {
                int ch;
                read = tempStream.openReadAndSaveBuffer();
                CharBuffer cb = new CharBuffer();
                while ((ch = read.read()) >= 0) {
                    cb.append((char)ch);
                }
                read.close();
                log.fine(cb.toString());
            } else if (!status && errors != null && !errors.equals("")) {
                final String msg = errors;
                new ClassLoaderContext(this._compiler.getClassLoader()){

                    public void run() {
                        log.warning(msg);
                    }
                };
            }
            if (status) {
                throw new JavaCompileException(errors);
            }
            Object var20_24 = null;
            tempStream.destroy();
        }
        catch (Throwable throwable) {
            Object var20_25 = null;
            tempStream.destroy();
            throw throwable;
        }
    }

    private void logJavac(ArrayList<String> optionList) {
        CharBuffer msg = new CharBuffer();
        msg.append("javac(int)");
        for (int i = 0; i < optionList.size(); ++i) {
            if (optionList.get(i).equals("-classpath") && !log.isLoggable(Level.FINEST)) {
                ++i;
                continue;
            }
            msg.append(" ");
            msg.append(optionList.get(i));
        }
        log.finer(msg.toString());
    }

    private JavaFileObject createJavaFileObject(Path path) {
        return new PathFileObject(path, JavaFileObject.Kind.SOURCE);
    }

    private JavaFileManager buildFileManager(JavaCompiler compiler, ClassLoader loader, DiagnosticListener listener) {
        if (loader instanceof DynamicClassLoader) {
            JavaFileManager parent = this.buildFileManager(compiler, loader.getParent(), listener);
            return new EnvironmentFileManager(parent, (DynamicClassLoader)loader);
        }
        JavaFileManager standardFileManager = _freeSystemManager.allocate();
        if (standardFileManager == null) {
            standardFileManager = compiler.getStandardFileManager(listener, null, null);
        }
        return new CacheFileManager(standardFileManager, loader);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileCache {
        private final LruCache<ListKey, Iterable<JavaFileObject>> _listCache = new LruCache(1024);

        FileCache() {
        }

        Iterable<JavaFileObject> getList(ListKey key) {
            return this._listCache.get(key);
        }

        void putList(ListKey key, Iterable<JavaFileObject> list) {
            this._listCache.put(key, list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListKey {
        private final JavaFileManager.Location _location;
        private final String _packageName;
        private final Set<JavaFileObject.Kind> _kinds;
        private final boolean _recurse;

        ListKey(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) {
            this._location = location;
            this._packageName = packageName;
            this._kinds = kinds;
            this._recurse = recurse;
        }

        public int hashCode() {
            return this._packageName.hashCode() * 65521 + ((Object)this._kinds).hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ListKey key = (ListKey)o;
            return this._packageName.equals(key._packageName) && ((Object)this._kinds).equals(key._kinds) && this._location.equals(key._location) && this._recurse == key._recurse;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CacheFileManager
    extends DelegatingFileManager {
        private final FileCache _fileCache;

        CacheFileManager(JavaFileManager parent, ClassLoader loader) {
            super(parent);
            FileCache fileCache = (FileCache)_fileCacheLocal.getLevel(loader);
            if (fileCache == null) {
                fileCache = new FileCache();
                _fileCacheLocal.set(fileCache, loader);
            }
            this._fileCache = fileCache;
        }

        @Override
        public int isSupportedOption(String option) {
            return 0;
        }

        @Override
        public boolean handleOption(String current, Iterator<String> remaining) {
            return false;
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            ListKey key = new ListKey(location, packageName, kinds, recurse);
            Iterable<Object> result = this._fileCache.getList(key);
            if (result == null) {
                result = super.list(location, packageName, kinds, recurse);
                if (result == null) {
                    result = NULL_FILE_LIST;
                }
                this._fileCache.putList(key, result);
            }
            if (result == NULL_FILE_LIST) {
                return null;
            }
            return result;
        }

        @Override
        public void close() {
            JavaFileManager parent = this._parent;
            this._parent = null;
            if (parent != null) {
                _freeSystemManager.free(parent);
            }
        }
    }

    class EnvironmentFileManager
    extends DelegatingFileManager {
        private final DynamicClassLoader _loader;

        EnvironmentFileManager(JavaFileManager parent, DynamicClassLoader loader) {
            super(parent);
            this._loader = loader;
        }
    }

    class CauchoFileManager
    extends DelegatingFileManager {
        CauchoFileManager(JavaFileManager parent) {
            super(parent);
        }

        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            switch (kind) {
                case CLASS: {
                    String name = className.replace('.', '/') + ".class";
                    Path path = InternalCompiler2.this.getClassDir().lookup(name);
                    return new PathFileObject(path, kind);
                }
            }
            return super.getJavaFileForOutput(location, className, kind, sibling);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DelegatingFileManager
    implements JavaFileManager {
        protected JavaFileManager _parent;

        DelegatingFileManager(JavaFileManager parent) {
            this._parent = parent;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return this._parent.getClassLoader(location);
        }

        @Override
        public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
            FileObject result = this._parent.getFileForInput(location, packageName, relativeName);
            return result;
        }

        @Override
        public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
            FileObject result = this._parent.getFileForOutput(location, packageName, relativeName, sibling);
            return result;
        }

        @Override
        public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
            return this._parent.getJavaFileForInput(location, className, kind);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            JavaFileObject result = this._parent.getJavaFileForOutput(location, className, kind, sibling);
            return result;
        }

        @Override
        public int isSupportedOption(String option) {
            return this._parent.isSupportedOption(option);
        }

        @Override
        public boolean handleOption(String current, Iterator<String> remaining) {
            return this._parent.handleOption(current, remaining);
        }

        @Override
        public boolean hasLocation(JavaFileManager.Location location) {
            return this._parent.hasLocation(location);
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            return this._parent.inferBinaryName(location, file);
        }

        @Override
        public boolean isSameFile(FileObject a, FileObject b) {
            return this._parent.isSameFile(a, b);
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            Iterable<JavaFileObject> result = this._parent.list(location, packageName, kinds, recurse);
            return result;
        }

        @Override
        public void flush() throws IOException {
            this._parent.flush();
        }

        @Override
        public void close() throws IOException {
            this._parent.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiagnosticListenerImpl<S>
    implements DiagnosticListener<S> {
        DiagnosticListenerImpl() {
        }

        @Override
        public void report(Diagnostic<? extends S> diagnostic) {
            System.out.println("ERROR: " + diagnostic);
        }
    }

    static class PathFileObject
    extends SimpleJavaFileObject {
        private final Path _path;

        PathFileObject(Path path, JavaFileObject.Kind kind) {
            super(PathFileObject.createURI(path), kind);
            this._path = path;
        }

        private static URI createURI(Path path) {
            try {
                return new URI(path.getURL());
            }
            catch (Exception e) {
                throw new JavaCompileException(e);
            }
        }

        public String getName() {
            return this._path.getFullPath();
        }

        public long getLastModified() {
            return this._path.getLastModified();
        }

        public boolean delete() {
            try {
                return this._path.remove();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            StringBuilder sb = new StringBuilder();
            ReadStream is = this._path.openRead();
            try {
                int len;
                char[] buffer = new char[1024];
                while ((len = is.read(buffer, 0, buffer.length)) > 0) {
                    sb.append(buffer, 0, len);
                }
                StringBuilder stringBuilder = sb;
                Object var8_7 = null;
                is.close();
                return stringBuilder;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                is.close();
                throw throwable;
            }
        }

        public InputStream openInputStream() throws IOException {
            return this._path.openRead();
        }

        public OutputStream openOutputStream() throws IOException {
            this._path.getParent().mkdirs();
            return this._path.openWrite();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._path + "]";
        }
    }
}

