/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.module;

import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.module.Artifact;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactClassLoader
extends EnvironmentClassLoader {
    private Artifact _artifact;
    private ArtifactClassLoader[] _imports;

    ArtifactClassLoader(ClassLoader parent, Artifact artifact, ArrayList<ArtifactClassLoader> importList) {
        super(parent, ArtifactClassLoader.createId(artifact));
        this._artifact = artifact;
        this.addJar(artifact.getPath());
        this._imports = new ArtifactClassLoader[importList.size()];
        importList.toArray(this._imports);
        this.init();
    }

    private static String createId(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append("artifact:org=").append(artifact.getOrg());
        sb.append(",name=").append(artifact.getName());
        if (artifact.getVersion() != null) {
            sb.append(",version=").append(artifact.getVersion().toDebugString());
        }
        return sb.toString();
    }

    Artifact getArtifact() {
        return this._artifact;
    }

    protected Class findImportClass(String name) {
        for (ArtifactClassLoader loader : this._imports) {
            try {
                Class<?> cl = loader.findClassImpl(name);
                if (cl == null) continue;
                return cl;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected void buildClassPathImpl(ArrayList<String> cp) {
        String path = this._artifact.getPath().getNativePath();
        if (!cp.contains(path)) {
            cp.add(path);
        }
    }
}

