/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.classes;

import com.caucho.quercus.env.CompiledClassDef;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.ClassField;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyClassDef
extends CompiledClassDef {
    private final String _name;
    private final Class<?> _pageClass;
    private final String _className;
    private CompiledClassDef _def;

    public LazyClassDef(String name, Class<?> pageClass, String className) {
        super(name, null, null);
        this._name = name;
        this._pageClass = pageClass;
        this._className = className;
    }

    public CompiledClassDef toClassDef() {
        if (this._def != null) {
            return this._def;
        }
        return this;
    }

    @Override
    public ClassDef loadClassDef() {
        return this.getClassDef();
    }

    private CompiledClassDef getClassDef() {
        if (this._def != null) {
            return this._def;
        }
        try {
            ClassLoader loader = this._pageClass.getClassLoader();
            String className = this._pageClass.getName() + "$" + this._className;
            Class<?> cl = Class.forName(className, false, loader);
            this._def = (CompiledClassDef)cl.newInstance();
            return this._def;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return this.getClassDef().getName();
    }

    @Override
    public String getParentName() {
        return this.getClassDef().getParentName();
    }

    @Override
    public String getExtension() {
        return this.getClassDef().getExtension();
    }

    @Override
    public void init() {
        this.getClassDef().init();
    }

    @Override
    public String[] getInterfaces() {
        return this.getClassDef().getInterfaces();
    }

    @Override
    public String[] getTraits() {
        return this.getClassDef().getTraits();
    }

    @Override
    public boolean isAbstract() {
        return this.getClassDef().isAbstract();
    }

    @Override
    public boolean isInterface() {
        return this.getClassDef().isInterface();
    }

    @Override
    public boolean isFinal() {
        return this.getClassDef().isFinal();
    }

    @Override
    public String getComment() {
        return this.getClassDef().getComment();
    }

    @Override
    public String getFieldComment(StringValue name) {
        return this.getClassDef().getFieldComment(name);
    }

    @Override
    public String getStaticFieldComment(StringValue name) {
        return this.getClassDef().getStaticFieldComment(name);
    }

    @Override
    public boolean hasNonPublicMethods() {
        return this.getClassDef().hasNonPublicMethods();
    }

    @Override
    public void initClassMethods(QuercusClass cl, String bindingClassName) {
        this.getClassDef().initClassMethods(cl, bindingClassName);
    }

    @Override
    public void initClassFields(QuercusClass cl, String bindingClassName) {
        this.getClassDef().initClassFields(cl, bindingClassName);
    }

    @Override
    public ObjectValue createObject(Env env, QuercusClass cls) {
        return this.getClassDef().createObject(env, cls);
    }

    @Override
    public Value callNew(Env env, Value[] args) {
        return this.getClassDef().callNew(env, args);
    }

    @Override
    public void initInstance(Env env, Value value) {
        this.getClassDef().initInstance(env, value);
    }

    @Override
    public boolean isA(Env env, String name) {
        return this.getClassDef().isA(env, name);
    }

    @Override
    public AbstractFunction findConstructor() {
        return this.getClassDef().findConstructor();
    }

    @Override
    public Expr findConstant(String name) {
        return this.getClassDef().findConstant(name);
    }

    @Override
    public int findFieldIndex(String name) {
        return this.getClassDef().findFieldIndex(name);
    }

    @Override
    public ArrayList<String> getFieldNames() {
        return this.getClassDef().getFieldNames();
    }

    @Override
    public Set<Map.Entry<StringValue, ClassField>> fieldSet() {
        return this.getClassDef().fieldSet();
    }

    @Override
    public Set<Map.Entry<StringValue, AbstractFunction>> functionSet() {
        return this.getClassDef().functionSet();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + "[" + this._name + "]";
    }
}

