/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;

public class ArrayIsSetExpr
extends Expr {
    protected final Expr _expr;
    protected final Expr _index;

    public ArrayIsSetExpr(Location location, Expr expr, Expr index) {
        super(location);
        this._expr = expr;
        this._index = index;
    }

    public ArrayIsSetExpr(Expr expr, Expr index) {
        this._expr = expr;
        this._index = index;
    }

    public boolean isBoolean() {
        return true;
    }

    public Value eval(Env env) {
        return this.evalBoolean(env) ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public boolean evalBoolean(Env env) {
        Value index;
        Value array = this._expr.eval(env);
        return array.get(index = this._index.eval(env)) != UnsetValue.UNSET;
    }

    public String toString() {
        return "isset(" + this._expr + "[" + this._index + "])";
    }
}

