/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListHeadExpr
extends Expr {
    private static final L10N L = new L10N(ListHeadExpr.class);
    protected final Expr[] _varList;
    protected final Value[] _keyList;
    private String _varName;

    public ListHeadExpr(ArrayList<Expr> varList) {
        this._varList = new Expr[varList.size()];
        varList.toArray(this._varList);
        this._keyList = new Value[varList.size()];
        for (int i = 0; i < varList.size(); ++i) {
            this._keyList[i] = LongValue.create(i);
        }
    }

    public Expr[] getVarList() {
        return this._varList;
    }

    @Override
    public Value eval(Env env) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value evalAssignValue(Env env, Value value) {
        int len = this._varList.length;
        for (int i = 0; i < len; ++i) {
            if (this._varList[i] == null) continue;
            this._varList[i].evalAssignValue(env, value.get(this._keyList[i]).copy());
        }
        return value;
    }

    public Value evalAssignEachValue(Env env, Value value) {
        if (!value.isArray()) {
            env.warning(L.l("variable passed to each must reference an array, saw {0}", (Object)value.getType()));
            return NullValue.NULL;
        }
        ArrayValue array = value.toArrayValue(env);
        if (this._varList.length > 0 && this._varList[0] != null) {
            this._varList[0].evalAssignValue(env, array.key());
        }
        if (this._varList.length > 1 && this._varList[1] != null) {
            this._varList[1].evalAssignValue(env, array.current().copy());
        }
        return array.each();
    }

    public boolean evalEachBoolean(Env env, Value value) {
        if (!value.isArray()) {
            env.warning(L.l("variable passed to each must reference an array, saw {0}", (Object)value.getType()));
            return false;
        }
        ArrayValue array = value.toArrayValue(env);
        if (!array.hasCurrent()) {
            return false;
        }
        if (this._varList.length > 0 && this._varList[0] != null) {
            this._varList[0].evalAssignValue(env, array.key());
        }
        if (this._varList.length > 1 && this._varList[1] != null) {
            this._varList[1].evalAssignValue(env, array.current().copy());
        }
        array.next();
        return true;
    }
}

