/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.expr.ThisExpr;
import com.caucho.quercus.parser.QuercusParser;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThisFieldVarExpr
extends AbstractVarExpr {
    protected final ThisExpr _qThis;
    protected final Expr _nameExpr;

    public ThisFieldVarExpr(Location location, ThisExpr qThis, Expr nameExpr) {
        super(location);
        this._qThis = qThis;
        this._nameExpr = nameExpr;
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        return factory.createThisMethod(location, this._qThis, this._nameExpr, args);
    }

    @Override
    public Value evalArg(Env env, boolean isTop) {
        Value value = env.getThis();
        return value.getThisFieldArg(env, this._nameExpr.evalStringValue(env));
    }

    @Override
    public Var evalVar(Env env) {
        Value value = env.getThis();
        return value.getThisFieldVar(env, this._nameExpr.evalStringValue(env));
    }

    @Override
    public Value eval(Env env) {
        Value obj = env.getThis();
        return obj.getThisField(env, this._nameExpr.evalStringValue(env));
    }

    @Override
    public Value evalAssignValue(Env env, Value value) {
        Value obj = env.getThis();
        obj.putThisField(env, this._nameExpr.evalStringValue(env), value);
        return value;
    }

    @Override
    public Value evalAssignRef(Env env, Value value) {
        Value obj = env.getThis();
        obj.putThisField(env, this._nameExpr.evalStringValue(env), value);
        return value;
    }

    @Override
    public Value evalArrayAssign(Env env, Expr indexExpr, Expr valueExpr) {
        Value obj = env.getThis();
        StringValue name = this._nameExpr.evalStringValue(env);
        Value fieldVar = obj.getThisFieldArray(env, name);
        Value index = indexExpr.eval(env);
        Value value = valueExpr.evalCopy(env);
        return fieldVar.putThisFieldArray(env, obj, name, index, value);
    }

    @Override
    public Value evalArrayAssignRef(Env env, Expr indexExpr, Expr valueExpr) {
        Value obj = env.getThis();
        StringValue name = this._nameExpr.evalStringValue(env);
        Value fieldVar = obj.getThisFieldArray(env, name);
        Value index = indexExpr.eval(env);
        Value value = valueExpr.evalRef(env);
        return fieldVar.putThisFieldArray(env, obj, name, index, value);
    }

    @Override
    public Value evalArray(Env env) {
        Value obj = env.getThis();
        return obj.getThisFieldArray(env, this._nameExpr.evalStringValue(env));
    }

    @Override
    public Value evalObject(Env env) {
        Value obj = env.getThis();
        return obj.getThisFieldObject(env, this._nameExpr.evalStringValue(env));
    }

    @Override
    public void evalUnset(Env env) {
        Value obj = env.getThis();
        obj.unsetThisField(this._nameExpr.evalStringValue(env));
    }

    @Override
    public String toString() {
        return "$this->{" + this._nameExpr + "}";
    }
}

