/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitParentClassConstExpr
extends Expr {
    protected final String _traitName;
    protected final StringValue _name;

    public TraitParentClassConstExpr(Location location, String traitName, StringValue name) {
        super(location);
        this._traitName = traitName;
        this._name = name;
    }

    public TraitParentClassConstExpr(String traitName, StringValue name) {
        this._traitName = traitName;
        this._name = name;
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        return factory.createTraitParentClassMethodCall(location, this._traitName, this._name, args);
    }

    @Override
    public Value eval(Env env) {
        Value qThis = env.getThis();
        QuercusClass parent = qThis.getQuercusClass().getTraitParent(env, this._traitName);
        return parent.getConstant(env, this._name);
    }

    @Override
    public String toString() {
        return "parent::" + this._name;
    }
}

