/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.annotation.Name;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReadOnly;
import com.caucho.quercus.annotation.UsesSymbolTable;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectExtValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.lib.ErrorModule;
import com.caucho.quercus.lib.HtmlModule;
import com.caucho.quercus.lib.VariableModule;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(OptionsModule.class);
    private static final Logger log = Logger.getLogger(OptionsModule.class.getName());
    public static final String PHP_OS = System.getProperty("os.name").toUpperCase(Locale.ENGLISH);
    public static final String PHP_EOL = System.getProperty("line.separator");
    public static final int ASSERT_ACTIVE = 1;
    public static final int ASSERT_CALLBACK = 2;
    public static final int ASSERT_BAIL = 3;
    public static final int ASSERT_WARNING = 4;
    public static final int ASSERT_QUIET_EVAL = 5;
    public static final int CREDITS_GROUP = 1;
    public static final int CREDITS_GENERAL = 2;
    public static final int CREDITS_SAPI = 4;
    public static final int CREDITS_MODULES = 8;
    public static final int CREDITS_DOCS = 16;
    public static final int CREDITS_FULLPAGE = 32;
    public static final int CREDITS_QA = 64;
    public static final int CREDITS_ALL = -1;
    public static final int INFO_GENERAL = 1;
    public static final int INFO_CREDITS = 2;
    public static final int INFO_CONFIGURATION = 4;
    public static final int INFO_MODULES = 8;
    public static final int INFO_ENVIRONMENT = 16;
    public static final int INFO_VARIABLES = 32;
    public static final int INFO_LICENSE = 64;
    public static final int INFO_ALL = -1;
    private static final IniDefinitions _iniDefinitions = new IniDefinitions();
    static final IniDefinition INI_ASSERT_ACTIVE = _iniDefinitions.add("assert.active", true, 7);
    static final IniDefinition INI_ASSERT_BAIL = _iniDefinitions.add("assert.bail", false, 7);
    static final IniDefinition INI_ASSERT_WARNING = _iniDefinitions.add("assert.warning", true, 7);
    static final IniDefinition INI_ASSERT_CALLBACK = _iniDefinitions.add("assert.callback", null, 7);
    static final IniDefinition INI_ASSERT_QUIET_EVAL = _iniDefinitions.add("assert.quiet_eval", false, 7);
    static final IniDefinition INI_ENABLE_DL = _iniDefinitions.add("enable_dl", true, 4);
    static final IniDefinition INI_MAX_EXECUTION_TIME = _iniDefinitions.add("max_execution_time", "600", 7);
    static final IniDefinition INI_MAX_INPUT_TIME = _iniDefinitions.add("max_input_time", "-1", 2);
    static final IniDefinition INI_MAGIC_QUOTES_GPC = _iniDefinitions.add("magic_quotes_gpc", false, 2);
    static final IniDefinition INI_TRACK_VARS = _iniDefinitions.add("track_vars", "On", 7);
    static final IniDefinition INI_ARG_SEPARATOR_OUTPUT = _iniDefinitions.add("arg_separator.output", "&", 7);
    static final IniDefinition INI_ARG_SEPARATOR_INPUT = _iniDefinitions.add("arg_separator.input", "&", 7);
    static final IniDefinition INI_VARIABLES_ORDER = _iniDefinitions.add("variables_order", "EGPCS", 7);
    static final IniDefinition INI_AUTO_GLOBALS_JIT = _iniDefinitions.add("auto_globals_jit", "1", 7);
    static final IniDefinition INI_REGISTER_ARGC_ARGV = _iniDefinitions.add("register_argc_argv", false, 7);
    static final IniDefinition INI_POST_MAX_SIZE = _iniDefinitions.add("post_max_size", "8M", 7);
    static final IniDefinition INI_GPC_ORDER = _iniDefinitions.add("gpc_order", "GPC", 7);
    static final IniDefinition INI_AUTO_PREPEND_FILE = _iniDefinitions.add("auto_prepend_file", null, 7);
    static final IniDefinition INI_AUTO_APPEND_FILE = _iniDefinitions.add("auto_append_file", null, 7);
    static final IniDefinition INI_DEFAULT_MIMETYPE = _iniDefinitions.add("default_mimetype", "text/html", 7);
    static final IniDefinition INI_DEFAULT_CHARSET = _iniDefinitions.add("default_charset", "", 7);
    static final IniDefinition INI_ALWAYS_POPULATE_RAW_POST_DATA = _iniDefinitions.add("always_populate_raw_post_data", false, 7);
    static final IniDefinition INI_ALLOW_WEBDAV_METHODS = _iniDefinitions.add("allow_webdav_methods", false, 7);
    static final IniDefinition INI_MEMORY_LIMIT = _iniDefinitions.add("memory_limit", "512M", 7);
    static final IniDefinition INI_SHORT_OPEN_TAG = _iniDefinitions.add("short_open_tag", true, 7);
    static final IniDefinition MAGIC_QUOTES_RUNTIME = _iniDefinitions.addUnsupported("magic_quotes_runtime", false, 7);
    static final IniDefinition MAGIC_QUOTES_SYBASE = _iniDefinitions.addUnsupported("magic_quotes_sybase", false, 7);
    static final IniDefinition INI_REGISTER_GLOBALS = _iniDefinitions.addUnsupported("register_globals", false, 7);

    @Override
    public IniDefinitions getIniDefinitions() {
        return _iniDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsesSymbolTable(replace=false)
    @Name(value="assert")
    public static Value q_assert(Env env, @ReadOnly Value value, @Optional Value message) {
        Value callback;
        boolean result;
        if (!OptionsModule.isAssertActive(env)) {
            return BooleanValue.TRUE;
        }
        if (value.isString()) {
            long errorReporting = 0L;
            if (OptionsModule.isAssertQuietEval(env)) {
                errorReporting = ErrorModule.error_reporting(env, LongValue.ZERO);
            }
            try {
                QuercusContext quercus = env.getQuercus();
                QuercusProgram program = quercus.parseCode(value.toStringValue(env));
                program = program.createExprReturn();
                Value v = program.execute(env);
                result = v != null && v.toBoolean();
            }
            catch (IOException e) {
                env.warning(e);
                result = false;
            }
            finally {
                if (OptionsModule.isAssertQuietEval(env)) {
                    ErrorModule.error_reporting(env, LongValue.create(errorReporting));
                }
            }
        } else {
            result = value.toBoolean();
        }
        if (result) {
            return BooleanValue.TRUE;
        }
        if (message.isDefault()) {
            message = value.toStringValue(env);
        }
        if (!(callback = OptionsModule.getAssertCallback(env)).isNull()) {
            Location location = env.getLocation();
            StringValue fileName = env.createString(location.getFileName());
            LongValue lineNumber = LongValue.create(location.getLineNumber());
            callback.call(env, fileName, lineNumber, message);
        }
        if (OptionsModule.isAssertWarn(env)) {
            env.warning(L.l("Assertion '{0}' failed", (Object)message));
        }
        if (OptionsModule.isAssertBail(env)) {
            env.die();
        }
        return NullValue.NULL;
    }

    private static boolean isAssertActive(Env env) {
        return INI_ASSERT_ACTIVE.getAsBoolean(env);
    }

    private static boolean isAssertWarn(Env env) {
        return INI_ASSERT_WARNING.getAsBoolean(env);
    }

    private static boolean isAssertBail(Env env) {
        return INI_ASSERT_BAIL.getAsBoolean(env);
    }

    private static boolean isAssertQuietEval(Env env) {
        return INI_ASSERT_QUIET_EVAL.getAsBoolean(env);
    }

    private static Value getAssertCallback(Env env) {
        return INI_ASSERT_CALLBACK.getValue(env);
    }

    public static Value assert_options(Env env, int code, @Optional(value="null") Value value) {
        Value result;
        switch (code) {
            case 1: {
                result = INI_ASSERT_ACTIVE.getAsLongValue(env);
                if (value.isNull()) break;
                INI_ASSERT_ACTIVE.set(env, value);
                break;
            }
            case 4: {
                result = INI_ASSERT_WARNING.getAsLongValue(env);
                if (value.isNull()) break;
                INI_ASSERT_WARNING.set(env, value);
                break;
            }
            case 3: {
                result = INI_ASSERT_BAIL.getAsLongValue(env);
                if (value.isNull()) break;
                INI_ASSERT_BAIL.set(env, value);
                break;
            }
            case 5: {
                result = INI_ASSERT_QUIET_EVAL.getAsLongValue(env);
                if (value.isNull()) break;
                INI_ASSERT_QUIET_EVAL.set(env, value);
                break;
            }
            case 2: {
                result = INI_ASSERT_CALLBACK.getValue(env);
                if (value.isNull()) break;
                INI_ASSERT_CALLBACK.set(env, value);
                break;
            }
            default: {
                env.warning(L.l("unknown value {0}", code));
                result = BooleanValue.FALSE;
            }
        }
        return result;
    }

    public static boolean dl(Env env, String dl) {
        env.stub("dl is stubbed for dl(" + dl + ")");
        return false;
    }

    public static boolean extension_loaded(Env env, String ext) {
        return env.isExtensionLoaded(ext);
    }

    public static Value get_cfg_var(Env env, String name) {
        Value value = env.getConfigVar(name);
        if (!value.isNull()) {
            return value;
        }
        return BooleanValue.FALSE;
    }

    public static String get_current_user(Env env) {
        env.stub("get_current_user");
        return String.valueOf(env.getSelfPath().getOwner());
    }

    public static Value get_defined_constants(Env env) {
        return env.getDefinedConstants();
    }

    public static Value get_extension_funcs(Env env, String name) {
        return env.getExtensionFuncs(name);
    }

    public static Value get_include_path(Env env) {
        return QuercusContext.INI_INCLUDE_PATH.getAsStringValue(env);
    }

    public static ArrayValue get_included_files(Env env) {
        return env.getIncludedFiles();
    }

    public static Value get_loaded_extensions(Env env) {
        ArrayValueImpl value = new ArrayValueImpl();
        for (String ext : env.getLoadedExtensions()) {
            value.put(ext);
        }
        return value;
    }

    public static LongValue get_magic_quotes_gpc(Env env) {
        return env.getIniBoolean("magic_quotes_gpc") ? LongValue.ONE : LongValue.ZERO;
    }

    public static Value get_magic_quotes_runtime(Env env) {
        return LongValue.ZERO;
    }

    public static ArrayValue get_required_files(Env env) {
        return OptionsModule.get_included_files(env);
    }

    public static Value getenv(Env env, StringValue key) {
        Var serverVars = env.getGlobalVar("_SERVER");
        Value val = ((Value)serverVars).get(key);
        if (val == null || !val.isset()) {
            return BooleanValue.FALSE;
        }
        return val;
    }

    public static Value getlastmod(Env env) {
        String path = env.getSelfPath().getNativePath();
        return FileModule.filemtime(env, env.createString(path));
    }

    public static Value getmygid(Env env) {
        return FileModule.filegroup(env, env.getSelfPath());
    }

    public static Value getmyinode(Env env) {
        return FileModule.fileinode(env, env.getSelfPath());
    }

    public static Value getmyuid(Env env) {
        String str = env.getSelfPath().getFullPath();
        return FileModule.fileowner(env, env.createString(str));
    }

    public static long getmypid(Env env) {
        return Thread.currentThread().getId();
    }

    public static Value getrusage(Env env, @Optional int who) {
        ArrayValueImpl value = new ArrayValueImpl();
        value.put(env.createString("ru_inblock"), LongValue.create(0L));
        value.put(env.createString("ru_outblock"), LongValue.create(0L));
        value.put(env.createString("ru_msgsnd"), LongValue.create(0L));
        value.put(env.createString("ru_msgrcv"), LongValue.create(0L));
        value.put(env.createString("ru_maxrss"), LongValue.create(0L));
        value.put(env.createString("ru_ixrss"), LongValue.create(0L));
        value.put(env.createString("ru_idrss"), LongValue.create(0L));
        value.put(env.createString("ru_minflt"), LongValue.create(0L));
        value.put(env.createString("ru_majflt"), LongValue.create(0L));
        value.put(env.createString("ru_nsignals"), LongValue.create(0L));
        value.put(env.createString("ru_nvcsw"), LongValue.create(0L));
        value.put(env.createString("ru_nswap"), LongValue.create(0L));
        value.put(env.createString("ru_utime.tv_sec"), LongValue.create(0L));
        value.put(env.createString("ru_utime.tv_usec"), LongValue.create(0L));
        value.put(env.createString("ru_stime.tv_sec"), LongValue.create(0L));
        value.put(env.createString("ru_stime.tv_usec"), LongValue.create(0L));
        return value;
    }

    public static Value ini_alter(Env env, String varName, StringValue value) {
        return OptionsModule.ini_set(env, varName, value);
    }

    public static StringValue ini_get(Env env, String varName) {
        StringValue v = env.getIni(varName);
        if (v != null) {
            return v;
        }
        return env.getEmptyString();
    }

    public static Value ini_get_all(Env env, @Optional String extension) {
        if (extension == null) {
            extension = "";
        } else if (extension.length() > 0) {
            if (!env.isExtensionLoaded(extension)) {
                env.warning(L.l("extension '" + extension + "' not loaded."));
                return BooleanValue.FALSE;
            }
            extension = extension + ".";
        }
        return OptionsModule.getAllDirectives(env, extension);
    }

    private static Value getAllDirectives(Env env, String prefix) {
        ArrayValueImpl directives = new ArrayValueImpl();
        StringValue global = env.createString("global_value");
        StringValue local = env.createString("local_value");
        StringValue access = env.createString("access");
        IniDefinitions iniDefinitions = env.getQuercus().getIniDefinitions();
        TreeSet<String> names = new TreeSet<String>();
        names.addAll(iniDefinitions.getNames());
        for (String name : names) {
            IniDefinition iniDefinition;
            if (!name.startsWith(prefix) || (iniDefinition = iniDefinitions.get(name)).isRuntimeDefinition()) continue;
            ArrayValueImpl inner = new ArrayValueImpl();
            inner.put(global, iniDefinition.getAsStringValue(env.getQuercus()));
            inner.put(local, iniDefinition.getAsStringValue(env));
            inner.put(access, LongValue.create(iniDefinition.getScope()));
            directives.put(env.createString(name), inner);
        }
        return directives;
    }

    public static Value ini_restore(Env env, String name) {
        Value value = env.getConfigVar(name);
        if (value != null) {
            env.setIni(name, value.toStringValue());
        }
        return NullValue.NULL;
    }

    public static StringValue ini_set(Env env, String varName, StringValue value) {
        StringValue oldValue = env.setIni(varName, value);
        if (oldValue != null) {
            return oldValue;
        }
        return StringValue.EMPTY;
    }

    public static Value magic_quotes_runtime(Env env) {
        return BooleanValue.FALSE;
    }

    public static Value memory_get_peak_usage(Env env, @Optional boolean real) {
        return LongValue.create(Runtime.getRuntime().maxMemory());
    }

    public static Value memory_get_usage(Env env, @Optional boolean real) {
        return LongValue.create(Runtime.getRuntime().maxMemory());
    }

    public static Value php_ini_loaded_file(Env env) {
        Path path = env.getQuercus().getIniFile();
        if (path != null) {
            return env.createString(path.toString());
        }
        return BooleanValue.FALSE;
    }

    public static Value php_ini_scanned_files(Env env) {
        return BooleanValue.FALSE;
    }

    public static String php_sapi_name(Env env) {
        String name = env.getIniString("quercus.sapi_name");
        if (name != null && name.length() > 0) {
            return name;
        }
        return env.getQuercus().getSapiName();
    }

    public static String php_uname(@Optional(value="'a'") String mode) {
        if (mode == null || mode.equals("")) {
            mode = "a";
        }
        switch (mode.charAt(0)) {
            case 's': {
                return System.getProperty("os.name");
            }
            case 'n': {
                try {
                    InetAddress addr = InetAddress.getLocalHost();
                    return addr.getHostName();
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                    return "localhost";
                }
            }
            case 'r': {
                return "2.4.0";
            }
            case 'v': {
                return "Version 2.6.24";
            }
            case 'm': {
                return "i686";
            }
        }
        return OptionsModule.php_uname("s") + " " + OptionsModule.php_uname("n") + " " + OptionsModule.php_uname("r") + " " + OptionsModule.php_uname("v") + " " + OptionsModule.php_uname("m");
    }

    public static void phpinfo(Env env, @Optional(value="INFO_ALL") int what) {
        if (OptionsModule.hasRequest(env)) {
            String quercusName = env.getQuercus().getName();
            String css = OptionsModule.getPhpinfoCss();
            env.println("<!DOCTYPE html>\n<html><head><title>" + quercusName + "</title>");
            env.println("<style type=\"text/css\">");
            env.println(css);
            env.println();
            env.println("</style>");
            env.println("</head><body>");
        }
        if ((what & 1) != 0) {
            OptionsModule.phpinfoGeneral(env);
        }
        if ((what & 0x20) != 0) {
            OptionsModule.phpinfoVariables(env);
        }
        if (OptionsModule.hasRequest(env)) {
            env.println("</body></html>");
        }
    }

    private static String getPhpinfoCss() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = loader.getResourceAsStream("phpinfo/style.css");
        try {
            if (is != null) {
                int ch;
                StringBuilder sb = new StringBuilder();
                while ((ch = is.read()) >= 0) {
                    sb.append((char)ch);
                }
                return sb.toString();
            }
        }
        catch (IOException e) {
            IoUtil.close(is);
        }
        return "body {background-color: #ffffff; color: #000000; text-align: center;}\nbody, th, h1, h2 {font-family: sans-serif;}\npre {margin: 0px; font-family: monospace;}\na:link {color: #4C2004; text-decoration: none; background-color: #ffffff;}\na:hover {color: #FFCC33; text-decoration: underline;}\ntable {border-collapse: collapse; width: 600px;}\n.center {text-align: center;}\ntable.center { margin-left: auto; margin-right: auto; text-align: left;}\nth .center { text-align: center !important; }\ntd, th { line-height: 110%; border-bottom: 1px solid #ccc; vertical-align: baseline; padding-bottom: 0.1em; padding-top: 0.6em; }\nh1, h2 { color: #990033; font-family: Helvetica,Arial,sans-serif; width: 600px; margin-left: auto; margin-right: auto;} \nh1 {font-size: 150%; border-bottom: 1px solid #FAB41D; }\nh2 {font-size: 125%;}\nimg {float: right; border: 0px;}\nhr {    background: none repeat scroll 0 0 #FAB41D; border: 0 none; height: 1px; margin: 0.2em 0;width: 600px; }";
    }

    private static void phpinfoGeneral(Env env) {
        String quercusName = env.getQuercus().getName();
        if (OptionsModule.hasRequest(env)) {
            env.println("<h1>" + quercusName + "</h1>");
        } else {
            env.println(quercusName);
        }
        if (OptionsModule.hasRequest(env)) {
            env.println("<pre>");
        }
        env.println("PHP Version => " + OptionsModule.phpversion(env, env.createString("std")));
        env.println("System => " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        env.println("Build Date => " + env.getQuercus().getVersionDate());
        env.println("Configure Command => n/a");
        env.println("Server API => CGI");
        env.println("Virtual Directory Support => disabled");
        env.println("Configuration File (php.ini) Path => " + env.getQuercus().getIniFile());
        env.println("PHP API => 20031224");
        env.println("PHP Extension => 20041030");
        env.println("Debug Build => no");
        env.println("Thread Safety => enabled");
        env.println("Registered PHP Streams => php, file, http, https");
        if (OptionsModule.hasRequest(env)) {
            env.print("</pre>");
        }
    }

    private static void phpinfoVariables(Env env) {
        if (OptionsModule.hasRequest(env)) {
            env.println("<h2>PHP Variables</h2>");
            env.println("<table class='center'>");
            env.println("<tr><th>Variable</th><th>Value</th></tr>");
        } else {
            env.println("Variable => Value");
        }
        if (OptionsModule.hasRequest(env)) {
            OptionsModule.phpinfoVariable(env, "_REQUEST", env.getGlobalVar("_REQUEST"));
            OptionsModule.phpinfoVariable(env, "_GET", env.getGlobalVar("_GET"));
            OptionsModule.phpinfoVariable(env, "_POST", env.getGlobalVar("_POST"));
            OptionsModule.phpinfoVariable(env, "_COOKIE", env.getGlobalVar("_COOKIE"));
            OptionsModule.phpinfoVariable(env, "_SESSION", env.getGlobalVar("_SESSION"));
        }
        OptionsModule.phpinfoVariable(env, "_ENV", env.getGlobalVar("_ENV"));
        OptionsModule.phpinfoVariable(env, "_SERVER", env.getGlobalVar("_SERVER"));
        if (OptionsModule.hasRequest(env)) {
            env.print("</table>");
        }
        env.println();
    }

    private static void phpinfoVariable(Env env, String name, Value value) {
        if (value.isArray()) {
            ArrayValue array = value.toArrayValue(env);
            for (Map.Entry<Value, Value> entry : array.entrySet()) {
                Value key = OptionsModule.escape(env, entry.getKey());
                if (OptionsModule.hasRequest(env)) {
                    env.print("<tr><td>");
                }
                env.print(name + "[\"" + key + "\"]");
                if (OptionsModule.hasRequest(env)) {
                    env.println("</td><td>");
                } else {
                    env.print(" => ");
                }
                OptionsModule.phpinfoVariable(env, entry.getValue());
                if (!OptionsModule.hasRequest(env)) continue;
                env.println("</td></tr>");
            }
        } else {
            if (OptionsModule.hasRequest(env)) {
                env.println("<tr><td>" + name + "</td><td>");
            }
            OptionsModule.phpinfoVariable(env, value);
            if (OptionsModule.hasRequest(env)) {
                env.println("</td></tr>");
            }
        }
    }

    private static void phpinfoVariable(Env env, Value value) {
        if (value.isString()) {
            env.println(OptionsModule.escape(env, value).toString());
        } else {
            if (OptionsModule.hasRequest(env)) {
                env.print("<pre>");
            }
            VariableModule.var_dump(env, OptionsModule.escape(env, value), null);
            if (OptionsModule.hasRequest(env)) {
                env.print("</pre>");
            }
        }
    }

    public static String phpversion(Env env, @Optional StringValue module) {
        return env.getQuercus().getPhpVersion();
    }

    public static boolean putenv(Env env, StringValue settings) {
        int eqIndex = settings.indexOf('=');
        if (eqIndex < 0) {
            return false;
        }
        StringValue key = settings.substring(0, eqIndex);
        StringValue val = settings.substring(eqIndex + 1);
        env.getGlobalVar("_SERVER").put(key, val);
        return true;
    }

    public static Value restore_include_path(Env env) {
        env.restoreIncludePath();
        return NullValue.NULL;
    }

    public static String set_include_path(Env env, String includePath) {
        return env.setIncludePath(includePath);
    }

    public static Value set_magic_quotes_runtime(Env env, Value value) {
        return BooleanValue.FALSE;
    }

    public static Value set_time_limit(Env env, long seconds) {
        env.setTimeLimit(seconds * 1000L);
        env.resetTimeout();
        return NullValue.NULL;
    }

    public static String sys_get_temp_dir(Env env) {
        Path tmp = env.getTempDirectory();
        return tmp.getNativePath() + Path.getFileSeparatorChar();
    }

    public static Value version_compare(Env env, StringValue version1, StringValue version2, @Optional(value="cmp") String op) {
        ArrayList<Value> expanded1 = OptionsModule.expandVersion(env, version1);
        ArrayList<Value> expanded2 = OptionsModule.expandVersion(env, version2);
        int cmp = OptionsModule.compareTo(expanded1, expanded2);
        if ("eq".equals(op) || "==".equals(op) || "=".equals(op)) {
            return cmp == 0 ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        if ("ne".equals(op) || "!=".equals(op) || "<>".equals(op)) {
            return cmp != 0 ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        if ("lt".equals(op) || "<".equals(op)) {
            return cmp < 0 ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        if ("le".equals(op) || "<=".equals(op)) {
            return cmp <= 0 ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        if ("gt".equals(op) || ">".equals(op)) {
            return cmp > 0 ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        if ("ge".equals(op) || ">=".equals(op)) {
            return cmp >= 0 ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        if (cmp == 0) {
            return LongValue.ZERO;
        }
        if (cmp < 0) {
            return LongValue.MINUS_ONE;
        }
        return LongValue.ONE;
    }

    public static String zend_version() {
        return "2.0.4";
    }

    public static boolean gc_enabled() {
        return true;
    }

    public static void gc_enable() {
    }

    public static void gc_disable() {
    }

    private static ArrayList<Value> expandVersion(Env env, StringValue version) {
        ArrayList<Value> expand = new ArrayList<Value>();
        int len = version.length();
        int i = 0;
        while (i < len) {
            char ch = version.charAt(i);
            if ('0' <= ch && ch <= '9') {
                int value = 0;
                while (i < len && '0' <= (ch = version.charAt(i)) && ch <= '9') {
                    value = 10 * value + ch - 48;
                    ++i;
                }
                expand.add(LongValue.create(value));
                continue;
            }
            if (Character.isLetter(ch)) {
                StringBuilder sb = new StringBuilder();
                while (i < len && Character.isLetter(version.charAt(i))) {
                    sb.append(ch);
                    ++i;
                }
                String s = sb.toString();
                s = s.equals("dev") ? "a" : (s.equals("alpha") || s.equals("a") ? "b" : (s.equals("beta") || s.equals("b") ? "c" : (s.equals("RC") ? "d" : (s.equals("pl") ? "e" : "z" + s))));
                expand.add(env.createString(s));
                continue;
            }
            ++i;
        }
        return expand;
    }

    private static boolean hasRequest(Env env) {
        return env.getRequest() != null;
    }

    private static Value escape(Env env, Value value) {
        if (value.isArray()) {
            ArrayValue array = value.toArrayValue(env);
            ArrayValueImpl result = new ArrayValueImpl();
            for (Map.Entry<Value, Value> entry : array.entrySet()) {
                Value key = OptionsModule.escape(env, entry.getKey());
                Value val = OptionsModule.escape(env, entry.getValue());
                result.put(key, val);
            }
            return result;
        }
        if (value.isObject()) {
            ObjectValue obj = (ObjectValue)value.toObject(env);
            ObjectExtValue result = new ObjectExtValue(env, obj.getQuercusClass());
            for (Map.Entry<Value, Value> entry : obj.entrySet()) {
                Value key = OptionsModule.escape(env, entry.getKey());
                Value val = OptionsModule.escape(env, entry.getValue());
                result.putField(env, key.toString(), val);
            }
            return result;
        }
        return HtmlModule.htmlspecialchars(env, value.toStringValue(), 2, null, true);
    }

    private static int compareTo(ArrayList<Value> a, ArrayList<Value> b) {
        int i = 0;
        while (a.size() > i || b.size() > i) {
            if (a.size() <= i) {
                return -1;
            }
            if (b.size() <= i) {
                return 1;
            }
            int cmp = OptionsModule.compareTo(a.get(i), b.get(i));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return 0;
    }

    private static int compareTo(Value a, Value b) {
        if (a.equals(b)) {
            return 0;
        }
        if (a.isLongConvertible() && !b.isLongConvertible()) {
            return -1;
        }
        if (b.isLongConvertible() && !a.isLongConvertible()) {
            return 1;
        }
        if (a.lt(b)) {
            return -1;
        }
        return 1;
    }
}

