/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.curl.CurlHttpConnection;
import com.caucho.quercus.lib.curl.CurlResource;
import com.caucho.quercus.lib.curl.HttpGetRequest;
import com.caucho.quercus.lib.curl.HttpPostRequest;
import com.caucho.quercus.lib.curl.HttpPutRequest;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class CurlHttpRequest
implements EnvCleanup {
    private static final Logger log = Logger.getLogger(CurlHttpRequest.class.getName());
    private static final L10N L = new L10N(CurlHttpRequest.class);
    private CurlResource _curl;
    private CurlHttpConnection _conn;

    public CurlHttpRequest(CurlResource curlResource) {
        this._curl = curlResource;
    }

    public static final CurlHttpRequest getRequest(CurlResource curl) {
        String requestMethod = curl.getRequestMethod();
        if (requestMethod.equals("GET")) {
            return new HttpGetRequest(curl);
        }
        if (requestMethod.equals("POST")) {
            return new HttpPostRequest(curl);
        }
        if (requestMethod.equals("PUT")) {
            return new HttpPutRequest(curl);
        }
        return new CurlHttpRequest(curl);
    }

    protected final void create(Env env) throws MalformedURLException, IOException {
        URL url = this.getURL(env, this._curl.getURL(), this._curl.getPort());
        if (url == null) {
            return;
        }
        if (this._curl.getIsProxying()) {
            URL proxyURL = this.getURL(env, this._curl.getProxyURL(), this._curl.getProxyPort());
            this._conn = CurlHttpConnection.createConnection(url, this._curl.getUsername(), this._curl.getPassword(), this._curl, proxyURL, this._curl.getProxyUsername(), this._curl.getProxyPassword(), this._curl.getProxyType());
        } else {
            this._conn = CurlHttpConnection.createConnection(url, this._curl.getUsername(), this._curl.getPassword(), this._curl);
        }
    }

    protected boolean init(Env env) throws ProtocolException {
        if (this._conn == null || this._curl == null) {
            return false;
        }
        if (!"GET".equals(this._curl.getRequestMethod())) {
            this._conn.setRequestMethod(this._curl.getRequestMethod());
        }
        HashMap<String, String> _properties = this._curl.getRequestPropertiesMap();
        for (Map.Entry<String, String> entry : _properties.entrySet()) {
            this._conn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        this._conn.setInstanceFollowRedirects(this._curl.getIsFollowingRedirects());
        int timeout = this._curl.getConnectTimeout();
        if (timeout >= 0) {
            this._conn.setConnectTimeout(timeout);
        }
        if ((timeout = this._curl.getReadTimeout()) >= 0) {
            this._conn.setReadTimeout(timeout);
        }
        return true;
    }

    protected void connect(Env env) throws ConnectException, SocketTimeoutException, UnknownHostException, IOException {
        if (this._conn != null) {
            this._conn.connect(this._curl);
        }
    }

    protected void transfer(Env env) throws IOException {
    }

    protected boolean finish(Env env) throws IOException {
        if (this._curl == null || this._conn == null) {
            return false;
        }
        this._curl.setResponseCode(this._conn.getResponseCode());
        Value header = this.getHeader(env, env.createBinaryBuilder());
        if (header == BooleanValue.FALSE) {
            return false;
        }
        this._curl.setHeader(header.toStringValue());
        Value body = this.getBody(env, env.createBinaryBuilder());
        if (body == BooleanValue.FALSE) {
            return false;
        }
        this._curl.setBody(body.toStringValue());
        this._curl.setContentLength(this._conn.getContentLength());
        this._curl.setCookie(this._conn.getHeaderField("Set-Cookie"));
        this._conn.close();
        return true;
    }

    public final boolean execute(Env env) {
        try {
            this.create(env);
            if (!this.init(env)) {
                return false;
            }
            this.connect(env);
            this.transfer(env);
            return this.finish(env);
        }
        catch (MalformedURLException e) {
            this.error(env, 3, e.getMessage(), e);
            return false;
        }
        catch (SocketTimeoutException e) {
            this.error(env, 28, "connection timed out", e);
            return false;
        }
        catch (ConnectException e) {
            this.error(env, 7, e.getMessage(), e);
            return false;
        }
        catch (ProtocolException e) {
            throw new QuercusModuleException(e.getMessage());
        }
        catch (UnknownHostException e) {
            this.error(env, 6, "unknown host: " + e.getMessage(), e);
            return false;
        }
        catch (IOException e) {
            this.error(env, 56, e.getMessage(), e);
            return false;
        }
    }

    protected final CurlResource getCurlResource() {
        return this._curl;
    }

    protected final CurlHttpConnection getHttpConnection() {
        return this._conn;
    }

    protected final void error(Env env, int code, String error) {
        log.log(Level.FINE, error);
        if (this._curl.getIsVerbose()) {
            env.warning(error);
        }
        this._curl.setError(error);
        this._curl.setErrorCode(code);
    }

    protected final void error(Env env, int code, String error, Throwable e) {
        log.log(Level.FINE, error, e);
        if (this._curl.getIsVerbose()) {
            env.warning(error);
        }
        this._curl.setError(error);
        this._curl.setErrorCode(code);
    }

    protected final URL getURL(Env env, String urlString, int port) throws MalformedURLException {
        if (urlString == null) {
            return null;
        }
        URL url = urlString.indexOf("://") < 0 ? new URL("http://" + urlString) : new URL(urlString);
        if (port >= 0) {
            url = new URL(url.getProtocol(), url.getHost(), port, url.getFile());
        }
        return url;
    }

    private final Value getHeader(Env env, StringValue bb) {
        Value len;
        StringValue sb;
        String key;
        String httpStatus = this._conn.getHeaderField(0);
        int i = 0;
        if (this._conn.getHeaderFieldKey(0) == null && httpStatus != null) {
            ++i;
        } else {
            try {
                int responseCode = this._conn.getResponseCode();
                httpStatus = "HTTP/1.1 " + responseCode + " " + this._conn.getResponseMessage();
            }
            catch (IOException e) {
                throw new QuercusException(e);
            }
        }
        bb.append(httpStatus);
        bb.append("\r\n");
        if (this._curl.getHeaderCallback() != null) {
            StringValue sb2 = env.createUnicodeBuilder();
            sb2.append(httpStatus);
            sb2.append("\r\n");
            Value len2 = this._curl.getHeaderCallback().call(env, env.wrapJava(this._curl), sb2);
            if (len2.toInt() != sb2.length()) {
                this._curl.setErrorCode(23);
                return BooleanValue.FALSE;
            }
        }
        while ((key = this._conn.getHeaderFieldKey(i)) != null) {
            bb.append(key);
            bb.append(": ");
            bb.append(this._conn.getHeaderField(i));
            bb.append("\r\n");
            if (this._curl.getHeaderCallback() != null) {
                sb = env.createUnicodeBuilder();
                sb.append(key);
                sb.append(": ");
                sb.append(this._conn.getHeaderField(i));
                sb.append("\r\n");
                len = this._curl.getHeaderCallback().call(env, env.wrapJava(this._curl), sb);
                if (len.toInt() != sb.length()) {
                    this._curl.setErrorCode(23);
                    return BooleanValue.FALSE;
                }
            }
            ++i;
        }
        bb.append("\r\n");
        if (this._curl.getHeaderCallback() != null) {
            sb = env.createUnicodeBuilder();
            sb.append("\r\n");
            len = this._curl.getHeaderCallback().call(env, env.wrapJava(this._curl), sb);
            if (len.toInt() != sb.length()) {
                this._curl.setErrorCode(23);
                return BooleanValue.FALSE;
            }
        }
        return bb;
    }

    private final Value getBody(Env env, StringValue bb) throws SocketTimeoutException, IOException {
        Value len;
        InputStream in = this._conn.getResponseCode() < 400 ? this._conn.getInputStream() : this._conn.getErrorStream();
        if (in == null) {
            return StringValue.EMPTY;
        }
        String encoding = this._conn.getHeaderField("Content-Encoding");
        if (encoding != null) {
            if (encoding.equals("gzip")) {
                in = new GZIPInputStream(in);
            } else if (encoding.equals("deflate")) {
                in = new InflaterInputStream(in);
            } else if (!encoding.equals("identity")) {
                this._curl.setError(encoding);
                this._curl.setErrorCode(61);
                return StringValue.EMPTY;
            }
        }
        try {
            int ch;
            while ((ch = in.read()) >= 0) {
                bb.appendByte(ch);
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        if (this._curl.getWriteCallback() != null && (len = this._curl.getWriteCallback().call(env, env.wrapJava(this._curl), bb)).toInt() != bb.length()) {
            this._curl.setErrorCode(23);
            return BooleanValue.FALSE;
        }
        return bb;
    }

    public void cleanup() {
        if (this._conn != null) {
            this._conn.close();
        }
    }
}

