/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.curl.CurlMultiResource;
import com.caucho.quercus.lib.curl.CurlResource;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;

public class CurlModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(CurlModule.class.getName());
    private static final L10N L = new L10N(CurlModule.class);
    public static final int CURLAUTH_ANY = -17;
    public static final int CURLAUTH_ANYSAFE = -18;
    public static final int CURLAUTH_BASIC = 1;
    public static final int CURLAUTH_DIGEST = 2;
    public static final int CURLAUTH_GSSNEGOTIATE = 4;
    public static final int CURLAUTH_NTLM = 8;
    public static final int CURLCLOSEPOLICY_CALLBACK = 5;
    public static final int CURLCLOSEPOLICY_LEAST_RECENTLY_USED = 2;
    public static final int CURLCLOSEPOLICY_LEAST_TRAFFIC = 3;
    public static final int CURLCLOSEPOLICY_OLDEST = 1;
    public static final int CURLCLOSEPOLICY_SLOWEST = 4;
    public static final int CURLE_ABORTED_BY_CALLBACK = 42;
    public static final int CURLE_BAD_CALLING_ORDER = 44;
    public static final int CURLE_BAD_CONTENT_ENCODING = 61;
    public static final int CURLE_BAD_FUNCTION_ARGUMENT = 43;
    public static final int CURLE_BAD_PASSWORD_ENTERED = 46;
    public static final int CURLE_COULDNT_CONNECT = 7;
    public static final int CURLE_COULDNT_RESOLVE_HOST = 6;
    public static final int CURLE_COULDNT_RESOLVE_PROXY = 5;
    public static final int CURLE_FAILED_INIT = 2;
    public static final int CURLE_FILE_COULDNT_READ_FILE = 37;
    public static final int CURLE_FILESIZE_EXCEEDED = 63;
    public static final int CURLE_FTP_ACCESS_DENIED = 9;
    public static final int CURLE_FTP_BAD_DOWNLOAD_RESUME = 36;
    public static final int CURLE_FTP_CANT_GET_HOST = 15;
    public static final int CURLE_FTP_CANT_RECONNECT = 16;
    public static final int CURLE_FTP_COULDNT_GET_SIZE = 32;
    public static final int CURLE_FTP_COULDNT_RETR_FILE = 19;
    public static final int CURLE_FTP_COULDNT_SET_ASCII = 29;
    public static final int CURLE_FTP_COULDNT_SET_BINARY = 17;
    public static final int CURLE_FTP_COULDNT_STOR_FILE = 25;
    public static final int CURLE_FTP_COULDNT_USE_REST = 31;
    public static final int CURLE_FTP_PORT_FAILED = 30;
    public static final int CURLE_FTP_QUOTE_ERROR = 21;
    public static final int CURLE_FTP_SSL_FAILED = 64;
    public static final int CURLE_FTP_USER_PASSWORD_INCORRECT = 10;
    public static final int CURLE_FTP_WEIRD_227_FORMAT = 14;
    public static final int CURLE_FTP_WEIRD_PASS_REPLY = 11;
    public static final int CURLE_FTP_WEIRD_PASV_REPLY = 13;
    public static final int CURLE_FTP_WEIRD_SERVER_REPLY = 8;
    public static final int CURLE_FTP_WEIRD_USER_REPLY = 12;
    public static final int CURLE_FTP_WRITE_ERROR = 20;
    public static final int CURLE_FUNCTION_NOT_FOUND = 41;
    public static final int CURLE_GOT_NOTHING = 52;
    public static final int CURLE_HTTP_NOT_FOUND = 22;
    public static final int CURLE_HTTP_PORT_FAILED = 45;
    public static final int CURLE_HTTP_POST_ERROR = 34;
    public static final int CURLE_HTTP_RANGE_ERROR = 33;
    public static final int CURLE_LDAP_CANNOT_BIND = 38;
    public static final int CURLE_LDAP_INVALID_URL = 62;
    public static final int CURLE_LDAP_SEARCH_FAILED = 39;
    public static final int CURLE_LIBRARY_NOT_FOUND = 40;
    public static final int CURLE_MALFORMAT_USER = 24;
    public static final int CURLE_OBSOLETE = 50;
    public static final int CURLE_OK = 0;
    public static final int CURLE_OPERATION_TIMEOUTED = 28;
    public static final int CURLE_OUT_OF_MEMORY = 27;
    public static final int CURLE_PARTIAL_FILE = 18;
    public static final int CURLE_READ_ERROR = 26;
    public static final int CURLE_RECV_ERROR = 56;
    public static final int CURLE_SEND_ERROR = 55;
    public static final int CURLE_SHARE_IN_USE = 57;
    public static final int CURLE_SSL_CACERT = 60;
    public static final int CURLE_SSL_CERTPROBLEM = 58;
    public static final int CURLE_SSL_CIPHER = 59;
    public static final int CURLE_SSL_CONNECT_ERROR = 35;
    public static final int CURLE_SSL_ENGINE_NOTFOUND = 53;
    public static final int CURLE_SSL_ENGINE_SETFAILED = 54;
    public static final int CURLE_SSL_PEER_CERTIFICATE = 51;
    public static final int CURLE_TELNET_OPTION_SYNTAX = 49;
    public static final int CURLE_TOO_MANY_REDIRECTS = 47;
    public static final int CURLE_UNKNOWN_TELNET_OPTION = 48;
    public static final int CURLE_UNSUPPORTED_PROTOCOL = 1;
    public static final int CURLE_URL_MALFORMAT = 3;
    public static final int CURLE_URL_MALFORMAT_USER = 4;
    public static final int CURLE_WRITE_ERROR = 23;
    public static final int CURLFTPAUTH_DEFAULT = 0;
    public static final int CURLFTPAUTH_SSL = 1;
    public static final int CURLFTPAUTH_TLS = 2;
    public static final int CURLFTPSSL_ALL = 3;
    public static final int CURLFTPSSL_CONTROL = 2;
    public static final int CURLFTPSSL_NONE = 0;
    public static final int CURLFTPSSL_TRY = 1;
    public static final int CURL_HTTP_VERSION_1_0 = 1;
    public static final int CURL_HTTP_VERSION_1_1 = 2;
    public static final int CURL_HTTP_VERSION_NONE = 0;
    public static final int CURLINFO_CONNECT_TIME = 0x300005;
    public static final int CURLINFO_CONTENT_LENGTH_DOWNLOAD = 0x30000F;
    public static final int CURLINFO_CONTENT_LENGTH_UPLOAD = 0x300010;
    public static final int CURLINFO_CONTENT_TYPE = 0x100012;
    public static final int CURLINFO_EFFECTIVE_URL = 0x100001;
    public static final int CURLINFO_FILETIME = 0x20000E;
    public static final int CURLINFO_HEADER_OUT = 2;
    public static final int CURLINFO_HEADER_SIZE = 0x20000B;
    public static final int CURLINFO_HTTP_CODE = 0x200002;
    public static final int CURLINFO_NAMELOOKUP_TIME = 0x300004;
    public static final int CURLINFO_PRETRANSFER_TIME = 0x300006;
    public static final int CURLINFO_PRIVATE = 0x100015;
    public static final int CURLINFO_REDIRECT_COUNT = 2097172;
    public static final int CURLINFO_REDIRECT_TIME = 0x300013;
    public static final int CURLINFO_REQUEST_SIZE = 0x20000C;
    public static final int CURLINFO_SIZE_DOWNLOAD = 0x300008;
    public static final int CURLINFO_SIZE_UPLOAD = 0x300007;
    public static final int CURLINFO_SPEED_DOWNLOAD = 0x300009;
    public static final int CURLINFO_SPEED_UPLOAD = 0x30000A;
    public static final int CURLINFO_SSL_VERIFYRESULT = 0x20000D;
    public static final int CURLINFO_STARTTRANSFER_TIME = 0x300011;
    public static final int CURLINFO_TOTAL_TIME = 0x300003;
    public static final int CURLM_BAD_EASY_HANDLE = 2;
    public static final int CURLM_BAD_HANDLE = 1;
    public static final int CURLM_CALL_MULTI_PERFORM = -1;
    public static final int CURLM_INTERNAL_ERROR = 4;
    public static final int CURLM_OK = 0;
    public static final int CURLM_OUT_OF_MEMORY = 3;
    public static final int CURLMSG_DONE = 1;
    public static final int CURL_NETRC_IGNORED = 0;
    public static final int CURL_NETRC_OPTIONAL = 1;
    public static final int CURL_NETRC_REQUIRED = 2;
    public static final int CURLOPT_AUTOREFERER = 58;
    public static final int CURLOPT_BINARYTRANSFER = 19914;
    public static final int CURLOPT_BUFFERSIZE = 98;
    public static final int CURLOPT_CAINFO = 10065;
    public static final int CURLOPT_CAPATH = 10097;
    public static final int CURLOPT_CLOSEPOLICY = 72;
    public static final int CURLOPT_CONNECTTIMEOUT = 78;
    public static final int CURLOPT_CONNECTTIMEOUT_MS = 156;
    public static final int CURLOPT_COOKIE = 10022;
    public static final int CURLOPT_COOKIEFILE = 10031;
    public static final int CURLOPT_COOKIEJAR = 10082;
    public static final int CURLOPT_COOKIESESSION = 96;
    public static final int CURLOPT_CRLF = 27;
    public static final int CURLOPT_CUSTOMREQUEST = 10036;
    public static final int CURLOPT_DNS_CACHE_TIMEOUT = 92;
    public static final int CURLOPT_DNS_USE_GLOBAL_CACHE = 91;
    public static final int CURLOPT_EGDSOCKET = 10077;
    public static final int CURLOPT_ENCODING = 10102;
    public static final int CURLOPT_FAILONERROR = 45;
    public static final int CURLOPT_FILE = 10001;
    public static final int CURLOPT_FILETIME = 69;
    public static final int CURLOPT_FOLLOWLOCATION = 52;
    public static final int CURLOPT_FORBID_REUSE = 75;
    public static final int CURLOPT_FRESH_CONNECT = 74;
    public static final int CURLOPT_FTPAPPEND = 50;
    public static final int CURLOPT_FTPASCII = 24;
    public static final int CURLOPT_FTP_CREATE_MISSING_DIRS = 110;
    public static final int CURLOPT_FTPLISTONLY = 48;
    public static final int CURLOPT_FTPPORT = 10017;
    public static final int CURLOPT_FTP_SSL = 119;
    public static final int CURLOPT_FTPSSLAUTH = 129;
    public static final int CURLOPT_FTP_USE_EPRT = 106;
    public static final int CURLOPT_FTP_USE_EPSV = 85;
    public static final int CURLOPT_HEADER = 42;
    public static final int CURLOPT_HEADERFUNCTION = 20079;
    public static final int CURLOPT_HTTP200ALIASES = 10104;
    public static final int CURLOPT_HTTPAUTH = 107;
    public static final int CURLOPT_HTTPGET = 80;
    public static final int CURLOPT_HTTPHEADER = 10023;
    public static final int CURLOPT_HTTPPROXYTUNNEL = 61;
    public static final int CURLOPT_HTTP_VERSION = 84;
    public static final int CURLOPT_INFILE = 10009;
    public static final int CURLOPT_INFILESIZE = 14;
    public static final int CURLOPT_INTERFACE = 10062;
    public static final int CURLOPT_KRB4LEVEL = 10063;
    public static final int CURLOPT_LOW_SPEED_LIMIT = 19;
    public static final int CURLOPT_LOW_SPEED_TIME = 20;
    public static final int CURLOPT_MAXCONNECTS = 71;
    public static final int CURLOPT_MAXREDIRS = 68;
    public static final int CURLOPT_MUTE = 26;
    public static final int CURLOPT_NETRC = 51;
    public static final int CURLOPT_NOBODY = 44;
    public static final int CURLOPT_NOPROGRESS = 43;
    public static final int CURLOPT_NOSIGNAL = 99;
    public static final int CURLOPT_PASSWDFUNCTION = 60;
    public static final int CURLOPT_PORT = 3;
    public static final int CURLOPT_POST = 47;
    public static final int CURLOPT_POSTFIELDS = 10015;
    public static final int CURLOPT_POSTQUOTE = 10039;
    public static final int CURLOPT_PRIVATE = 10103;
    public static final int CURLOPT_PROGRESSFUNCTION = 20056;
    public static final int CURLOPT_PROXY = 10004;
    public static final int CURLOPT_PROXYAUTH = 111;
    public static final int CURLOPT_PROXYPORT = 59;
    public static final int CURLOPT_PROXYTYPE = 101;
    public static final int CURLOPT_PROXYUSERPWD = 10006;
    public static final int CURLOPT_PUT = 54;
    public static final int CURLOPT_QUOTE = 10028;
    public static final int CURLOPT_RANDOM_FILE = 10076;
    public static final int CURLOPT_RANGE = 10007;
    public static final int CURLOPT_READFUNCTION = 20012;
    public static final int CURLOPT_REFERER = 10016;
    public static final int CURLOPT_RESUME_FROM = 21;
    public static final int CURLOPT_RETURNTRANSFER = 19913;
    public static final int CURLOPT_SSLCERT = 10025;
    public static final int CURLOPT_SSLCERTPASSWD = 10026;
    public static final int CURLOPT_SSLCERTTYPE = 10086;
    public static final int CURLOPT_SSL_CIPHER_LIST = 10083;
    public static final int CURLOPT_SSLENGINE = 10089;
    public static final int CURLOPT_SSLENGINE_DEFAULT = 90;
    public static final int CURLOPT_SSLKEY = 10087;
    public static final int CURLOPT_SSLKEYPASSWD = 10026;
    public static final int CURLOPT_SSLKEYTYPE = 10088;
    public static final int CURLOPT_SSL_VERIFYHOST = 81;
    public static final int CURLOPT_SSL_VERIFYPEER = 64;
    public static final int CURLOPT_SSLVERSION = 32;
    public static final int CURLOPT_STDERR = 10037;
    public static final int CURLOPT_TCP_NODELAY = 121;
    public static final int CURLOPT_TIMECONDITION = 33;
    public static final int CURLOPT_TIMEOUT = 13;
    public static final int CURLOPT_TIMEOUT_MS = 155;
    public static final int CURLOPT_TIMEVALUE = 34;
    public static final int CURLOPT_TRANSFERTEXT = 53;
    public static final int CURLOPT_UNRESTRICTED_AUTH = 105;
    public static final int CURLOPT_UPLOAD = 46;
    public static final int CURLOPT_URL = 10002;
    public static final int CURLOPT_USERAGENT = 10018;
    public static final int CURLOPT_USERPWD = 10005;
    public static final int CURLOPT_VERBOSE = 41;
    public static final int CURLOPT_WRITEFUNCTION = 20011;
    public static final int CURLOPT_WRITEHEADER = 10029;
    public static final int CURLPROXY_HTTP = 0;
    public static final int CURLPROXY_SOCKS5 = 5;
    public static final int CURL_TIMECOND_IFMODSINCE = 1;
    public static final int CURL_TIMECOND_IFUNMODSINCE = 2;
    public static final int CURL_TIMECOND_LASTMOD = 3;
    public static final int CURL_VERSION_IPV6 = 1;
    public static final int CURL_VERSION_KERBEROS4 = 2;
    public static final int CURL_VERSION_LIBZ = 8;
    public static final int CURLVERSION_NOW = 3;
    public static final int CURL_VERSION_SSL = 4;

    public String[] getLoadedExtensions() {
        return new String[]{"curl"};
    }

    public static void curl_close(Env env, @NotNull CurlResource curl) {
        if (curl == null) {
            return;
        }
        curl.close();
    }

    @ReturnNullAsFalse
    public static CurlResource curl_copy_handle(Env env, @NotNull CurlResource curl) {
        if (curl == null) {
            return null;
        }
        return curl.clone();
    }

    public static Value curl_errno(Env env, @NotNull CurlResource curl) {
        if (curl == null) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(curl.getErrorCode());
    }

    public static Value curl_error(Env env, @NotNull CurlResource curl) {
        if (curl == null) {
            return BooleanValue.FALSE;
        }
        return env.createString(curl.getError());
    }

    public static Value curl_exec(Env env, @NotNull CurlResource curl) {
        if (curl == null) {
            return BooleanValue.FALSE;
        }
        return curl.execute(env);
    }

    public static Value curl_getinfo(Env env, @NotNull CurlResource curl, @Optional Value option) {
        if (curl == null) {
            return BooleanValue.FALSE;
        }
        if (option.isDefault()) {
            ArrayValueImpl array = new ArrayValueImpl();
            CurlModule.putInfo(env, curl, array, "url", 0x100001);
            CurlModule.putInfo(env, curl, array, "http_code", 0x200002);
            CurlModule.putInfo(env, curl, array, "header_size", 0x20000B);
            CurlModule.putInfo(env, curl, array, "request_size", 0x20000C);
            CurlModule.putInfo(env, curl, array, "filetime", 0x20000E);
            CurlModule.putInfo(env, curl, array, "ssl_verify_result", 0x20000D);
            CurlModule.putInfo(env, curl, array, "redirect_count", 2097172);
            CurlModule.putInfo(env, curl, array, "total_time", 0x300003);
            CurlModule.putInfo(env, curl, array, "namelookup_time", 0x300004);
            CurlModule.putInfo(env, curl, array, "connect_time", 0x300005);
            CurlModule.putInfo(env, curl, array, "pretransfer_time", 0x300006);
            CurlModule.putInfo(env, curl, array, "size_upload", 0x300007);
            CurlModule.putInfo(env, curl, array, "size_download", 0x300008);
            CurlModule.putInfo(env, curl, array, "speed_download", 0x300009);
            CurlModule.putInfo(env, curl, array, "speed_upload", 0x30000A);
            CurlModule.putInfo(env, curl, array, "download_content_length", 0x30000F);
            CurlModule.putInfo(env, curl, array, "upload_content_length", 0x300010);
            CurlModule.putInfo(env, curl, array, "starttransfer_time", 0x300011);
            CurlModule.putInfo(env, curl, array, "redirect_time", 0x300013);
            return array;
        }
        return CurlModule.getInfo(env, curl, option.toInt());
    }

    private static void putInfo(Env env, CurlResource curl, ArrayValue array, String name, int option) {
        array.put(env.createString(name), CurlModule.getInfo(env, curl, option));
    }

    private static Value getInfo(Env env, CurlResource curl, int option) {
        switch (option) {
            case 0x100001: {
                return env.createString(curl.getURL());
            }
            case 0x200002: {
                return LongValue.create(curl.getResponseCode());
            }
            case 0x20000B: {
                if (curl.getHeader() != null) {
                    return LongValue.create(curl.getHeader().length());
                }
                return LongValue.ZERO;
            }
            case 0x20000C: {
                break;
            }
            case 0x20000E: {
                break;
            }
            case 0x20000D: {
                break;
            }
            case 2097172: {
                break;
            }
            case 0x300003: {
                break;
            }
            case 0x300004: {
                break;
            }
            case 0x300005: {
                break;
            }
            case 0x300006: {
                break;
            }
            case 0x300007: {
                break;
            }
            case 0x300008: {
                break;
            }
            case 0x300009: {
                break;
            }
            case 0x30000A: {
                break;
            }
            case 0x30000F: {
                return LongValue.create(curl.getContentLength());
            }
            case 0x300010: {
                break;
            }
            case 0x300011: {
                break;
            }
            case 0x300013: {
                break;
            }
            case 2: {
                return curl.getHeader();
            }
            case 0x100012: {
                String type = curl.getContentType();
                if (type == null) {
                    return NullValue.NULL;
                }
                return env.createString(type);
            }
            default: {
                env.warning(L.l("Unknown CURL getinfo option"));
            }
        }
        return NullValue.NULL;
    }

    public static CurlResource curl_init(Env env, @Optional String url) {
        CurlResource curl = new CurlResource();
        if (url != null) {
            CurlModule.setURL(curl, url);
        }
        return curl;
    }

    private static void setURL(CurlResource curl, String url) {
        int atSignIndex = url.indexOf(64);
        if (atSignIndex < 0) {
            curl.setURL(url);
            return;
        }
        int j = url.indexOf("://");
        if (j < 0) {
            curl.setURL("http://" + url);
            return;
        }
        int slashIndex = url.indexOf(47, j + 3);
        if (0 < slashIndex && slashIndex < atSignIndex) {
            curl.setURL(url);
            return;
        }
        String protocol = url.substring(0, j += 3);
        int colonIndex = url.indexOf(58, j);
        if (colonIndex < 0 || colonIndex > atSignIndex) {
            curl.setURL(url);
            return;
        }
        curl.setUsername(url.substring(j, colonIndex++));
        curl.setPassword(url.substring(colonIndex, atSignIndex++));
        curl.setURL(protocol + url.substring(atSignIndex));
    }

    public static int curl_multi_add_handle(Env env, CurlMultiResource multi, CurlResource curl) {
        multi.addCurl(curl);
        return 0;
    }

    public static void curl_multi_close(Env env, CurlMultiResource multi) {
        for (CurlResource curl : multi.getCurlList()) {
            CurlModule.curl_close(env, curl);
        }
    }

    public static int curl_multi_exec(Env env, CurlMultiResource multi, @Reference Value stillRunning) {
        return multi.execute(env, stillRunning);
    }

    public static Value curl_multi_getcontent(Env env, CurlResource curl) {
        StringValue data = curl.getReturnTransfer();
        if (data != null) {
            return data;
        }
        return NullValue.NULL;
    }

    public static Value curl_multi_info_read(Env env, CurlMultiResource multi, @Optional @Reference Value msgsInQueue) {
        return multi.readInfo(env, msgsInQueue);
    }

    public static CurlMultiResource curl_multi_init(Env env) {
        return new CurlMultiResource();
    }

    public static int curl_multi_remove_handle(Env env, CurlMultiResource multi, CurlResource curl) {
        multi.removeCurl(curl);
        return 0;
    }

    public static int curl_multi_select(Env env, CurlMultiResource multi, @Optional Value timeout) {
        return 0;
    }

    public static BooleanValue curl_setopt_array(Env env, @NotNull CurlResource curl, ArrayValue options) {
        if (curl == null) {
            return BooleanValue.FALSE;
        }
        for (Map.Entry<Value, Value> entry : options.entrySet()) {
            if (CurlModule.setOption(env, curl, entry.getKey().toInt(), entry.getValue())) continue;
            return BooleanValue.FALSE;
        }
        return BooleanValue.TRUE;
    }

    public static BooleanValue curl_setopt(Env env, @NotNull CurlResource curl, int option, Value value) {
        if (curl == null) {
            return BooleanValue.FALSE;
        }
        if (CurlModule.setOption(env, curl, option, value)) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    private static boolean setOption(Env env, CurlResource curl, int option, Value value) {
        block2 : switch (option) {
            case 58: {
                break;
            }
            case 96: {
                curl.setCookie(null);
                break;
            }
            case 45: {
                curl.setFailOnError(value.toBoolean());
                break;
            }
            case 52: {
                curl.setIsFollowingRedirects(value.toBoolean());
                break;
            }
            case 74: {
                break;
            }
            case 42: {
                curl.setIsReturningHeader(value.toBoolean());
                break;
            }
            case 80: {
                curl.setRequestMethod("GET");
                break;
            }
            case 61: {
                curl.setIsProxying(value.toBoolean());
                break;
            }
            case 26: {
                curl.setIsVerbose(!value.toBoolean());
                break;
            }
            case 51: {
                break;
            }
            case 44: {
                curl.setIsReturningBody(false);
                break;
            }
            case 43: {
                break;
            }
            case 47: {
                curl.setRequestMethod("POST");
                break;
            }
            case 54: {
                curl.setRequestMethod("PUT");
                break;
            }
            case 19913: {
                curl.setIsReturningData(value.toBoolean());
                break;
            }
            case 105: {
                break;
            }
            case 64: {
                curl.setIsVerifySSLPeer(value.toBoolean());
                break;
            }
            case 46: {
                if (!value.toBoolean()) break;
                curl.setRequestMethod("PUT");
                break;
            }
            case 41: {
                curl.setIsVerbose(value.toBoolean());
                break;
            }
            case 98: {
                break;
            }
            case 78: {
                curl.setConnectTimeout(value.toInt() * 1000);
                break;
            }
            case 84: {
                if (value.toInt() != 1) break;
                env.stub("cURL HTTP/1.0 not specifically supported");
                break;
            }
            case 107: {
                break;
            }
            case 14: {
                curl.setUploadFileSize(value.toLong());
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                break;
            }
            case 71: {
                break;
            }
            case 68: {
                break;
            }
            case 3: {
                curl.setPort(value.toInt());
                break;
            }
            case 111: {
                break;
            }
            case 59: {
                curl.setProxyPort(value.toInt());
                break;
            }
            case 101: {
                switch (value.toInt()) {
                    case 0: {
                        curl.setProxyType("HTTP");
                        break block2;
                    }
                    case 5: {
                        curl.setProxyType("SOCKS");
                        break block2;
                    }
                }
                env.warning(L.l("unknown curl proxy type"));
                break;
            }
            case 81: {
                int i = value.toInt();
                switch (i) {
                    case 0: {
                        curl.setIsVerifySSLCommonName(false);
                        curl.setIsVerifySSLHostname(false);
                        break block2;
                    }
                    case 1: {
                        curl.setIsVerifySSLCommonName(true);
                        curl.setIsVerifySSLHostname(false);
                        break block2;
                    }
                    case 2: {
                        curl.setIsVerifySSLCommonName(true);
                        curl.setIsVerifySSLHostname(true);
                        break block2;
                    }
                }
                env.warning(L.l("unknown ssl verify host option '{0}", i));
                break;
            }
            case 33: {
                switch (value.toInt()) {
                    case 1: {
                        curl.setIfModifiedSince(true);
                        break block2;
                    }
                    case 2: {
                        curl.setIfModifiedSince(false);
                        break block2;
                    }
                }
                env.warning(L.l("invalid CURLOPT_TIMECONDITION option"));
                break;
            }
            case 13: {
                curl.setReadTimeout(value.toInt() * 1000);
                break;
            }
            case 34: {
                long time = value.toLong() * 1000L;
                String format = "%a, %d %b %Y %H:%M:%S %Z";
                String date = QDate.formatGMT(time, format);
                curl.setModifiedTime(date);
                break;
            }
            case 10022: {
                curl.setCookie(value.toString());
                break;
            }
            case 10031: {
                ReadStream in = null;
                try {
                    int ch;
                    Path path = env.getPwd().lookup(value.toString());
                    if (!path.exists()) break;
                    in = path.openRead();
                    StringBuilder sb = new StringBuilder();
                    while ((ch = in.read()) >= 0) {
                        sb.append((char)ch);
                    }
                    curl.setCookie(sb.toString());
                    break;
                }
                catch (IOException e) {
                    throw new QuercusModuleException(e);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            case 10082: {
                curl.setCookieFilename(value.toString());
                break;
            }
            case 10036: {
                curl.setRequestMethod(value.toString());
                break;
            }
            case 10102: {
                String encoding = value.toString();
                if (encoding.length() == 0) {
                    encoding = "gzip, deflate, identity";
                }
                curl.setRequestProperty("Accept-Encoding", encoding);
                break;
            }
            case 10015: {
                curl.setRequestMethod("POST");
                curl.setPostBody(value);
                break;
            }
            case 10004: {
                curl.setIsProxying(true);
                curl.setProxyURL(value.toString());
                break;
            }
            case 10006: {
                String proxyUserPwd = value.toString();
                int i = proxyUserPwd.indexOf(58);
                if (i >= 0) {
                    curl.setProxyUsername(proxyUserPwd.substring(0, i));
                }
                curl.setProxyPassword(proxyUserPwd.substring(i + 1));
                break;
            }
            case 10007: {
                curl.setRequestProperty("Range", "bytes=" + value.toString());
                break;
            }
            case 10016: {
                curl.setRequestProperty("Referer", value.toString());
                break;
            }
            case 10002: {
                CurlModule.setURL(curl, value.toString());
                break;
            }
            case 10018: {
                curl.setRequestProperty("User-Agent", value.toString());
                break;
            }
            case 10005: {
                String userpwd = value.toString();
                int i = userpwd.indexOf(58);
                if (i >= 0) {
                    curl.setUsername(userpwd.substring(0, i));
                }
                curl.setPassword(userpwd.substring(i + 1));
                break;
            }
            case 10104: {
                break;
            }
            case 10023: {
                ArrayValue array = value.toArrayValue(env);
                for (Map.Entry<Value, Value> entry : array.entrySet()) {
                    String header;
                    String name = header = entry.getValue().toString();
                    String body = "";
                    int i = header.indexOf(58);
                    if (i >= 0) {
                        name = header.substring(0, i).trim();
                        body = header.substring(i + 1).trim();
                    }
                    curl.setRequestProperty(name, body);
                }
                break;
            }
            case 10001: {
                Object outputFile = value.toJavaObject();
                if (!(outputFile instanceof BinaryOutput)) break;
                curl.setOutputFile((BinaryOutput)outputFile);
                break;
            }
            case 10009: {
                Object uploadFile = value.toJavaObject();
                if (!(uploadFile instanceof BinaryInput)) break;
                curl.setUploadFile((BinaryInput)uploadFile);
                break;
            }
            case 10037: {
                break;
            }
            case 10029: {
                Object outputHeaderFile = value.toJavaObject();
                if (!(outputHeaderFile instanceof BinaryOutput)) break;
                curl.setOutputHeaderFile((BinaryOutput)outputHeaderFile);
                break;
            }
            case 20079: {
                curl.setHeaderCallback(value.toCallable(env, false));
                break;
            }
            case 60: {
                curl.setPasswordCallback(value.toCallable(env, false));
                break;
            }
            case 20012: {
                curl.setReadCallback(value.toCallable(env, false));
                break;
            }
            case 20011: {
                curl.setWriteCallback(value.toCallable(env, false));
                break;
            }
            default: {
                env.warning(L.l("CURL option '{0}' unknown or unimplemented", option));
                log.fine(L.l("CURL option '{0}' unknown or unimplemented", option));
                return false;
            }
        }
        return true;
    }

    public static ArrayValue curl_version(Env env, @Optional Value age) {
        ArrayValueImpl array = new ArrayValueImpl();
        array.put(env, "version_number", 462848L);
        array.put(env, "age", 2L);
        array.put(env, "features", 540L);
        array.put(env, "ssl_version_number", 0L);
        array.put(env, "version", "7.16.0");
        array.put(env, "host", "i386-pc-java");
        array.put(env, "ssl_version", " OpenSSL/0.9.8g");
        array.put(env, "libz_version", "1.2.3");
        ArrayValueImpl protocols = new ArrayValueImpl();
        ((ArrayValue)protocols).put(env.createString("http"));
        ((ArrayValue)protocols).put(env.createString("https"));
        array.put(env.createString("protocols"), protocols);
        return array;
    }
}

