/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReadOnly;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.DataSourceConnection;
import com.caucho.quercus.lib.db.JdbcConnectionResource;
import com.caucho.quercus.lib.db.JdbcDriverContext;
import com.caucho.quercus.lib.db.Mysqli;
import com.caucho.quercus.lib.db.PDOError;
import com.caucho.quercus.lib.db.PDOStatement;
import com.caucho.quercus.lib.db.Postgres;
import com.caucho.quercus.lib.db.SQLite3;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDO
implements EnvCleanup {
    private static final Logger log = Logger.getLogger(PDO.class.getName());
    private static final L10N L = new L10N(PDO.class);
    public static final int ATTR_AUTOCOMMIT = 0;
    public static final int ATTR_PREFETCH = 1;
    public static final int ATTR_TIMEOUT = 2;
    public static final int ATTR_ERRMODE = 3;
    public static final int ATTR_SERVER_VERSION = 4;
    public static final int ATTR_CLIENT_VERSION = 5;
    public static final int ATTR_SERVER_INFO = 6;
    public static final int ATTR_CONNECTION_STATUS = 7;
    public static final int ATTR_CASE = 8;
    public static final int ATTR_CURSOR_NAME = 9;
    public static final int ATTR_CURSOR = 10;
    public static final int ATTR_ORACLE_NULLS = 11;
    public static final int ATTR_PERSISTENT = 12;
    public static final int ATTR_STATEMENT_CLASS = 13;
    public static final int ATTR_FETCH_TABLE_NAMES = 14;
    public static final int ATTR_FETCH_CATALOG_NAMES = 15;
    public static final int ATTR_DRIVER_NAME = 16;
    public static final int ATTR_STRINGIFY_FETCHES = 17;
    public static final int ATTR_MAX_COLUMN_LEN = 18;
    public static final int ATTR_DEFAULT_FETCH_MODE = 19;
    public static final int ATTR_EMULATE_PREPARES = 20;
    public static final int CASE_NATURAL = 0;
    public static final int CASE_UPPER = 1;
    public static final int CASE_LOWER = 2;
    public static final int CURSOR_FWDONLY = 0;
    public static final int CURSOR_SCROLL = 1;
    public static final String ERR_NONE = "00000";
    public static final int ERRMODE_SILENT = 0;
    public static final int ERRMODE_WARNING = 1;
    public static final int ERRMODE_EXCEPTION = 2;
    public static final int FETCH_LAZY = 1;
    public static final int FETCH_ASSOC = 2;
    public static final int FETCH_NUM = 3;
    public static final int FETCH_BOTH = 4;
    public static final int FETCH_OBJ = 5;
    public static final int FETCH_BOUND = 6;
    public static final int FETCH_COLUMN = 7;
    public static final int FETCH_CLASS = 8;
    public static final int FETCH_INTO = 9;
    public static final int FETCH_FUNC = 10;
    public static final int FETCH_NAMED = 11;
    public static final int FETCH_KEY_PAIR = 12;
    public static final int FETCH_GROUP = 65536;
    public static final int FETCH_UNIQUE = 196608;
    public static final int FETCH_CLASSTYPE = 262144;
    public static final int FETCH_SERIALIZE = 524288;
    public static final int FETCH_ORI_NEXT = 0;
    public static final int FETCH_ORI_PRIOR = 1;
    public static final int FETCH_ORI_FIRST = 2;
    public static final int FETCH_ORI_LAST = 3;
    public static final int FETCH_ORI_ABS = 4;
    public static final int FETCH_ORI_REL = 5;
    public static final int FETCH_PROPS_LATE = 0x100000;
    public static final int MYSQL_ATTR_USE_BUFFERED_QUERY = 1000;
    public static final int NULL_NATURAL = 0;
    public static final int NULL_EMPTY_STRING = 1;
    public static final int NULL_TO_STRING = 2;
    public static final int PARAM_NULL = 0;
    public static final int PARAM_INT = 1;
    public static final int PARAM_STR = 2;
    public static final int PARAM_LOB = 3;
    public static final int PARAM_STMT = 4;
    public static final int PARAM_BOOL = 5;
    public static final int PARAM_EVT_ALLOC = 0;
    public static final int PARAM_EVT_EXEC_POST = 3;
    public static final int PARAM_EVT_EXEC_PRE = 2;
    public static final int PARAM_EVT_FETCH_POST = 5;
    public static final int PARAM_EVT_FETCH_PRE = 4;
    public static final int PARAM_EVT_FREE = 1;
    public static final int PARAM_EVT_NORMALIZE = 6;
    public static final int PARAM_INPUT_OUTPUT = Integer.MIN_VALUE;
    private final String _dsn;
    private JdbcConnectionResource _conn;
    private final PDOError _error;
    private PDOStatement _lastPDOStatement;
    private PDOStatement _lastExecutedStatement;
    private boolean _inTransaction;
    private String _statementClassName;
    private Value[] _statementClassArgs;
    private boolean _isEmulatePrepares;
    private int _columnCase = 0;

    public PDO(Env env, String dsn, @Optional String user, @Optional String pass, @Optional @ReadOnly ArrayValue options) {
        this._dsn = dsn;
        this._error = new PDOError();
        if (options != null) {
            for (Map.Entry<Value, Value> entry : options.entrySet()) {
                this.setAttribute(env, entry.getKey().toInt(), entry.getValue());
            }
        }
        env.addCleanup(this);
        try {
            JdbcConnectionResource conn;
            this._conn = conn = this.getConnection(env, dsn, user, pass);
            if (conn == null) {
                env.warning(L.l("'{0}' is an unknown PDO data source.", (Object)dsn));
            }
        }
        catch (SQLException e) {
            env.warning(e.getMessage(), e);
            this._error.error(env, e);
        }
    }

    protected JdbcConnectionResource getConnection() {
        return this._conn;
    }

    protected boolean isConnected() {
        return this._conn != null && this._conn.isConnected();
    }

    protected void setLastExecutedStatement(PDOStatement stmt) {
        this._lastExecutedStatement = stmt;
    }

    public boolean beginTransaction() {
        JdbcConnectionResource conn = this.getConnection();
        if (!this.isConnected()) {
            return false;
        }
        if (this._inTransaction) {
            return false;
        }
        this._inTransaction = true;
        return conn.setAutoCommit(false);
    }

    private void closeStatements() {
        PDOStatement stmt = this._lastPDOStatement;
        this._lastPDOStatement = null;
        if (stmt != null) {
            stmt.close();
        }
    }

    public boolean commit() {
        JdbcConnectionResource conn = this.getConnection();
        if (conn == null) {
            return false;
        }
        if (!this._inTransaction) {
            return false;
        }
        this._inTransaction = false;
        conn.commit();
        return conn.setAutoCommit(true);
    }

    public void close() {
        this.cleanup();
    }

    @Override
    public void cleanup() {
        JdbcConnectionResource conn = this._conn;
        this._conn = null;
        this.closeStatements();
        if (conn != null) {
            conn.close();
        }
    }

    public String errorCode() {
        return this._error.getErrorCode();
    }

    public ArrayValue errorInfo() {
        return this._error.getErrorInfo();
    }

    protected int getColumnCase() {
        return this._columnCase;
    }

    public Value exec(Env env, String query) {
        this._error.clear();
        JdbcConnectionResource conn = this.getConnection();
        if (!conn.isConnected()) {
            return BooleanValue.FALSE;
        }
        try {
            PDOStatement stmt;
            this._lastExecutedStatement = stmt = new PDOStatement(env, this, this._error, query, false, null, true);
            return LongValue.create(conn.getAffectedRows());
        }
        catch (SQLException e) {
            this._error.error(env, e);
            return BooleanValue.FALSE;
        }
    }

    public Value getAttribute(Env env, int attribute) {
        switch (attribute) {
            case 0: {
                if (this.getAutocommit()) {
                    return LongValue.ONE;
                }
                return LongValue.ZERO;
            }
            case 8: {
                return LongValue.create(this.getCase());
            }
            case 5: {
                String clientVersion = this.getConnection().getClientInfo(env);
                return env.createString(clientVersion);
            }
            case 7: {
                try {
                    String hostInfo = this.getConnection().getHostInfo();
                    return env.createString(hostInfo);
                }
                catch (SQLException e) {
                    env.warning(e);
                    return BooleanValue.FALSE;
                }
            }
            case 16: {
                String driverName = this.getConnection().getDriverName();
                return env.createString(driverName);
            }
            case 3: {
                return LongValue.create(this._error.getErrmode());
            }
            case 11: {
                return LongValue.create(this.getOracleNulls());
            }
            case 12: {
                return BooleanValue.create(this.getPersistent());
            }
            case 1: {
                return this.getPrefetch(env);
            }
            case 6: {
                return this.getConnection().getServerStat(env);
            }
            case 4: {
                return this.getServerVersion(env);
            }
            case 2: {
                return this.getTimeout(env);
            }
        }
        this._error.unsupportedAttribute(env, attribute);
        return BooleanValue.FALSE;
    }

    public static ArrayValue getAvailableDrivers() {
        ArrayValueImpl array = new ArrayValueImpl();
        array.put("mysql");
        array.put("pgsql");
        array.put("java");
        array.put("jdbc");
        array.put("sqlite");
        return array;
    }

    private boolean getAutocommit() {
        JdbcConnectionResource conn = this.getConnection();
        if (conn == null) {
            return true;
        }
        return conn.getAutoCommit();
    }

    public int getCase() {
        return this._columnCase;
    }

    public int getOracleNulls() {
        return 0;
    }

    private boolean getPersistent() {
        return true;
    }

    private Value getPrefetch(Env env) {
        env.warning(L.l("driver does not support prefetch"));
        return BooleanValue.FALSE;
    }

    private Value getServerVersion(Env env) {
        if (this._conn == null) {
            return BooleanValue.FALSE;
        }
        try {
            String info = this._conn.getServerInfo();
            return env.createString(info);
        }
        catch (SQLException e) {
            this._error.error(env, e);
            return BooleanValue.FALSE;
        }
    }

    private Value getTimeout(Env env) {
        env.warning(L.l("Driver does not support timeouts"));
        return BooleanValue.FALSE;
    }

    public String lastInsertId(Env env, @Optional Value nameV) {
        if (!nameV.isDefault()) {
            throw new UnimplementedException("lastInsertId with name");
        }
        if (this._lastExecutedStatement == null) {
            return "0";
        }
        try {
            String lastInsertId = this._lastExecutedStatement.lastInsertId(env);
            if (lastInsertId == null) {
                return "0";
            }
            return lastInsertId;
        }
        catch (SQLException e) {
            this._error.error(env, e);
            return "0";
        }
    }

    public Value prepare(Env env, String query, @Optional ArrayValue driverOptions) {
        if (!this.isConnected()) {
            return BooleanValue.FALSE;
        }
        try {
            PDOStatement pdoStatement;
            this._lastPDOStatement = pdoStatement = new PDOStatement(env, this, this._error, query, true, driverOptions, true);
            if (this._statementClassName != null) {
                QuercusClass cls = env.getClass(this._statementClassName);
                Value phpObject = cls.callNew(env, pdoStatement, this._statementClassArgs);
                return phpObject;
            }
            return env.wrapJava(pdoStatement);
        }
        catch (SQLException e) {
            this._error.error(env, e);
            return BooleanValue.FALSE;
        }
    }

    public Value query(Env env, String query, @Optional int mode, @Optional @ReadOnly Value[] args) {
        this._error.clear();
        JdbcConnectionResource conn = this.getConnection();
        if (!conn.isConnected()) {
            return BooleanValue.FALSE;
        }
        try {
            PDOStatement pdoStatement = new PDOStatement(env, this, this._error, query, false, null, true);
            if (mode != 0) {
                pdoStatement.setFetchMode(env, mode, args);
            }
            this._lastPDOStatement = pdoStatement;
            if (this._statementClassName != null) {
                QuercusClass cls = env.getClass(this._statementClassName);
                return cls.callNew(env, pdoStatement, this._statementClassArgs);
            }
            return env.wrapJava(pdoStatement);
        }
        catch (SQLException e) {
            this._error.error(env, e);
            return BooleanValue.FALSE;
        }
    }

    public String quote(String query, @Optional int parameterType) {
        return "'" + this.real_escape_string(query) + "'";
    }

    public String real_escape_string(String str) {
        StringBuilder buf = new StringBuilder();
        int strLength = str.length();
        block9: for (int i = 0; i < strLength; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\u0000': {
                    buf.append('\\');
                    buf.append('\u0000');
                    continue block9;
                }
                case '\n': {
                    buf.append('\\');
                    buf.append('n');
                    continue block9;
                }
                case '\r': {
                    buf.append('\\');
                    buf.append('r');
                    continue block9;
                }
                case '\\': {
                    buf.append('\\');
                    buf.append('\\');
                    continue block9;
                }
                case '\'': {
                    buf.append('\\');
                    buf.append('\'');
                    continue block9;
                }
                case '\"': {
                    buf.append('\\');
                    buf.append('\"');
                    continue block9;
                }
                case '\u001a': {
                    buf.append('\\');
                    buf.append('Z');
                    continue block9;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public boolean rollBack(Env env) {
        JdbcConnectionResource conn = this.getConnection();
        if (conn == null) {
            return false;
        }
        if (!this._inTransaction) {
            return false;
        }
        this._inTransaction = false;
        conn.rollback();
        return conn.setAutoCommit(true);
    }

    public boolean setAttribute(Env env, int attribute, Value value) {
        return this.setAttribute(env, attribute, value, false);
    }

    private boolean setAttribute(Env env, int attribute, Value value, boolean isInit) {
        switch (attribute) {
            case 0: {
                return this.setAutocommit(env, value.toBoolean());
            }
            case 3: {
                return this._error.setErrmode(env, value.toInt());
            }
            case 8: {
                return this.setCase(env, value.toInt());
            }
            case 11: {
                return this.setOracleNulls(env, value.toInt());
            }
            case 17: {
                return this.setStringifyFetches(value.toBoolean());
            }
            case 13: {
                if (!value.isArray()) {
                    env.warning(L.l("ATTR_STATEMENT_CLASS attribute must be an array"));
                    return false;
                }
                return this.setStatementClass(env, value.toArrayValue(env));
            }
            case 20: {
                return this.setEmulatePrepares(value.toBoolean());
            }
        }
        if (isInit) {
            switch (attribute) {
                case 2: {
                    return this.setTimeout(value.toInt());
                }
                case 12: {
                    return this.setPersistent(value.toBoolean());
                }
            }
        }
        this._error.unsupportedAttribute(env, attribute);
        return false;
    }

    private boolean setAutocommit(Env env, boolean autoCommit) {
        JdbcConnectionResource conn = this.getConnection();
        if (conn == null) {
            return false;
        }
        return conn.setAutoCommit(autoCommit);
    }

    private boolean setCase(Env env, int value) {
        switch (value) {
            case 2: {
                this._columnCase = 2;
                return true;
            }
            case 0: {
                this._columnCase = 0;
                return true;
            }
            case 1: {
                this._columnCase = 1;
                return true;
            }
        }
        this._error.unsupportedAttributeValue(env, env);
        return false;
    }

    private boolean setOracleNulls(Env env, int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: {
                throw new UnimplementedException();
            }
        }
        this._error.warning(env, L.l("unknown value `{0}'", value));
        this._error.unsupportedAttributeValue(env, value);
        return false;
    }

    private boolean setPersistent(boolean isPersistent) {
        return true;
    }

    private boolean setStatementClass(Env env, ArrayValue value) {
        Value className = value.get(LongValue.ZERO);
        if (!className.isString()) {
            return false;
        }
        this._statementClassName = className.toStringValue(env).toString();
        Value argV = value.get(LongValue.ONE);
        if (argV.isArray()) {
            ArrayValue array = argV.toArrayValue(env);
            this._statementClassArgs = array.valuesToArray();
        } else {
            this._statementClassArgs = Value.NULL_ARGS;
        }
        return true;
    }

    private boolean setEmulatePrepares(boolean isEmulate) {
        if (this._isEmulatePrepares == isEmulate) {
            return true;
        }
        if (this._conn != null) {
            return false;
        }
        this._isEmulatePrepares = isEmulate;
        return true;
    }

    private boolean setStringifyFetches(boolean stringifyFetches) {
        throw new UnimplementedException();
    }

    private boolean setTimeout(int timeoutSeconds) {
        throw new UnimplementedException();
    }

    private JdbcConnectionResource getConnection(Env env, String dsn, String user, String pass) throws SQLException {
        if (dsn.startsWith("mysql:")) {
            return this.getMysqlConnection(env, dsn, user, pass);
        }
        if (dsn.startsWith("pgsql:")) {
            return this.getPgsqlDataSource(env, dsn, user, pass);
        }
        if (dsn.startsWith("java")) {
            return this.getJndiDataSource(env, dsn, user, pass);
        }
        if (dsn.startsWith("jdbc:")) {
            return this.getJdbcDataSource(env, dsn, user, pass);
        }
        if (dsn.startsWith("resin:")) {
            return this.getResinDataSource(env, dsn);
        }
        if (dsn.startsWith("sqlite:")) {
            return this.getSqliteDataSource(env, dsn);
        }
        env.error(L.l("'{0}' is an unknown PDO data source.", (Object)dsn));
        return null;
    }

    private JdbcConnectionResource getMysqlConnection(Env env, String dsn, String user, String pass) throws SQLException {
        HashMap<String, String> attrMap = this.parseAttr(dsn, dsn.indexOf(58));
        String host = "localhost";
        int port = -1;
        String dbName = null;
        for (Map.Entry<String, String> entry : attrMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("host".equals(key)) {
                host = value;
                continue;
            }
            if ("port".equals(key)) {
                try {
                    port = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    env.warning(e);
                }
                continue;
            }
            if ("dbname".equals(key)) {
                dbName = value;
                continue;
            }
            if ("user".equals(key)) {
                user = value;
                continue;
            }
            if ("password".equals(key)) {
                pass = value;
                continue;
            }
            env.warning(L.l("pdo dsn attribute not supported: {0}={1}", (Object)key, (Object)value));
        }
        String socket = null;
        int flags = 0;
        String driver = null;
        String url = null;
        boolean isNewLink = false;
        return new Mysqli(env, host, user, pass, dbName, port, socket, flags, driver, url, isNewLink, this._isEmulatePrepares);
    }

    private JdbcConnectionResource getPgsqlDataSource(Env env, String dsn, String user, String pass) {
        HashMap<String, String> attrMap = this.parseAttr(dsn, dsn.indexOf(58));
        String host = "localhost";
        int port = -1;
        String dbName = null;
        for (Map.Entry<String, String> entry : attrMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("host".equals(key)) {
                host = value;
                continue;
            }
            if ("port".equals(key)) {
                try {
                    port = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    env.warning(e);
                }
                continue;
            }
            if ("dbname".equals(key)) {
                dbName = value;
                continue;
            }
            if ("user".equals(key)) {
                user = value;
                continue;
            }
            if ("password".equals(key)) {
                pass = value;
                continue;
            }
            env.warning(L.l("pdo dsn attribute not supported: {0}={1}", (Object)key, (Object)value));
        }
        String driver = null;
        String url = null;
        Postgres postgres = new Postgres(env, host, user, pass, dbName, port, driver, url);
        return postgres;
    }

    private JdbcConnectionResource getResinDataSource(Env env, String dsn) {
        try {
            String driver = "com.caucho.db.jdbc.ConnectionPoolDataSourceImpl";
            String url = "jdbc:" + dsn;
            DataSource ds = env.getDataSource(driver, url);
            return new DataSourceConnection(env, ds, null, null);
        }
        catch (Exception e) {
            env.warning(e);
            return null;
        }
    }

    private JdbcConnectionResource getJndiDataSource(Env env, String dsn, String user, String pass) {
        DataSource ds = null;
        try {
            InitialContext ic = new InitialContext();
            ds = (DataSource)ic.lookup(dsn);
        }
        catch (NamingException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (ds == null) {
            env.error(L.l("'{0}' is an unknown PDO JNDI data source.", (Object)dsn));
            return null;
        }
        return new DataSourceConnection(env, ds, user, pass);
    }

    private JdbcConnectionResource getJdbcDataSource(Env env, String dsn, String user, String pass) {
        JdbcDriverContext context = env.getQuercus().getJdbcDriverContext();
        int i = dsn.indexOf("jdbc:");
        int j = dsn.indexOf("://", i + 5);
        if (j < 0) {
            j = dsn.indexOf(":", i + 5);
        }
        if (j < 0) {
            return null;
        }
        String protocol = dsn.substring(i + 5, j);
        if ("sqlite".equals(protocol)) {
            return new SQLite3(env, dsn);
        }
        String driver = context.getDriver(protocol);
        if (driver == null) {
            return null;
        }
        try {
            DataSource ds = env.getDataSource(driver, dsn.toString());
            return new DataSourceConnection(env, ds, user, pass);
        }
        catch (Exception e) {
            env.warning(e);
            return null;
        }
    }

    private JdbcConnectionResource getSqliteDataSource(Env env, String dsn) {
        String jdbcUrl = "jdbc:" + dsn;
        return new SQLite3(env, jdbcUrl);
    }

    private HashMap<String, String> parseAttr(String dsn, int i) {
        LinkedHashMap<String, String> attr = new LinkedHashMap<String, String>();
        int length = dsn.length();
        StringBuilder sb = new StringBuilder();
        while (i < length) {
            char ch = dsn.charAt(i);
            if (Character.isJavaIdentifierStart(ch)) {
                while (i < length && Character.isJavaIdentifierPart(ch = dsn.charAt(i))) {
                    sb.append(ch);
                    ++i;
                }
                String name = sb.toString();
                sb.setLength(0);
                while (i < length && ((ch = dsn.charAt(i)) == ' ' || ch == '=')) {
                    ++i;
                }
                while (i < length && (ch = dsn.charAt(i)) != ' ' && ch != ';') {
                    sb.append(ch);
                    ++i;
                }
                String value = sb.toString();
                sb.setLength(0);
                attr.put(name, value);
            }
            ++i;
        }
        return attr;
    }

    public String toString() {
        if (this._dsn == null) {
            return "PDO[]";
        }
        if (this._dsn.indexOf("pass") < 0) {
            return "PDO[" + this._dsn + "]";
        }
        int i = this._dsn.lastIndexOf(58);
        if (i < 0) {
            return "PDO[]";
        }
        if (this._dsn.startsWith("java")) {
            return "PDO[" + this._dsn + "]";
        }
        StringBuilder str = new StringBuilder();
        str.append("PDO[");
        str.append(this._dsn, 0, i + 1);
        HashMap<String, String> attr = this.parseAttr(this._dsn, i);
        boolean first = true;
        for (Map.Entry<String, String> entry : attr.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("password".equalsIgnoreCase(key)) {
                value = "XXXXX";
            } else if ("passwd".equalsIgnoreCase(key)) {
                value = "XXXXX";
            } else if ("pass".equalsIgnoreCase(key)) {
                value = "XXXXX";
            }
            if (!first) {
                str.append(' ');
            }
            first = false;
            str.append(key);
            str.append("=");
            str.append(value);
        }
        str.append("]");
        return str.toString();
    }
}

