/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.spl;

import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.spl.Iterator;
import com.caucho.quercus.lib.spl.SeekableIterator;
import com.caucho.quercus.lib.spl.SplFileInfo;
import com.caucho.quercus.lib.spl.SplFileObject;
import com.caucho.quercus.lib.spl.Traversable;
import com.caucho.vfs.Path;
import java.io.IOException;

public class DirectoryIterator
extends SplFileInfo
implements Iterator,
Traversable,
SeekableIterator {
    private String[] _list;
    private int _index;
    private SplFileInfo _current;

    public DirectoryIterator(Env env, StringValue fileName) {
        super(env, fileName);
        try {
            this._list = this._path.list();
        }
        catch (IOException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    protected DirectoryIterator(Path path) {
        super(path);
        try {
            this._list = path.list();
        }
        catch (IOException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    public Value current(Env env) {
        SplFileInfo current = this.getCurrent(env);
        return current != null ? env.wrapJava(this) : UnsetValue.UNSET;
    }

    protected SplFileInfo getCurrent(Env env) {
        if (this._current == null && this._index < this._list.length) {
            String name = this._list[this._index];
            Path child = this._path.lookup(name);
            this._current = this.createCurrent(env, child);
        }
        return this._current;
    }

    protected SplFileInfo createCurrent(Env env, Path path) {
        return new SplFileInfo(path);
    }

    protected int getKey() {
        return this._index;
    }

    public boolean isDot(Env env) {
        SplFileInfo current = this.getCurrent(env);
        String fileName = current.getFilename(env);
        return ".".equals(fileName) || "..".equals(fileName);
    }

    public Value key(Env env) {
        return LongValue.create(this._index);
    }

    public void next(Env env) {
        ++this._index;
        this._current = null;
    }

    public void rewind(Env env) {
        this._index = 0;
    }

    public boolean valid(Env env) {
        return this._index < this._list.length;
    }

    public void seek(Env env, int index) {
        this._index = index;
    }

    public long getATime(Env env) {
        return this.getCurrent(env).getATime(env);
    }

    public String getBasename(Env env, @Optional String suffix) {
        return this.getCurrent(env).getBasename(env, suffix);
    }

    public long getCTime(Env env) {
        return this.getCurrent(env).getCTime(env);
    }

    public String getExtension(Env env) {
        return this.getCurrent(env).getExtension(env);
    }

    public SplFileInfo getFileInfo(Env env, @Optional String className) {
        return this.getCurrent(env).getFileInfo(env, className);
    }

    public String getFilename(Env env) {
        return this.getCurrent(env).getFilename(env);
    }

    public int getGroup(Env env) {
        return this.getCurrent(env).getGroup(env);
    }

    public long getInode(Env env) {
        return this.getCurrent(env).getInode(env);
    }

    public String getLinkTarget(Env env) {
        return this.getCurrent(env).getLinkTarget(env);
    }

    public long getMTime(Env env) {
        return this.getCurrent(env).getMTime(env);
    }

    public int getOwner(Env env) {
        return this.getCurrent(env).getOwner(env);
    }

    public String getPath(Env env) {
        return this.getCurrent(env).getPath(env);
    }

    public SplFileInfo getPathInfo(Env env, @Optional String className) {
        return this.getCurrent(env).getPathInfo(env, className);
    }

    public String getPathname(Env env) {
        return this.getCurrent(env).getPathname(env);
    }

    public int getPerms(Env env) {
        return this.getCurrent(env).getPerms(env);
    }

    public String getRealPath(Env env) {
        return this.getCurrent(env).getRealPath(env);
    }

    public long getSize(Env env) {
        return this.getCurrent(env).getSize(env);
    }

    public String getType(Env env) {
        return this.getCurrent(env).getType(env);
    }

    public boolean isDir(Env env) {
        return this.getCurrent(env).isDir(env);
    }

    public boolean isExecutable(Env env) {
        return this.getCurrent(env).isExecutable(env);
    }

    public boolean isFile(Env env) {
        return this.getCurrent(env).isFile(env);
    }

    public boolean isLink(Env env) {
        return this.getCurrent(env).isLink(env);
    }

    public boolean isReadable(Env env) {
        return this.getCurrent(env).isReadable(env);
    }

    public boolean isWritable(Env env) {
        return this.getCurrent(env).isWritable(env);
    }

    public SplFileObject openFile(Env env, @Optional(value="r") String mode, @Optional boolean isUseIncludePath, @Optional Value context) {
        return this.getCurrent(env).openFile(env, mode, isUseIncludePath, context);
    }

    public String __toString(Env env) {
        return this.getCurrent(env).__toString(env);
    }
}

