/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.spl;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.spl.DirectoryIterator;
import com.caucho.quercus.lib.spl.SplFileInfo;
import com.caucho.vfs.Path;

public class FilesystemIterator
extends DirectoryIterator {
    public static final int CURRENT_AS_PATHNAME = 32;
    public static final int CURRENT_AS_FILEINFO = 0;
    public static final int CURRENT_AS_SELF = 16;
    public static final int CURRENT_MODE_MASK = 240;
    public static final int KEY_AS_PATHNAME = 0;
    public static final int KEY_AS_FILENAME = 256;
    public static final int FOLLOW_SYMLINKS = 512;
    public static final int KEY_MODE_MASK = 3840;
    public static final int NEW_CURRENT_AND_KEY = 256;
    public static final int SKIP_DOTS = 4096;
    public static final int UNIX_PATHS = 8192;
    private int _flags;

    public FilesystemIterator(Env env, StringValue fileName, @Optional(value="-1") int flags) {
        super(env, fileName);
        if (flags < 0) {
            flags = 4096;
        }
        this._flags = flags;
    }

    protected FilesystemIterator(Path path, int flags) {
        super(path);
        this._flags = flags;
    }

    public int getFlags() {
        return this._flags;
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    public Value key(Env env) {
        int flags = this._flags;
        if ((flags & 0) == 0) {
            SplFileInfo current = this.getCurrent(env);
            if (current == null) {
                return UnsetValue.UNSET;
            }
            String path = current.getPathname(env);
            return env.createString(path);
        }
        if ((flags & 0x100) == 256) {
            SplFileInfo current = this.getCurrent(env);
            if (current == null) {
                return UnsetValue.UNSET;
            }
            String path = current.getFilename(env);
            return env.createString(path);
        }
        return super.key(env);
    }
}

