/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.spl;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.spl.Iterator;
import com.caucho.quercus.lib.spl.OuterIterator;
import com.caucho.quercus.lib.spl.RecursiveIterator;
import com.caucho.quercus.lib.spl.Traversable;
import java.util.ArrayList;

public class RecursiveIteratorIterator
implements OuterIterator,
Traversable,
Iterator {
    public static final int LEAVES_ONLY = 0;
    public static final int SELF_FIRST = 1;
    public static final int CHILD_FIRST = 2;
    public static final int CATCH_GET_CHILD = 16;
    private final Iterator _iterator;
    private ArrayList<Iterator> _iteratorStack;
    private Value _currentValue;
    private Value _currentKey;
    private final int _mode;

    public RecursiveIteratorIterator(Env env, Iterator iterator, @Optional int mode, @Optional int flags) {
        this._iterator = iterator;
        this._iteratorStack = new ArrayList();
        this._mode = mode;
        this.rewind(env);
    }

    public Iterator getInnerIterator() {
        return this._iterator;
    }

    public Value current(Env env) {
        Value value = this._currentValue;
        if (value != null) {
            return value;
        }
        return NullValue.NULL;
    }

    public Value key(Env env) {
        Value key = this._currentKey;
        if (key != null) {
            return key;
        }
        return NullValue.NULL;
    }

    public void next(Env env) {
        Iterator iter;
        this._currentKey = null;
        this._currentValue = null;
        boolean isJustPopped = false;
        while ((iter = this.getCurrentIterator()) != null) {
            boolean oldIsJustPopped = isJustPopped;
            isJustPopped = false;
            if (!iter.valid(env)) {
                this.pop();
                isJustPopped = true;
                continue;
            }
            if (oldIsJustPopped && (this._mode & 2) == 2) {
                this._currentKey = iter.key(env);
                this._currentValue = iter.current(env);
                iter.next(env);
                break;
            }
            if (!this.recurse(env, iter)) continue;
            break;
        }
    }

    public void rewind(Env env) {
        this.init(env);
    }

    private void init(Env env) {
        Iterator iter = this._iterator;
        if (iter == null) {
            return;
        }
        iter.rewind(env);
        this._iteratorStack.clear();
        this.push(iter);
        this.recurse(env, iter);
    }

    private boolean recurse(Env env, Iterator iterator) {
        if (!iterator.valid(env)) {
            return false;
        }
        Value currentKey = iterator.key(env);
        Value currentValue = iterator.current(env);
        Object obj = currentValue.toJavaObject();
        if (obj instanceof RecursiveIterator) {
            RecursiveIterator r = (RecursiveIterator)obj;
            this.push(r);
            if ((this._mode & 1) == 1) {
                this._currentKey = currentKey;
                this._currentValue = currentValue;
                iterator.next(env);
                return true;
            }
            if ((this._mode & 2) == 2) {
                return this.recurse(env, r);
            }
            iterator.next(env);
            return this.recurse(env, r);
        }
        this._currentKey = currentKey;
        this._currentValue = currentValue;
        iterator.next(env);
        return true;
    }

    public boolean valid(Env env) {
        return this._currentKey != null;
    }

    private Iterator getCurrentIterator() {
        int size = this._iteratorStack.size();
        if (size == 0) {
            return null;
        }
        return this._iteratorStack.get(size - 1);
    }

    private void push(Iterator iterator) {
        this._iteratorStack.add(iterator);
    }

    private void pop() {
        int size = this._iteratorStack.size();
        this._iteratorStack.remove(size - 1);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._iterator + "]";
    }

    static class Entry {
        private final Iterator _iterator;
        private boolean _isVisited;

        public Entry(Iterator iterator) {
            this._iterator = iterator;
        }

        public Iterator getIterator() {
            return this._iterator;
        }

        public boolean isVisited() {
            return this._isVisited;
        }

        public void setVisited() {
            this._isVisited = true;
        }
    }
}

